/*
 * Decompiled with CFR 0.152.
 */
package multiblock;

import cd4017be.lib.TickRegistry;
import cd4017be.lib.templates.MultiblockComp;
import cd4017be.lib.templates.SharedNetwork;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import multiblock.IntegerComp;

public class SharedInteger
extends SharedNetwork<IntegerComp, SharedInteger>
implements TickRegistry.IUpdatable {
    private static final short AllIn = 21845;
    private static final short AllOut = -21846;
    public HashSet<IntegerComp> inputs = new HashSet();
    public HashSet<IntegerComp> outputs = new HashSet();
    public int outputState = 0;
    public boolean updateState;

    protected SharedInteger(HashMap<Long, IntegerComp> comps) {
        super(comps);
    }

    public SharedInteger(IntegerComp comp) {
        super((MultiblockComp)comp);
        if ((comp.rsIO & 0x5555) != 0) {
            this.inputs.add(comp);
        }
        if ((comp.rsIO & 0xFFFFAAAA) != 0) {
            this.outputs.add(comp);
        }
        this.outputState = comp.inputState;
    }

    public void onMerged(SharedInteger network) {
        super.onMerged((SharedNetwork)network);
        this.outputState &= network.outputState;
        this.markStateDirty();
        this.inputs.addAll(network.inputs);
        this.outputs.addAll(network.outputs);
    }

    public void remove(IntegerComp comp) {
        super.remove((MultiblockComp)comp);
        if ((comp.rsIO & 0x5555) != 0) {
            this.inputs.remove((Object)comp);
            this.markStateDirty();
        }
        if ((comp.rsIO & 0xFFFFAAAA) != 0) {
            this.outputs.remove((Object)comp);
        }
    }

    public SharedInteger onSplit(HashMap<Long, IntegerComp> comps) {
        SharedInteger si = new SharedInteger(comps);
        si.outputState = this.outputState;
        for (IntegerComp c : comps.values()) {
            if ((c.rsIO & 0x5555) != 0) {
                this.inputs.remove((Object)c);
                si.inputs.add(c);
                this.markStateDirty();
            }
            if ((c.rsIO & 0xFFFFAAAA) == 0) continue;
            this.outputs.remove((Object)c);
            si.outputs.add(c);
        }
        si.markStateDirty();
        return si;
    }

    public void setIO(IntegerComp c, short con) {
        if ((con & 0x5555) != 0 && (c.rsIO & 0x5555) == 0) {
            this.inputs.add(c);
        } else if ((con & 0x5555) == 0 && (c.rsIO & 0x5555) != 0) {
            this.inputs.remove((Object)c);
        }
        if ((con & 0xFFFFAAAA) != 0 && (c.rsIO & 0xFFFFAAAA) == 0) {
            this.outputs.add(c);
        } else if ((con & 0xFFFFAAAA) == 0 && (c.rsIO & 0xFFFFAAAA) != 0) {
            this.outputs.remove((Object)c);
        }
        c.rsIO = con;
        this.markStateDirty();
    }

    protected void updatePhysics() {
        if (this.updateState) {
            int newState = 0;
            for (IntegerComp c : this.inputs) {
                newState |= c.inputState;
            }
            if (newState != this.outputState) {
                this.outputState = newState;
                for (IntegerComp c : this.outputs) {
                    c.onStateChange();
                }
            }
            this.updateState = false;
        }
    }

    public void markDirty() {
        if (!this.update) {
            this.update = true;
            TickRegistry.instance.updates.add(this);
        }
    }

    public void markStateDirty() {
        if (!this.updateState) {
            this.updateState = true;
            TickRegistry.instance.updates.add(this);
        }
    }

    public void process() {
        if (this.update) {
            Iterator iterator;
            if (this.core == null && (iterator = this.components.values().iterator()).hasNext()) {
                IntegerComp c = (IntegerComp)((Object)iterator.next());
                this.core = c;
            }
            this.reassembleNetwork();
            this.update = false;
        }
        this.updatePhysics();
    }
}

