/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.ISensor;
import cd4017be.circuits.render.OszillographRenderer;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class Oszillograph
extends BaseTileEntity
implements AdvancedBlock.ITilePlaceHarvest,
ITickable,
DataContainer.IGuiData,
IDirectionalRedstone,
BlockGuiHandler.ClientPacketReceiver {
    private static final float[] DefTransf = new float[]{15.0f, 0.0f, 15.0f, 0.0f, 15.0f, 0.0f, 15.0f, 0.0f};
    public static final int Size = 60;
    public final BasicInventory inventory = new BasicInventory(4);
    public final int[][] points = new int[4][];
    public final float[] transf = Arrays.copyOf(DefTransf, 8);
    public long cfg = 0x3E003E003E003E00L;
    public int idx = 59;
    public int tickInt = 1;
    public int mode = 0;
    public final String[] info = new String[]{"", "", "", ""};
    public float triggerLevel = 0.0f;
    public final int[][] vertexData = new int[4][];

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if (t % (long)this.tickInt != 0L || !this.checkTrigger(t)) {
            return;
        }
        ++this.idx;
        this.idx %= 60;
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i] == null) continue;
            ItemStack item = this.inventory.getStackInSlot(i);
            double nstate = !item.func_190926_b() && item.func_77973_b() instanceof ISensor ? ((ISensor)item.func_77973_b()).measure(item, this.field_145850_b, this.field_174879_c) : this.getRedstone((int)(this.cfg >> i * 16 + 1) & 0x3FFF);
            float l = this.transf[i * 2 + 1];
            float h = this.transf[i * 2];
            nstate = (nstate - (double)l) / (double)(h - l);
            this.points[i][this.idx] = Float.floatToIntBits(Math.min(0.5f, Math.max(-0.5f, (float)nstate - 0.5f)));
        }
        this.markUpdate();
    }

    private double getRedstone(int cfg) {
        long sgnMask;
        EnumFacing side = EnumFacing.field_82609_l[(cfg & 7) % 6];
        long r = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(side), side);
        int shift = cfg >> 3 & 0x1F;
        int size = cfg >> 8 & 0x1F;
        r = r >> shift & 0xFFFFFFFFL >>> 31 - size;
        if ((cfg & 0x2000) != 0 && (r & (sgnMask = 1L << size)) != 0L) {
            return (r & (sgnMask ^ 0xFFFFFFFFFFFFFFFFL)) - sgnMask;
        }
        return r;
    }

    private boolean checkTrigger(long t) {
        double x;
        if (this.idx > 0) {
            return true;
        }
        int m = this.mode & 3;
        if (m == 3) {
            return false;
        }
        if (m == 0) {
            return t / (long)this.tickInt % 60L == 0L;
        }
        int s = this.mode >> 2 & 7;
        if (m == 1) {
            EnumFacing side = EnumFacing.field_82609_l[s % 6];
            x = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(side), side);
        } else {
            ItemStack item = this.inventory.getStackInSlot(s % 4);
            x = !item.func_190926_b() && item.func_77973_b() instanceof ISensor ? ((ISensor)item.func_77973_b()).measure(item, this.field_145850_b, this.field_174879_c) : 0.0;
        }
        return (this.mode & 0x20) != 0 ? x < (double)this.triggerLevel : x > (double)this.triggerLevel;
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer sender) throws IOException {
        block10: {
            byte cmd;
            block11: {
                block12: {
                    block9: {
                        cmd = dis.readByte();
                        if (cmd >= 8) break block9;
                        this.transf[cmd] = dis.readFloat();
                        break block10;
                    }
                    if (cmd != 8) break block11;
                    this.tickInt = dis.readInt();
                    if (this.tickInt >= 1) break block12;
                    this.tickInt = 1;
                    break block10;
                }
                if (this.tickInt <= 1200) break block10;
                this.tickInt = 1200;
                break block10;
            }
            if (cmd == 9) {
                this.mode = dis.readInt();
            } else if (cmd < 14) {
                this.info[cmd - 10] = dis.func_150789_c(16);
            } else if (cmd == 14) {
                this.triggerLevel = dis.readFloat();
            } else if (cmd == 15) {
                this.cfg = dis.readLong();
                for (int i = 0; i < 4; ++i) {
                    boolean active;
                    boolean bl = active = (this.cfg >> i * 16 & 1L) != 0L;
                    if (active && this.points[i] == null) {
                        this.points[i] = new int[60];
                        continue;
                    }
                    if (active || this.points[i] == null) continue;
                    this.points[i] = null;
                }
            }
        }
        this.markUpdate();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        int[] arr = nbt.func_74759_k("cfg");
        for (i = 0; i < 8; ++i) {
            this.transf[i] = arr.length > i ? Float.intBitsToFloat(arr[i]) : DefTransf[i];
        }
        this.tickInt = nbt.func_74765_d("tick");
        if (this.tickInt <= 0) {
            this.tickInt = 1;
        }
        this.idx = nbt.func_74765_d("px");
        this.mode = nbt.func_74762_e("mode");
        this.cfg = nbt.func_74763_f("cfgI");
        this.triggerLevel = nbt.func_74760_g("level");
        for (i = 0; i < 4; ++i) {
            this.info[i] = nbt.func_74779_i("inf" + i);
            this.points[i] = nbt.func_74759_k("py" + i);
            if (this.points[i].length == 60) continue;
            this.points[i] = null;
        }
        this.inventory.read(nbt.func_150295_c("items", 10));
        super.func_145839_a(nbt);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && (this.field_145850_b != null ? this.field_145850_b.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT)) {
            this.setupGraph();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        int i;
        int[] arr = new int[8];
        for (i = 0; i < 8; ++i) {
            arr[i] = Float.floatToIntBits(this.transf[i]);
        }
        nbt.func_74783_a("cfg", arr);
        nbt.func_74777_a("px", (short)this.idx);
        nbt.func_74777_a("tick", (short)this.tickInt);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74772_a("cfgI", this.cfg);
        nbt.func_74776_a("level", this.triggerLevel);
        for (i = 0; i < 4; ++i) {
            nbt.func_74778_a("inf" + i, this.info[i]);
            if (this.points[i] == null) continue;
            nbt.func_74783_a("py" + i, this.points[i]);
        }
        nbt.func_74782_a("items", (NBTBase)this.inventory.write());
        return super.func_189515_b(nbt);
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        for (int i = 0; i < 4; ++i) {
            cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, i, 80, 16 + i * 18));
        }
        cont.addPlayerInventory(8, 122);
    }

    public int[] getSyncVariables() {
        int i;
        int[] arr = new int[17];
        for (i = 0; i < 8; ++i) {
            arr[i] = Float.floatToIntBits(this.transf[i]);
        }
        for (i = 0; i < 4; ++i) {
            if (this.points[i] == null) continue;
            arr[i + 8] = this.points[i][this.idx];
        }
        arr[12] = this.tickInt;
        arr[13] = this.mode;
        arr[14] = Float.floatToIntBits(this.triggerLevel);
        arr[15] = (int)this.cfg;
        arr[16] = (int)(this.cfg >> 32);
        return arr;
    }

    public void setSyncVariable(int i, int v) {
        if (i < 8) {
            this.transf[i] = Float.intBitsToFloat(v);
        } else if (i == 12) {
            this.tickInt = v;
        } else if (i == 13) {
            this.mode = v;
        } else if (i == 14) {
            this.triggerLevel = Float.intBitsToFloat(v);
        } else if (i == 15) {
            this.cfg = Utils.setState((long)this.cfg, (int)0, (long)0xFFFFFFFFL, (int)v);
        } else if (i == 16) {
            this.cfg = Utils.setState((long)this.cfg, (int)32, (long)0xFFFFFFFFL, (int)v);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("x", (short)this.idx);
        for (int i = 0; i < 4; ++i) {
            nbt.func_74778_a("inf" + i, this.info[i]);
            if (this.points[i] == null) continue;
            nbt.func_74776_a("y" + i, Float.intBitsToFloat(this.points[i][this.idx]));
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    private void setupGraph() {
        for (int i = 0; i < 4; ++i) {
            int[] data = this.points[i];
            if (data == null) continue;
            int[] vb = OszillographRenderer.newVertexData(60);
            for (int j = 0; j < 60; ++j) {
                OszillographRenderer.setValue(vb, j, Float.intBitsToFloat(data[j]));
            }
            this.vertexData[i] = vb;
            this.points[i] = null;
            OszillographRenderer.recolor(this.vertexData[i], this.idx, OszillographRenderer.colors[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.idx = nbt.func_74765_d("x");
        if (this.idx < 0) {
            this.idx = 0;
        } else if (this.idx >= 60) {
            this.idx = 59;
        }
        for (int i = 0; i < 4; ++i) {
            this.info[i] = nbt.func_74779_i("inf" + i);
            NBTBase tag = nbt.func_74781_a("y" + i);
            if (tag == null) {
                this.vertexData[i] = null;
                continue;
            }
            if (this.vertexData[i] == null) {
                this.vertexData[i] = OszillographRenderer.newVertexData(60);
            }
            if (tag instanceof NBTTagFloat) {
                OszillographRenderer.setValue(this.vertexData[i], this.idx, ((NBTTagFloat)tag).func_150288_h());
            }
            OszillographRenderer.recolor(this.vertexData[i], this.idx, OszillographRenderer.colors[i]);
        }
    }

    public byte getRSDirection(EnumFacing s) {
        return 1;
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        for (ItemStack item : this.inventory.items) {
            if (item.func_190926_b()) continue;
            list.add(item);
        }
        return list;
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
    }
}

