/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Display8bit
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
IDirectionalRedstone,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver {
    public int state;
    public short dspType = (short)3970;
    public String text0 = "";
    public String text1 = "";
    public String format = "###";
    public int display = 0x3080808;

    public void neighborBlockChange(Block b, BlockPos src) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int nState = 0;
        for (EnumFacing s : EnumFacing.field_82609_l) {
            nState |= this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(s), s);
        }
        if (nState != this.state) {
            this.state = nState;
            this.formatState();
            this.markUpdate();
        }
    }

    public void neighborTileChange(BlockPos src) {
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        byte cmd = data.readByte();
        if (cmd == 0) {
            this.dspType = data.readShort();
            this.formatState();
        } else if (cmd == 1) {
            this.format = data.func_150789_c(8);
            this.formatState();
        } else if (cmd == 2) {
            this.text0 = data.func_150789_c(16);
        } else if (cmd == 3) {
            this.text1 = data.func_150789_c(16);
        }
        this.markUpdate();
    }

    private void formatState() {
        boolean sign;
        int m = this.dspType & 3;
        long s = this.state;
        if (m == 0 || m == 3) {
            this.display = (int)s;
            return;
        }
        long sgnMask = 1L << (this.dspType >> 7 & 0x1F);
        boolean bl = sign = (s & sgnMask) != 0L;
        if (sign && this.format.indexOf(43) >= 0) {
            s = sgnMask - (s & (sgnMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.display = 0;
        int n = 0;
        block11: for (int i = this.format.length() - 1; i >= 0 && n < 3; --i) {
            int d;
            char c = this.format.charAt(i);
            switch (c) {
                case '#': {
                    if (m == 1) {
                        d = ((int)s & 0xF) + 8;
                        s >>>= 4;
                        break;
                    }
                    d = (int)(s % 10L) + 8;
                    s /= 10L;
                    break;
                }
                case '$': {
                    if (m == 1) {
                        s >>>= 4;
                        continue block11;
                    }
                    s /= 10L;
                    continue block11;
                }
                case 'S': 
                case 's': {
                    if (i <= 0 || (c = this.format.charAt(--i)) <= '0' || c > '9') continue block11;
                    if (m == 1) {
                        s >>>= (c - 48) * 4;
                        continue block11;
                    }
                    for (int j = c - 48; j > 0; --j) {
                        s /= 10L;
                    }
                    continue block11;
                }
                case ':': {
                    d = 24;
                    break;
                }
                case '.': {
                    d = 25;
                    break;
                }
                case '-': {
                    d = 26;
                    break;
                }
                case '%': {
                    d = 27;
                    break;
                }
                case '_': {
                    d = 28;
                    break;
                }
                case '+': {
                    d = sign ? 26 : 28;
                    break;
                }
                default: {
                    d = c >= '0' && c <= '9' ? c - 48 + 8 : (c >= 'a' && c <= 'f' ? c - 97 + 18 : (c >= 'A' && c <= 'F' ? c - 65 + 18 : 29));
                }
            }
            this.display |= (d & 0xFF) << 8 * n++;
        }
        this.display |= n << 24;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.state = pkt.func_148857_g().func_74762_e("state");
        this.dspType = pkt.func_148857_g().func_74765_d("dsp");
        this.text0 = pkt.func_148857_g().func_74779_i("t0");
        this.text1 = pkt.func_148857_g().func_74779_i("t1");
        this.format = pkt.func_148857_g().func_74779_i("form");
        this.display = pkt.func_148857_g().func_74762_e("td");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("state", this.state);
        nbt.func_74777_a("dsp", this.dspType);
        nbt.func_74778_a("t0", this.text0);
        nbt.func_74778_a("t1", this.text1);
        nbt.func_74778_a("form", this.format);
        nbt.func_74768_a("td", this.display);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("state", this.state);
        nbt.func_74777_a("mode", this.dspType);
        nbt.func_74778_a("t0", this.text0);
        nbt.func_74778_a("t1", this.text1);
        nbt.func_74778_a("form", this.format);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = nbt.func_74762_e("state");
        this.dspType = nbt.func_74765_d("mode");
        this.text0 = nbt.func_74779_i("t0");
        this.text1 = nbt.func_74779_i("t1");
        this.format = nbt.func_74779_i("form");
        this.formatState();
    }

    public byte getRSDirection(EnumFacing s) {
        return 1;
    }

    public void initContainer(DataContainer container) {
    }

    public int[] getSyncVariables() {
        return null;
    }

    public void setSyncVariable(int i, int v) {
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }
}

