/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.circuits.tileEntity.CircuitDesigner;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Circuit
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
AdvancedBlock.IRedstoneTile,
AdvancedBlock.ITilePlaceHarvest,
IDirectionalRedstone,
DataContainer.IGuiData,
ITickable,
IQuickRedstoneHandler,
BlockGuiHandler.ClientPacketReceiver {
    public static final int[] ClockSpeed = new int[]{20, 5, 1};
    private static final Random RANDOM = new Random();
    private static final int[] LIMIT = new int[]{-128, Short.MIN_VALUE, -8388608, Integer.MIN_VALUE, 127, Short.MAX_VALUE, 0x7FFFFF, Integer.MAX_VALUE};
    public static final byte C_NULL = 0;
    public static final byte C_IN = 1;
    public static final byte C_OR = 2;
    public static final byte C_NOR = 3;
    public static final byte C_AND = 4;
    public static final byte C_NAND = 5;
    public static final byte C_XOR = 6;
    public static final byte C_NXOR = 7;
    public static final byte C_REP = 8;
    public static final byte C_NOT = 9;
    public static final byte C_LS = 10;
    public static final byte C_NLS = 11;
    public static final byte C_EQ = 12;
    public static final byte C_NEQ = 13;
    public static final byte C_NEG = 14;
    public static final byte C_ABS = 15;
    public static final byte C_ADD = 16;
    public static final byte C_SUB = 17;
    public static final byte C_MUL = 18;
    public static final byte C_DIV = 19;
    public static final byte C_MOD = 20;
    public static final byte C_MIN = 21;
    public static final byte C_MAX = 22;
    public static final byte C_SWT = 23;
    public static final byte C_CNT = 24;
    public static final byte C_CNT_ = 25;
    public static final byte C_RNG = 26;
    public static final byte C_SQRT = 27;
    public String name = "";
    public int var;
    public final IOacc[] ioacc = new IOacc[6];
    public IOcfg[] iocfg = new IOcfg[0];
    public byte[] ram = new byte[0];
    public int tickInt = ClockSpeed[0];
    private long nextUpdate = 0L;
    public byte mode = 0;
    public int startIdx;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.mode == 0 || this.ram.length == 0) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if (t == this.nextUpdate) {
            if (this.mode == 1) {
                this.nextUpdate += (long)this.tickInt;
            } else if (this.mode == 3) {
                ++this.nextUpdate;
                this.mode = (byte)7;
            } else {
                --this.nextUpdate;
                this.mode = (byte)(this.mode & 3);
            }
            try {
                int[] out = this.cpuTick();
                for (IOacc acc : this.ioacc) {
                    if (acc == null) continue;
                    acc.update(out[acc.side.ordinal()]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ram = new byte[0];
                this.name = "\u00ef\u00bf\u00bdcERROR: invalid code!\u00ef\u00bf\u00bd8";
            }
        }
    }

    private int[] cpuTick() {
        int x;
        int idxIO = 0;
        int n = 0;
        block35: for (int i = this.startIdx; i < this.ram.length; ++i) {
            byte cmd = this.ram[i];
            int s = cmd >> 6 & 3;
            switch (cmd & 0x3F) {
                case 0: {
                    n += s + 1;
                    continue block35;
                }
                case 1: {
                    IOcfg cfg = this.iocfg[idxIO++];
                    x = this.ioacc[cfg.side].stateI >> cfg.ofs;
                    break;
                }
                case 2: {
                    s += i;
                    x = 0;
                    while (i <= s) {
                        x |= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)x;
                    continue block35;
                }
                case 3: {
                    s += i;
                    x = 0;
                    while (i <= s) {
                        x |= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)(~x);
                    continue block35;
                }
                case 4: {
                    s += i;
                    x = 255;
                    while (i <= s) {
                        x &= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)x;
                    continue block35;
                }
                case 5: {
                    s += i;
                    x = 255;
                    while (i <= s) {
                        x &= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)(~x);
                    continue block35;
                }
                case 6: {
                    s += i;
                    x = 0;
                    while (i <= s) {
                        x ^= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)x;
                    continue block35;
                }
                case 7: {
                    s += i;
                    x = 255;
                    while (i <= s) {
                        x ^= this.getBool(this.ram[++i]);
                    }
                    this.ram[n++] = (byte)x;
                    continue block35;
                }
                case 8: {
                    x = this.getNum(this.ram[++i]);
                    break;
                }
                case 9: {
                    this.ram[n++] = (byte)(~this.getBool(this.ram[++i]));
                    continue block35;
                }
                case 10: {
                    this.ram[n++] = this.getNum(this.ram[++i]) < this.getNum(this.ram[++i]) ? -1 : 0;
                    continue block35;
                }
                case 11: {
                    this.ram[n++] = this.getNum(this.ram[++i]) >= this.getNum(this.ram[++i]) ? -1 : 0;
                    continue block35;
                }
                case 12: {
                    this.ram[n++] = this.getNum(this.ram[++i]) == this.getNum(this.ram[++i]) ? -1 : 0;
                    continue block35;
                }
                case 13: {
                    this.ram[n++] = this.getNum(this.ram[++i]) != this.getNum(this.ram[++i]) ? -1 : 0;
                    continue block35;
                }
                case 14: {
                    x = -this.getNum(this.ram[++i]);
                    break;
                }
                case 15: {
                    x = Math.abs(this.getNum(this.ram[++i]));
                    break;
                }
                case 16: {
                    x = this.getNum(this.ram[++i]) + this.getNum(this.ram[++i]);
                    break;
                }
                case 17: {
                    x = this.getNum(this.ram[++i]) - this.getNum(this.ram[++i]);
                    break;
                }
                case 18: {
                    x = this.getNum(this.ram[++i]) * this.getNum(this.ram[++i]);
                    break;
                }
                case 19: {
                    int a = this.getNum(this.ram[++i]);
                    int b = this.getNum(this.ram[++i]);
                    x = b != 0 ? Math.floorDiv(a, b) : LIMIT[s | (a >= 0 ? 4 : 0)];
                    break;
                }
                case 20: {
                    int a = this.getNum(this.ram[++i]);
                    int b = this.getNum(this.ram[++i]);
                    x = b != 0 ? Math.floorMod(a, b) : 0;
                    break;
                }
                case 21: {
                    x = Math.min(this.getNum(this.ram[++i]), this.getNum(this.ram[++i]));
                    break;
                }
                case 22: {
                    x = Math.max(this.getNum(this.ram[++i]), this.getNum(this.ram[++i]));
                    break;
                }
                case 23: {
                    x = this.getNum(this.ram[this.ram[++i] & 0x3F] != 0 ? this.ram[i + 2] : this.ram[i + 1]);
                    i += 2;
                    break;
                }
                case 24: {
                    if (this.ram[this.ram[i + 2] & 0x3F] != 0) {
                        x = 0;
                    } else if (this.ram[this.ram[i + 1] & 0x3F] != 0) {
                        x = this.getNum(n | s << 6) + 1;
                    } else {
                        n += s + 1;
                        i += 2;
                        continue block35;
                    }
                    i += 2;
                    break;
                }
                case 25: {
                    if (this.ram[this.ram[i + 2] & 0x3F] != 0) {
                        x = this.getNum(this.ram[i + 4]);
                    } else if (this.ram[this.ram[i + 1] & 0x3F] != 0) {
                        x = this.getNum(this.ram[i + 3]) + this.getNum(n | s << 6);
                    } else {
                        n += s + 1;
                        i += 4;
                        continue block35;
                    }
                    i += 4;
                    break;
                }
                case 26: {
                    int a = this.getNum(this.ram[++i]);
                    x = a > 0 ? RANDOM.nextInt(a) : (a < 0 ? -RANDOM.nextInt(-a) : 0);
                    break;
                }
                case 27: {
                    int a = this.getNum(this.ram[++i]);
                    x = a >= 0 ? Circuit.sqrt(a) : -Circuit.sqrt(-a);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid command byte:" + cmd);
                }
            }
            while (s > 0) {
                this.ram[n++] = (byte)x;
                --s;
                x >>= 8;
            }
            this.ram[n++] = (byte)x;
        }
        int[] rsOut = new int[6];
        while (idxIO < this.iocfg.length) {
            IOcfg cfg = this.iocfg[idxIO++];
            int p = cfg.addr & 0x3F;
            x = 0;
            switch (cfg.addr & 0xC0) {
                case 192: {
                    x |= this.ram[p + 3] << 24;
                }
                case 128: {
                    x |= (this.ram[p + 2] & 0xFF) << 16;
                }
                case 64: {
                    x |= (this.ram[p + 1] & 0xFF) << 8;
                }
            }
            byte by = cfg.side;
            rsOut[by] = rsOut[by] | (x |= this.ram[p] & 0xFF) << cfg.ofs;
        }
        return rsOut;
    }

    private static int sqrt(int x) {
        int z;
        int y = x;
        for (z = 4; y >= z; y >>= 1, z <<= 1) {
        }
        z >>= 2;
        while (y > z + 1) {
            y = y + z >> 1;
            z = x / y;
        }
        return y;
    }

    private int getBool(byte idx) {
        int x = this.ram[idx & 0x3F];
        return x == 0 ? 0 : ((idx & 0x40) != 0 ? x : 255);
    }

    public int getNum(int idx) {
        int p = idx & 0x3F;
        switch (idx & 0xC0) {
            case 0: {
                return this.ram[p];
            }
            case 64: {
                return this.ram[p] & 0xFF | this.ram[++p] << 8;
            }
            case 128: {
                return this.ram[p] & 0xFF | this.ram[++p] << 8 & 0xFF00 | this.ram[++p] << 16;
            }
        }
        return this.ram[p] & 0xFF | this.ram[++p] << 8 & 0xFF00 | this.ram[++p] << 16 & 0xFF0000 | this.ram[++p] << 24;
    }

    public int getMinInterval() {
        return ClockSpeed[this.func_145832_p() % ClockSpeed.length];
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        int i;
        byte cmd = data.readByte();
        if (cmd == 0) {
            byte ofs;
            IOcfg cfg = this.iocfg[data.readByte()];
            byte side = data.readByte();
            if (side != cfg.side) {
                int dir = 0;
                byte prev = cfg.side;
                cfg.side = side;
                for (IOcfg c : this.iocfg) {
                    if (c.side != prev) continue;
                    dir = (byte)(dir | (c.dir ? 2 : 1));
                }
                if (dir == 0) {
                    this.ioacc[prev] = null;
                } else {
                    this.ioacc[prev].dir = (byte)(this.ioacc[prev].dir & (dir | 4));
                }
                IOacc acc = this.ioacc[side];
                if (acc == null) {
                    this.ioacc[side] = acc = new IOacc(side);
                }
                acc.dir = (byte)(acc.dir | (cfg.dir ? 2 : 1));
            }
            cfg.ofs = (ofs = data.readByte()) < 0 ? (byte)0 : (ofs > 32 - cfg.size() ? (byte)(32 - cfg.size()) : ofs);
        } else if (cmd == 1) {
            this.mode = (byte)(data.readByte() & 3);
            if (this.mode == 1) {
                long t = this.field_145850_b.func_82737_E();
                this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
            }
        } else if (cmd == 2) {
            int min = this.getMinInterval();
            this.tickInt = data.readInt();
            if (this.tickInt < min) {
                this.tickInt = min;
            } else if (this.tickInt > 1200) {
                this.tickInt = 1200;
            }
            if (this.mode == 1) {
                long t = this.field_145850_b.func_82737_E();
                this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
            }
        } else if (cmd == 3) {
            int j = 0;
            for (int i2 = this.startIdx; i2 < this.ram.length; ++i2) {
                int k;
                byte b = this.ram[i2];
                CircuitDesigner.ModuleType mt = CircuitDesigner.ModuleType.values()[b & 0x3F];
                i2 += mt.varInAm ? (b >> 6 & 3) + 1 : mt.cons();
                int n = k = mt.isNum ? j + (b >> 6 & 3) : j;
                if (mt.cons() == 0) {
                    j = k + 1;
                    continue;
                }
                if (k >= this.startIdx) {
                    k = this.startIdx - 1;
                }
                while (j <= k) {
                    this.ram[j++] = 0;
                }
            }
        } else if (cmd == 4 && (i = data.readByte() & 0x3F) < this.startIdx) {
            this.ram[i] = data.readByte();
        }
    }

    private NBTTagCompound write(NBTTagCompound nbt) {
        nbt.func_74774_a("IO", (byte)this.var);
        nbt.func_74774_a("Cap", (byte)(this.var >> 8));
        nbt.func_74774_a("Gate", (byte)(this.var >> 16));
        nbt.func_74774_a("Calc", (byte)(this.var >> 24));
        nbt.func_74773_a("data", Arrays.copyOf(this.ram, this.ram.length));
        nbt.func_74778_a("name", this.name);
        NBTTagList list = new NBTTagList();
        for (IOcfg cfg : this.iocfg) {
            list.func_74742_a((NBTBase)cfg.write());
        }
        nbt.func_74782_a("io", (NBTBase)list);
        return nbt;
    }

    private void read(NBTTagCompound nbt) {
        this.var = nbt.func_74771_c("IO") & 0xFF | (nbt.func_74771_c("Cap") & 0xFF) << 8 | (nbt.func_74771_c("Gate") & 0xFF) << 16 | (nbt.func_74771_c("Calc") & 0xFF) << 24;
        this.ram = nbt.func_74770_j("data");
        this.name = nbt.func_74779_i("name");
        NBTTagList list = nbt.func_150295_c("io", 10);
        Arrays.fill(this.ioacc, null);
        this.iocfg = new IOcfg[list.func_74745_c()];
        for (int i = 0; i < this.iocfg.length; ++i) {
            IOcfg cfg;
            this.iocfg[i] = cfg = new IOcfg(list.func_150305_b(i));
            IOacc acc = this.ioacc[cfg.side];
            if (acc == null) {
                this.ioacc[cfg.side] = acc = new IOacc(cfg.side);
            }
            acc.dir = (byte)(acc.dir | (cfg.dir ? 2 : 1));
        }
        this.startIdx = Math.min(this.var >> 8 & 0xFF, this.ram.length);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.write(nbt);
        int[] cache = new int[12];
        for (IOacc acc : this.ioacc) {
            if (acc == null) continue;
            int i = acc.side.ordinal() * 2;
            cache[i] = acc.stateI;
            cache[i + 1] = acc.stateO;
        }
        nbt.func_74783_a("out", cache);
        nbt.func_74774_a("mode", this.mode);
        nbt.func_74768_a("tick", this.tickInt);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.read(nbt);
        int[] o = nbt.func_74759_k("out");
        for (IOacc acc : this.ioacc) {
            if (acc == null) continue;
            int i = acc.side.ordinal() * 2;
            acc.stateI = o[i];
            acc.stateO = o[i + 1];
        }
        this.mode = nbt.func_74771_c("mode");
        this.tickInt = nbt.func_74762_e("tick");
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.mode == 1) {
            long t = world.func_82737_E();
            this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
        }
    }

    public List<ItemStack> dropItem(IBlockState m, int fortune) {
        return this.makeDefaultDrops(this.write(new NBTTagCompound()));
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.func_77942_o()) {
            this.read(item.func_77978_p());
        }
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        if (strong) {
            return 0;
        }
        IOacc acc = this.ioacc[side.ordinal()];
        return acc != null ? acc.stateO : 0;
    }

    public boolean connectRedstone(EnumFacing side) {
        return this.getRSDirection(side) != 0;
    }

    public void onRedstoneStateChange(EnumFacing side, int value, TileEntity src) {
        IOacc acc = this.ioacc[side.ordinal()];
        if (acc != null && value != acc.stateI && (acc.dir & 1) != 0) {
            acc.setIn(value);
        }
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        for (IOacc acc : this.ioacc) {
            int rs;
            if (acc == null || (acc.dir & 1) == 0 || (rs = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(acc.side), acc.side)) == acc.stateI) continue;
            acc.setIn(rs);
        }
    }

    public void neighborTileChange(BlockPos src) {
    }

    public byte getRSDirection(EnumFacing s) {
        IOacc acc = this.ioacc[s.ordinal()];
        return acc == null ? (byte)0 : (byte)(acc.dir & 3);
    }

    public void initContainer(DataContainer container) {
        if (this.field_145850_b.field_72995_K) {
            Arrays.fill(this.ram, 0, this.startIdx, (byte)0);
        } else {
            container.extraRef = new LastState();
        }
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        int i;
        LastState ls = (LastState)container.extraRef;
        int p = dos.writerIndex();
        dos.writeByte(0);
        byte chng = 0;
        if (this.tickInt != ls.tickInt || this.mode != ls.mode) {
            ls.tickInt = this.tickInt;
            dos.writeShort(ls.tickInt);
            ls.mode = this.mode;
            dos.writeByte((int)ls.mode);
            chng = (byte)(chng | 1);
        }
        for (int i2 = 0; i2 < this.iocfg.length; ++i2) {
            IOcfg cfg = this.iocfg[i2];
            short x = (short)(cfg.ofs | cfg.side << 8);
            if (x == ls.iocfg[i2]) continue;
            ls.iocfg[i2] = x;
            dos.writeShort((int)ls.iocfg[i2]);
            chng = (byte)(chng | 2 << i2);
        }
        long chng1 = 0L;
        for (i = 0; i < this.startIdx; ++i) {
            if (this.ram[i] == ls.ram[i]) continue;
            chng1 |= 1L << i;
        }
        if (chng1 != 0L) {
            dos.writeLong(chng1);
            chng = (byte)(chng | 0x80);
            i = 0;
            while (chng1 != 0L) {
                if ((chng1 & 1L) != 0L) {
                    ls.ram[i] = this.ram[i];
                    dos.writeByte((int)ls.ram[i]);
                }
                ++i;
                chng1 >>= 1;
            }
        }
        if (chng == 0) {
            return false;
        }
        dos.setByte(p, (int)chng);
        return true;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
        byte chng = dis.readByte();
        if ((chng & 1) != 0) {
            this.tickInt = dis.readShort();
            this.mode = dis.readByte();
        }
        for (int i = 0; i < this.iocfg.length; ++i) {
            if ((chng >> i & 2) == 0) continue;
            IOcfg cfg = this.iocfg[i];
            short x = dis.readShort();
            cfg.ofs = (byte)x;
            cfg.side = (byte)(x >> 8);
        }
        if ((chng & 0x80) != 0) {
            long chng1 = dis.readLong();
            for (int i = 0; chng1 != 0L && i < this.ram.length; ++i, chng1 >>= 1) {
                if ((chng1 & 1L) == 0L) continue;
                this.ram[i] = dis.readByte();
            }
        }
    }

    public int[] getSyncVariables() {
        return null;
    }

    public void setSyncVariable(int i, int v) {
    }

    public String getName() {
        return this.name.length() > 0 ? "\"" + this.name + "\"" : TooltipUtil.translate((String)"gui.cd4017be.circuit.name");
    }

    class IOacc {
        int stateI;
        int stateO;
        IQuickRedstoneHandler te;
        final EnumFacing side;
        byte dir;

        IOacc(int s) {
            this.side = EnumFacing.field_82609_l[s];
        }

        void update(int state) {
            if (state != this.stateO) {
                TileEntity t;
                this.stateO = state;
                if ((this.te == null || this.te.invalid()) && (t = Utils.neighborTile((TileEntity)Circuit.this, (EnumFacing)this.side)) instanceof IQuickRedstoneHandler) {
                    this.te = (IQuickRedstoneHandler)t;
                }
                if (this.te != null) {
                    this.te.onRedstoneStateChange(this.side.func_176734_d(), state, (TileEntity)Circuit.this);
                } else {
                    Circuit.this.field_145850_b.func_190524_a(Circuit.this.field_174879_c.func_177972_a(this.side), Circuit.this.field_145854_h, Circuit.this.field_174879_c);
                }
            }
            if ((this.dir & 4) != 0) {
                state = Circuit.this.field_145850_b.func_175651_c(Circuit.this.field_174879_c.func_177972_a(this.side), this.side);
                if (state != this.stateI) {
                    this.setIn(state);
                }
                this.dir = (byte)(this.dir & 3);
            }
        }

        void setIn(int state) {
            long t = Circuit.this.field_145850_b.func_82737_E();
            if (t != Circuit.this.nextUpdate) {
                this.stateI = state;
                if (Circuit.this.mode >= 2 && t > Circuit.this.nextUpdate) {
                    Circuit.this.nextUpdate = Circuit.this.nextUpdate + (long)(Circuit.this.tickInt + 1);
                    if (t >= Circuit.this.nextUpdate) {
                        Circuit.this.nextUpdate = t + 1L;
                    }
                }
            } else {
                this.dir = (byte)(this.dir | 4);
            }
        }
    }

    public class IOcfg {
        public final String label;
        public final byte addr;
        public final boolean dir;
        public byte ofs;
        public byte side;

        IOcfg(boolean dir, String label, byte addr) {
            this.dir = dir;
            this.label = label;
            this.addr = addr;
        }

        IOcfg(NBTTagCompound tag) {
            this.dir = tag.func_74767_n("d");
            this.label = tag.func_74779_i("n");
            this.addr = tag.func_74771_c("p");
            this.side = tag.func_74771_c("a");
            this.ofs = tag.func_74771_c("o");
        }

        NBTTagCompound write() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("d", this.dir);
            tag.func_74774_a("p", this.addr);
            tag.func_74778_a("n", this.label);
            tag.func_74774_a("a", this.side);
            tag.func_74774_a("o", this.ofs);
            return tag;
        }

        public int size() {
            return (this.addr >> 3 & 0x18) + 8;
        }
    }

    private static final class LastState {
        int tickInt;
        byte mode;
        final short[] iocfg = new short[6];
        final byte[] ram = new byte[64];

        private LastState() {
        }
    }
}

