/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.render;

import cd4017be.circuits.tileEntity.Display8bit;
import cd4017be.circuits.tileEntity.MultiLever;
import cd4017be.lib.render.Util;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Orientation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RSInterfaceRenderer
extends TileEntitySpecialRenderer<BaseTileEntity> {
    private final RenderManager manager = Minecraft.func_71410_x().func_175598_ae();

    private void renderStateBinary(byte state, int tex, int h) {
        this.manager.field_78724_e.func_110577_a(new ResourceLocation("circuits", "textures/blocks/display_ovl.png"));
        BufferBuilder t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < 8; ++i) {
            this.renderFace(t, tex | state >> i & 1, 4 * (i % 4), h * (i / 4) + 8 - h, 4.0f, 8.0f);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderState(int state) {
        this.manager.field_78724_e.func_110577_a(new ResourceLocation("circuits", "textures/blocks/display_ovl.png"));
        BufferBuilder t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int n = state >> 24;
        float dx = 20.0f / (float)(n + 1);
        float x = 16.0f;
        for (int i = 0; i < n; ++i) {
            this.renderFace(t, state >> i * 8 & 0x1F, x -= dx, 4.0f, 4.0f, 8.0f);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderText(String s, float y) {
        FontRenderer fr = this.manager.func_78716_a();
        float w = fr.func_78256_a(s);
        float scale = Math.min(0.375f, 14.0f / w);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(8.0f - w * 0.5f * scale), (float)(y + 1.5f - 4.0f * scale), (float)-0.25f);
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        fr.func_78276_b(s, 0, 0, 0xFFFF00);
        GL11.glPopMatrix();
    }

    private void renderFace(BufferBuilder t, int idx, float x, float y, float w, float h) {
        float tw = 0.125f;
        float th = 0.25f;
        float tx = (float)(idx % 8) * tw;
        float ty = (float)(idx / 8) * th;
        t.func_181662_b((double)x, (double)(y + h), -0.25).func_187315_a((double)tx, (double)(ty + th)).func_181675_d();
        t.func_181662_b((double)(x + w), (double)(y + h), -0.25).func_187315_a((double)(tx + tw), (double)(ty + th)).func_181675_d();
        t.func_181662_b((double)(x + w), (double)y, -0.25).func_187315_a((double)(tx + tw), (double)ty).func_181675_d();
        t.func_181662_b((double)x, (double)y, -0.25).func_187315_a((double)tx, (double)ty).func_181675_d();
    }

    public void render(BaseTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Util.luminate((TileEntity)te, (EnumFacing)te.getOrientation().front, (int)(te instanceof MultiLever ? 0 : 15));
        GL11.glPushMatrix();
        Util.moveAndOrientToBlock((double)x, (double)y, (double)z, (Orientation)te.getOrientation());
        GL11.glScalef((float)-0.0625f, (float)-0.0625f, (float)0.0625f);
        GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-8.0f);
        if (te instanceof MultiLever) {
            this.renderStateBinary(((MultiLever)te).state, 0, 8);
        } else if (te instanceof Display8bit) {
            Display8bit dsp = (Display8bit)te;
            if ((dsp.dspType & 3) == 0) {
                this.renderStateBinary((byte)dsp.display, 2, 4);
            } else {
                this.renderState(dsp.display);
            }
            if (!dsp.text0.isEmpty()) {
                this.renderText(dsp.text0, 1.0f);
            }
            if (!dsp.text1.isEmpty()) {
                this.renderText(dsp.text1, 12.0f);
            }
        }
        GL11.glPopMatrix();
    }
}

