/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.item;

import cd4017be.api.circuits.ItemBlockSensor;
import cd4017be.circuits.gui.GuiFluidSensor;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidSensor
extends ItemBlockSensor
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver {
    public ItemFluidSensor(String id) {
        super(id, 20.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            String[] states = TooltipUtil.translate((String)"gui.cd4017be.fluidSensor.tip").split(",");
            boolean inv = item.func_77978_p().func_74767_n("inv");
            Fluid fluid = this.getFluid(item);
            if (states.length >= 3) {
                String s = fluid == null ? states[inv ? 1 : 0] : (inv ? states[2] : "") + fluid.getLocalizedName(new FluidStack(fluid, 0));
                list.add(s);
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    private Fluid getFluid(ItemStack inv) {
        return inv.func_77942_o() ? FluidRegistry.getFluid((String)inv.func_77978_p().func_74779_i("type")) : null;
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiFluidSensor(new TileContainer((DataContainer.IGuiData)new GuiData(), player));
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender, ItemStack item, int slot) throws IOException {
        byte cmd;
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if ((cmd = data.readByte()) == 0) {
            item.func_77978_p().func_74757_a("inv", !item.func_77978_p().func_74767_n("inv"));
        } else if (cmd == 1) {
            item.func_77978_p().func_74778_a("type", data.func_150789_c(32));
        }
    }

    protected float measure(ItemStack sensor, NBTTagCompound nbt, World world, BlockPos pos, EnumFacing side) {
        IFluidHandler acc = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side);
        if (acc == null) {
            return 0.0f;
        }
        Fluid filter = this.getFluid(sensor);
        boolean inv = nbt.func_74767_n("inv");
        int n = 0;
        for (IFluidTankProperties prop : acc.getTankProperties()) {
            FluidStack fluid = prop.getContents();
            if (!inv && filter == null) {
                n += prop.getCapacity() - (fluid != null ? fluid.amount : 0);
                continue;
            }
            if (fluid == null || !(inv ^ fluid.getFluid() == filter)) continue;
            n += fluid.amount;
        }
        return n;
    }

    class GuiData
    extends ItemGuiData
    implements ITankContainer {
        private InventoryPlayer player;

        public GuiData() {
            super((Item)ItemFluidSensor.this);
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            cont.addTankSlot(new TileContainer.TankSlot((ITankContainer)this, 0, 62, 16, 17));
            cont.addPlayerInventory(8, 50, false, true);
            this.player = cont.player.field_71071_by;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getTank(int i) {
            ItemStack item = (ItemStack)this.player.field_70462_a.get(this.player.field_70461_c);
            Fluid fluid = ItemFluidSensor.this.getFluid(item);
            return fluid != null ? new FluidStack(fluid, 0) : null;
        }

        public int getCapacity(int i) {
            return 0;
        }

        public void setTank(int i, FluidStack fluid) {
        }
    }
}

