/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.circuits.tileEntity.Assembler;
import cd4017be.circuits.tileEntity.CircuitDesigner;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.AdvancedGui;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.util.TooltipUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiCircuitDesigner
extends AdvancedGui {
    private static final float ScrollSize = 1.0f / (float)(CircuitDesigner.ModuleType.values().length - 8);
    private static final ResourceLocation BG_TEX = new ResourceLocation("circuits", "textures/gui/circuit_designer.png");
    private final CircuitDesigner tile;
    private int scroll;

    public GuiCircuitDesigner(DataContainer.IGuiData tile, EntityPlayer player) {
        super((Container)new TileContainer(tile, player));
        this.MAIN_TEX = new ResourceLocation("circuits", "textures/gui/circuit_operators.png");
        this.drawBG = (byte)6;
        this.tile = (CircuitDesigner)tile;
    }

    public void func_73866_w_() {
        this.field_146999_f = 244;
        this.field_147000_g = 256;
        super.func_73866_w_();
        this.titleX = this.field_146999_f / 4;
        this.guiComps.add(new AdvancedGui.TextField((AdvancedGui)this, 0, 118, 4, 109, 8, 16).setTooltip("designer.Pname"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 1, 184, 232, 16, 16, -1).setTooltip("designer.save"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 2, 220, 232, 16, 16, -1).setTooltip("designer.load"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 3, 220, 214, 16, 16, 0).texture(36, 144).setTooltip("designer.wire#"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 4, 183, 173, 18, 9, 0).texture(0, 144).setTooltip("designer.in#"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 5, 201, 173, 18, 9, 0).texture(18, 144).setTooltip("designer.out#"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 6, 219, 173, 18, 9, -1).setTooltip("designer.del"));
        this.guiComps.add(new AdvancedGui.TextField((AdvancedGui)this, 7, 184, 188, 52, 7, 10).color(-4145152, -65536).setTooltip("designer.label"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 8, 153, 144, 47, 11, -1).setTooltip("designer.addOut"));
        this.guiComps.add(new AdvancedGui.Text((AdvancedGui)this, 9, 153, 147, 84, 8, "designer.mods"));
        this.guiComps.add(new AdvancedGui.Slider((AdvancedGui)this, 10, 228, 22, 116, 52, 144, 8, 12, false).scroll(ScrollSize).setTooltip("designer.scroll"));
        this.guiComps.add(new ModuleList(11, 202, 16).setTooltip("designer.mod"));
        this.guiComps.add(new WorkPane(12, 8, 16, 8));
        this.guiComps.add(new AdvancedGui.InfoTab((AdvancedGui)this, 13, 7, 6, 7, 8, "designer.info"));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(BG_TEX);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, this.bgTexX, this.bgTexY, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    protected Object getDisplVar(int id) {
        switch (id) {
            case 0: {
                return this.tile.name;
            }
            case 3: {
                return this.tile.renderAll ? 1 : 0;
            }
            case 4: {
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null || m.cons.length == 0) {
                    return 0;
                }
                CircuitDesigner.Con c = m.cons[m.selCon];
                if (c == null) {
                    return 0;
                }
                return c.type + 1;
            }
            case 5: {
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null) {
                    return 0;
                }
                if (m.type.isNum) {
                    return m.size;
                }
                if (m.type.varInAm) {
                    return m.cons() + 4;
                }
                return 0;
            }
            case 7: {
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null) {
                    return "";
                }
                return m.label;
            }
            case 10: {
                return Float.valueOf((float)this.scroll * ScrollSize);
            }
        }
        return null;
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        switch (id) {
            case 0: {
                PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
                dos.writeByte(3);
                this.tile.name = (String)obj;
                dos.func_180714_a(this.tile.name);
                BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                break;
            }
            case 1: {
                if (GuiCircuitDesigner.func_146272_n()) {
                    this.saveAsFile();
                    break;
                }
                PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
                dos.writeByte(1);
                BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                break;
            }
            case 2: {
                if (GuiCircuitDesigner.func_146272_n()) {
                    this.readAsFile();
                    break;
                }
                PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
                dos.writeByte(2);
                BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                break;
            }
            case 3: {
                PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
                this.tile.renderAll = !this.tile.renderAll;
                dos.writeByte(this.tile.renderAll ? 7 : 6);
                BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                break;
            }
            case 4: {
                CircuitDesigner.Con c;
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null || m.cons.length == 0 || (c = m.cons[m.selCon]) == null) break;
                if (c.type < 4) {
                    c.type = (byte)((c.type + ((Integer)obj == 0 ? 1 : 3)) % 4);
                    ++this.tile.modified;
                    break;
                }
                if (!m.type.can8bit) break;
                c.type = (byte)(c.type ^ 1);
                ++this.tile.modified;
                break;
            }
            case 5: {
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null) break;
                if (m.type.isNum) {
                    m.resize(1 + (m.size + ((Integer)obj == 0 ? 0 : 2)) % 4);
                    ++this.tile.modified;
                    break;
                }
                if (!m.type.varInAm) break;
                if ((Integer)obj == 0) {
                    m.addCon();
                } else {
                    m.removeCon();
                }
                ++this.tile.modified;
                break;
            }
            case 6: {
                if (this.tile.selMod < 0) break;
                this.tile.modules[this.tile.selMod] = null;
                this.tile.selMod = -1;
                ++this.tile.modified;
                break;
            }
            case 7: {
                CircuitDesigner.Module m;
                if (this.tile.selMod < 0 || (m = this.tile.modules[this.tile.selMod]) == null) break;
                m.label = (String)obj;
                if (m.type == CircuitDesigner.ModuleType.CST) {
                    try {
                        int s = 32 - m.size * 8;
                        m.label = Integer.toString(Integer.parseInt(m.label) << s >> s);
                    }
                    catch (NumberFormatException e) {
                        m.label = "0";
                    }
                }
                ++this.tile.modified;
                break;
            }
            case 10: {
                this.scroll = (int)(((Float)obj).floatValue() / ScrollSize);
                break;
            }
            case 8: {
                obj = CircuitDesigner.ModuleType.OUT;
            }
            case 11: {
                this.tile.add((CircuitDesigner.ModuleType)((Object)obj));
            }
        }
    }

    protected void func_73869_a(char c, int k) throws IOException {
        if (k == 201 && this.scroll > 0) {
            --this.scroll;
        } else if (k == 209 && (float)this.scroll < 1.0f / ScrollSize) {
            ++this.scroll;
        } else if (k == 211) {
            this.setDisplVar(6, null, false);
        }
        super.func_73869_a(c, k);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.tile.modified != 0L) {
            this.save();
        }
    }

    public void func_73876_c() {
        if (this.tile.modified != 0L) {
            this.save();
        }
        super.func_73876_c();
    }

    private void save() {
        this.tile.modified = 0L;
        PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
        dos.writeByte(0);
        dos.writeBytes(this.tile.serialize());
        BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
    }

    private void saveAsFile() {
        if (this.tile.name.isEmpty()) {
            this.sendChat(TooltipUtil.format((String)"gui.cd4017be.designer.noname", (Object[])new Object[0]));
        }
        File file = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/" + this.tile.name + ".dat");
        try {
            ByteBuf data = this.tile.serialize();
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            data.readBytes((OutputStream)fos, data.writerIndex());
            fos.close();
            this.sendChat(TooltipUtil.format((String)"gui.cd4017be.designer.saved", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            this.sendChat(e.toString());
        }
    }

    private void readAsFile() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/" + this.tile.name + ".dat");
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            ByteBuf data = Unpooled.buffer();
            while ((i = fis.available()) > 0) {
                data.writeBytes((InputStream)fis, i);
            }
            fis.close();
            this.tile.deserialize(data);
            ++this.tile.modified;
            this.sendChat(TooltipUtil.format((String)"gui.cd4017be.designer.loaded", (Object[])new Object[]{file}));
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"gui.cd4017be.designer.notFound", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            this.sendChat(e.toString());
        }
    }

    private void drawSmallNum(int x, int y, String i, int w) {
        char[] cs = i.toCharArray();
        if (cs.length > w) {
            int scale = (cs.length + w - 1) / w;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)1.0f);
            x *= scale;
            y *= scale;
        }
        for (char c : cs) {
            this.func_73729_b(x, y, c == '-' ? 40 : 4 * (c - 48), 250, 4, 6);
            x += 4;
        }
        if (cs.length > w) {
            GlStateManager.func_179121_F();
        }
    }

    private void drawScaledString(int x, int y, int width, int height, String s, int color) {
        boolean doScale;
        int w = this.field_146289_q.func_78256_a(s);
        boolean bl = doScale = w > width || this.field_146289_q.field_78288_b - 1 > height;
        if (doScale) {
            int scale = Math.max((w + width - 1) / width, (this.field_146289_q.field_78288_b + height - 2) / height);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)1.0f);
            x *= scale;
            y *= scale;
        }
        this.field_146289_q.func_78276_b(s, x, y, color);
        if (doScale) {
            GlStateManager.func_179121_F();
        }
    }

    class WorkPane
    extends AdvancedGui.GuiComp<Object> {
        int targetPos;

        public WorkPane(int id, int px, int py, int h) {
            super((AdvancedGui)GuiCircuitDesigner.this, id, px, py, 192, h * 16 + 12);
            this.targetPos = -1;
        }

        public void draw() {
            GuiCircuitDesigner.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuitDesigner.this.MAIN_TEX);
            GlStateManager.func_179147_l();
            for (int i = 0; i < ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modules.length; ++i) {
                CircuitDesigner.Con c;
                int j;
                CircuitDesigner.Module mod = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modules[i];
                if (mod == null) continue;
                int x1 = this.px + (i & 7) * 24;
                int y1 = this.py + (i >> 3) * 16;
                int t = mod.type.ordinal();
                GuiCircuitDesigner.this.func_73729_b(x1, y1, (t >> 3) * 24, (t & 7) * 16, 24, 16);
                for (j = 1; j < mod.size; ++j) {
                    GuiCircuitDesigner.this.func_73729_b(this.px + (i + j & 7) * 24, this.py + (i + j >> 3) * 16, j * 24, 128, 24, 16);
                }
                if (mod.type.varInAm) {
                    for (j = 0; j < mod.cons.length; ++j) {
                        if (mod.cons[j] != null) continue;
                        GuiCircuitDesigner.this.func_73729_b(x1 + 1, y1 + mod.type.conRenderPos(j), 0, 128, 4, 4);
                    }
                }
                if (mod.type == CircuitDesigner.ModuleType.CST) {
                    GuiCircuitDesigner.this.drawSmallNum(x1 + 3, y1 + 9, mod.label, 4);
                } else if (mod.type == CircuitDesigner.ModuleType.IN) {
                    GuiCircuitDesigner.this.drawScaledString(x1 + 2, y1 + 10, 20, 7, mod.label, -1);
                    GuiCircuitDesigner.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuitDesigner.this.MAIN_TEX);
                } else if (mod.type == CircuitDesigner.ModuleType.OUT) {
                    GuiCircuitDesigner.this.drawScaledString(x1 + 2, y1 + 7, 20, 4, mod.label, -1);
                    GuiCircuitDesigner.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuitDesigner.this.MAIN_TEX);
                }
                if (i != ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod) continue;
                GuiCircuitDesigner.this.func_73729_b(x1, y1, 96, 128, 24, 16);
                if (mod.cons.length <= 0 || (c = mod.cons[mod.selCon]) == null) continue;
                GuiCircuitDesigner.this.func_73729_b(x1 + 1, y1 + mod.type.conRenderPos(mod.selCon), 0, c.type < 4 ? 136 : 132, 4, 4);
            }
            for (CircuitDesigner.Module m : ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modules) {
                if (m == null) continue;
                this.drawModuleCons(m);
            }
            if (this.targetPos >= 0) {
                int x1 = this.px + (this.targetPos & 7) * 24;
                int y1 = this.py + (this.targetPos >> 3) * 16;
                GuiCircuitDesigner.this.func_73729_b(x1, y1, 120, 128, 24, 16);
            }
        }

        private void drawModuleCons(CircuitDesigner.Module m) {
            int x1 = this.px + (m.pos & 7) * 24;
            int y1 = this.py + (m.pos >> 3) * 16;
            GlStateManager.func_179090_x();
            BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
            vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            int a = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.renderAll || m.pos == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod ? 255 : 96;
            for (int i = 0; i < m.cons.length; ++i) {
                int n;
                int b;
                int r;
                int g;
                CircuitDesigner.Con c = m.cons[i];
                if (c == null || c.addr < 0) continue;
                int n2 = g = m.pos == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod && i == m.selCon ? 192 : 0;
                if (c.type < 4) {
                    r = 0;
                    b = 255;
                } else {
                    r = 255;
                    b = 0;
                }
                int addr = c.getAddr();
                int y2 = y1 + m.type.conRenderPos(i) + 2;
                int n3 = n = c.type < 4 ? c.type : 0;
                while (n >= 0) {
                    vb.func_181662_b((double)(x1 + 3), (double)y2, (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, g, b, a).func_181675_d();
                    vb.func_181662_b((double)(this.px + (addr & 7) * 24 + 22), (double)(this.py + (addr >> 3) * 16) + 8.5, (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, g, b, a).func_181675_d();
                    --n;
                    ++addr;
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
        }

        public void drawOverlay(int x, int y) {
            int mp = (x - this.px) / 24 + (y - this.py) / 16 * 8;
            CircuitDesigner.Module m = GuiCircuitDesigner.this.tile.find(mp);
            if (m != null && !m.label.isEmpty()) {
                GuiCircuitDesigner.this.func_146283_a(Arrays.asList(m.label), x, y);
            }
        }

        public boolean mouseIn(int x, int y, int b, int d) {
            CircuitDesigner.Module selMod;
            CircuitDesigner.Module module = selMod = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod >= 0 ? ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modules[((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod] : null;
            if (d == 3 && selMod != null) {
                if (selMod.cons.length == 0) {
                    return true;
                }
                selMod.selCon = Math.floorMod(selMod.selCon + b, selMod.cons());
                return true;
            }
            int mp = (x - this.px) / 24 + (y - this.py) / 16 * 8;
            if (d == 1 && b == 0 && selMod != null) {
                this.targetPos = this.targetPos >= 0 || mp == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod ? mp : -1;
                return true;
            }
            if (d == 2 && b == 0) {
                GuiCircuitDesigner.this.setFocus(-1);
            }
            this.targetPos = -1;
            if (d != 0) {
                return true;
            }
            CircuitDesigner.Module m = GuiCircuitDesigner.this.tile.find(mp);
            if (b == 0) {
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod = m == null ? -1 : mp;
            } else if (b == 1 && selMod != null && selMod.cons.length > 0 && mp < 64) {
                CircuitDesigner.Con c = selMod.cons[selMod.selCon];
                if (c == null) {
                    return true;
                }
                c.setAddr(m, mp);
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modified = 1L;
            }
            return true;
        }

        public void unfocus() {
            if (this.targetPos >= 0 && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod >= 0 && this.targetPos != ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod && this.targetPos < ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modules.length) {
                GuiCircuitDesigner.this.tile.move(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod, this.targetPos);
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod = this.targetPos;
            }
        }

        public boolean focus() {
            return true;
        }
    }

    class ModuleList
    extends AdvancedGui.GuiComp<CircuitDesigner.ModuleType> {
        public ModuleList(int id, int px, int py) {
            super((AdvancedGui)GuiCircuitDesigner.this, id, px, py, 24, 128);
        }

        public void drawOverlay(int mx, int my) {
            int k;
            int i = (my - this.py) / 16 + GuiCircuitDesigner.this.scroll;
            if (i < 0 || i >= CircuitDesigner.ModuleType.values().length) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String s : TooltipUtil.translate((String)("gui.cd4017be." + this.tooltip + i)).split("\n")) {
                list.add(s);
            }
            CircuitDesigner.ModuleType mt = CircuitDesigner.ModuleType.values()[i];
            int j = Assembler.logicCost(mt, 1);
            String l = j == (k = Assembler.logicCost(mt, 4)) ? Integer.toString(j) : Integer.toString(j) + "-" + Integer.toString(k);
            j = Assembler.calcCost(mt, 1);
            k = Assembler.calcCost(mt, 4);
            String c = j == k ? Integer.toString(j) : Integer.toString(j) + "-" + Integer.toString(k);
            list.add(TooltipUtil.format((String)"gui.cd4017be.designer.cost", (Object[])new Object[]{l, c}));
            GuiCircuitDesigner.this.drawHoveringText(list, mx, my, GuiCircuitDesigner.this.field_146289_q);
        }

        public void draw() {
            GuiCircuitDesigner.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuitDesigner.this.MAIN_TEX);
            for (int i = 0; i < 8; ++i) {
                int j = GuiCircuitDesigner.this.scroll + i;
                GuiCircuitDesigner.this.func_73729_b(this.px, this.py + i * 16, (j >> 3) * 24, (j & 7) * 16, 24, 16);
            }
        }

        public boolean mouseIn(int x, int y, int b, int d) {
            if (d != 0) {
                return false;
            }
            int i = (y - this.py) / 16 + GuiCircuitDesigner.this.scroll;
            if (i >= 0 && i < CircuitDesigner.ModuleType.values().length) {
                this.set.accept(CircuitDesigner.ModuleType.values()[i]);
                return true;
            }
            return false;
        }
    }
}

