/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.circuits.tileEntity.Circuit;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.AdvancedGui;
import cd4017be.lib.Gui.DataContainer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiCircuit
extends AdvancedGui {
    private final Circuit tile;

    public GuiCircuit(DataContainer.IGuiData tileEntity, EntityPlayer player) {
        super((Container)new DataContainer(tileEntity, player));
        this.tile = (Circuit)tileEntity;
        this.MAIN_TEX = new ResourceLocation("circuits", "textures/gui/circuit.png");
    }

    public void func_73866_w_() {
        this.field_146999_f = 108;
        this.field_147000_g = 96;
        super.func_73866_w_();
        this.tabsY = -56;
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 0, 45, 15, 18, 18, 0, () -> (int)this.tile.mode, obj -> {
            this.tile.mode = (byte)((this.tile.mode + ((Integer)obj == 0 ? 1 : 3)) % 4);
            this.setDisplVar(0, null, true);
        }).texture(166, 0).setTooltip("circuit.on#"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 1, 7, 15, 33, 9, -1).setTooltip("circuit.reset"));
        this.guiComps.add(new AdvancedGui.NumberSel((AdvancedGui)this, 2, 65, 15, 36, 18, "", this.tile.getMinInterval(), 1200, 20, () -> this.tile.tickInt, i -> {
            this.tile.tickInt = i;
            this.setDisplVar(2, null, true);
        }).setup(8, -12566464, 2, true).around());
        this.guiComps.add(new AdvancedGui.Text((AdvancedGui)this, 3, 66, 20, 34, 8, "circuit.tick", () -> Float.valueOf((float)this.tile.tickInt / 20.0f)).center().setTooltip("circuit.timer"));
        this.guiComps.add(new Memory(4, 7, 24, 32, 64));
        for (int i2 = 0; i2 < this.tile.iocfg.length; ++i2) {
            int j = 5 + i2 * 5;
            Circuit.IOcfg cfg = this.tile.iocfg[i2];
            this.guiComps.add(new IOPort(j, 43, 35 + i2 * 9, 58, 9, 108, 54, () -> cfg));
            this.guiComps.add(new AdvancedGui.Tooltip((AdvancedGui)this, j + 1, 45, 35 + i2 * 9, 20, 9, cfg.dir ? "circuit.dirO" : "circuit.dirI", () -> cfg.label));
            this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, j + 2, 56, 35 + i2 * 9, 9, 9, cfg.dir ? 2 : 1, () -> EnumFacing.field_82609_l[cfg.side], obj -> {
                cfg.side = (byte)((cfg.side + ((Integer)obj == 0 ? 1 : 5)) % 6);
                this.setDisplVar(j, cfg, true);
            }).texture(108, 0));
            int s = cfg.size();
            int l = 32 - s;
            this.guiComps.add(new AdvancedGui.Slider((AdvancedGui)this, j + 3, 68 + s / 2, 37 + i2 * 9, l, 108, 74, s, 5, true, () -> Float.valueOf((float)cfg.ofs / (float)l), obj -> {
                cfg.ofs = (byte)(obj.floatValue() * (float)l);
            }, obj -> {
                cfg.ofs = (byte)(obj.floatValue() * (float)l);
                this.setDisplVar(j, cfg, true);
            }).scroll(1.0f / (float)l));
            this.guiComps.add(new AdvancedGui.Tooltip((AdvancedGui)this, j + 4, 67, 37 + i2 * 9, 32, 5, cfg.dir ? "circuit.ofsO" : "circuit.ofsI", () -> new Object[]{cfg.ofs, 1 << cfg.ofs}));
        }
        this.guiComps.add(new AdvancedGui.InfoTab((AdvancedGui)this, this.guiComps.size(), 7, 6, 7, 8, "circuit.info"));
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        PacketBuffer dos = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
        if (id == 0) {
            dos.writeByte(1).writeByte((int)this.tile.mode);
        } else if (id == 1) {
            dos.writeByte(3);
        } else if (id == 2) {
            dos.writeByte(2).writeInt(this.tile.tickInt);
        } else {
            int p = (id - 5) / 5;
            Circuit.IOcfg cfg = (Circuit.IOcfg)obj;
            dos.writeByte(0).writeByte(p).writeByte((int)cfg.side).writeByte((int)cfg.ofs);
        }
        if (send) {
            BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
        }
    }

    class Memory
    extends AdvancedGui.GuiComp<Object> {
        public Memory(int id, int px, int py, int w, int h) {
            super((AdvancedGui)GuiCircuit.this, id, px, py, w, h);
        }

        public void draw() {
            GuiCircuit.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuit.this.MAIN_TEX);
            for (int i = 0; i < ((GuiCircuit)GuiCircuit.this).tile.startIdx; ++i) {
                int val = ((GuiCircuit)GuiCircuit.this).tile.ram[i] & 0xFF;
                GuiCircuit.this.func_73729_b(this.px + (i & 7) * 4, this.py + (i >> 3) * 8, 192 + (val & 0xF) * 4, (val >> 4) * 8, 4, 8);
            }
        }

        public void drawOverlay(int mx, int my) {
            int i = (mx - this.px) / 4 + (my - this.py) / 8 * 8;
            int l = ((GuiCircuit)GuiCircuit.this).tile.startIdx;
            if (i >= 0) {
                ArrayList<String> list = new ArrayList<String>(4);
                if (i < l) {
                    list.add(String.format("8: %02x %d", ((GuiCircuit)GuiCircuit.this).tile.ram[i] & 0xFF, GuiCircuit.this.tile.getNum(i)));
                }
                if (i + 1 < l) {
                    list.add(String.format("16: %d", GuiCircuit.this.tile.getNum(i | 0x40)));
                }
                if (i + 2 < l) {
                    list.add(String.format("24: %d", GuiCircuit.this.tile.getNum(i | 0x80)));
                }
                if (i + 3 < l) {
                    list.add(String.format("32: %d", GuiCircuit.this.tile.getNum(i | 0xC0)));
                }
                GuiCircuit.this.func_146283_a(list, mx, my);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean mouseIn(int x, int y, int b, int d) {
            int val;
            int i = (x - this.px) / 4 + (y - this.py) / 8 * 8;
            if (i < 0 || i >= ((GuiCircuit)GuiCircuit.this).tile.startIdx) {
                return false;
            }
            if (d == 0) {
                if (b == 0) {
                    val = -1;
                } else {
                    if (b != 1) return false;
                    val = 0;
                }
            } else {
                if (d != 3) return false;
                val = (byte)(((GuiCircuit)GuiCircuit.this).tile.ram[i] + b * (GuiScreen.func_146272_n() ? 16 : 1));
            }
            PacketBuffer data = BlockGuiHandler.getPacketTargetData((BlockPos)GuiCircuit.this.tile.pos());
            data.writeByte(4).writeByte(i).writeByte(val);
            BlockGuiHandler.sendPacketToServer((PacketBuffer)data);
            return true;
        }
    }

    class IOPort
    extends AdvancedGui.GuiComp<Circuit.IOcfg> {
        final int tx;
        final int ty;

        public IOPort(int id, int px, int py, int w, int h, int tx, int ty, Supplier<Circuit.IOcfg> get) {
            super((AdvancedGui)GuiCircuit.this, id, px, py, w, h, get, null, null);
            this.tx = tx;
            this.ty = ty;
        }

        public void drawOverlay(int mx, int my) {
            GuiCircuit.this.field_146297_k.field_71446_o.func_110577_a(GuiCircuit.this.MAIN_TEX);
            Circuit.IOcfg cfg = (Circuit.IOcfg)this.get.get();
            int s = cfg.addr & 0x3F;
            int l = Math.min(s + (cfg.addr >> 6 & 3) + 1, ((GuiCircuit)GuiCircuit.this).tile.ram.length);
            for (int i = s; i < l; ++i) {
                int val = ((GuiCircuit)GuiCircuit.this).tile.ram[i] & 0xFF;
                GuiCircuit.this.func_73729_b(GuiCircuit.this.field_147003_i + 7 + (i & 7) * 4, GuiCircuit.this.field_147009_r + 24 + (i >> 3) * 8, 192 + (val & 0xF) * 4, 128 + (val >> 4) * 8, 4, 8);
            }
        }

        public void draw() {
            GuiCircuit.this.func_73729_b(this.px, this.py, this.tx, this.ty + (((Circuit.IOcfg)this.get.get()).dir ? this.h : 0), this.w, this.h);
        }
    }
}

