/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictStack {
    public String id;
    public int ID;
    public int stacksize;

    public OreDictStack(String id, int n) {
        this.id = id;
        this.stacksize = n;
        this.ID = OreDictionary.getOreID((String)id);
    }

    public OreDictStack(int id, int n) {
        this.ID = id;
        this.id = OreDictionary.getOreName((int)id);
        this.stacksize = n;
    }

    public static OreDictStack deserialize(String s) {
        int p = s.indexOf(42);
        short n = 1;
        if (p > 0) {
            try {
                n = Short.parseShort(s.substring(0, p));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            s = s.substring(p + 1);
            if (n <= 0) {
                n = 1;
            }
        }
        if (s.isEmpty()) {
            return null;
        }
        return new OreDictStack(s, (int)n);
    }

    public static OreDictStack[] get(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        int[] i = OreDictionary.getOreIDs((ItemStack)item);
        OreDictStack[] stacks = new OreDictStack[i.length];
        for (int j = 0; j < i.length; ++j) {
            stacks[j] = new OreDictStack(i[j], item.func_190916_E());
        }
        return stacks;
    }

    public boolean isEqual(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
            if (id != this.ID) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getItems() {
        NonNullList list = OreDictionary.getOres((String)this.id);
        ItemStack[] items = new ItemStack[list.size()];
        int n = 0;
        for (ItemStack item : list) {
            items[n] = item.func_77946_l();
            items[n++].func_190920_e(this.stacksize);
        }
        return items;
    }

    public ItemStack asItem() {
        NonNullList list = OreDictionary.getOres((String)this.id);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack item = ((ItemStack)list.get(0)).func_77946_l();
        item.func_190920_e(this.stacksize);
        return item;
    }

    public OreDictStack copy() {
        return new OreDictStack(this.ID, this.stacksize);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OreDictStack) {
            OreDictStack stack = (OreDictStack)obj;
            return stack.ID == this.ID && stack.stacksize == this.stacksize;
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return this.isEqual(stack) && stack.func_190916_E() == this.stacksize;
        }
        if (obj instanceof String) {
            return this.id.equals(obj);
        }
        return false;
    }
}

