/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.automation.IOperatingArea;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class MovedBlock {
    public final NBTTagCompound nbt;
    public final IBlockState block;

    public MovedBlock(IBlockState block, NBTTagCompound tile) {
        this.block = block;
        this.nbt = tile;
    }

    public boolean set(World world, BlockPos pos) {
        TileEntity tile = null;
        if (this.nbt != null) {
            this.nbt.func_74768_a("x", pos.func_177958_n());
            this.nbt.func_74768_a("y", pos.func_177956_o());
            this.nbt.func_74768_a("z", pos.func_177952_p());
            tile = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.nbt);
            if (tile instanceof IOperatingArea) {
                int[] area = ((IOperatingArea)tile).getOperatingArea();
                area[0] = area[0] + pos.func_177958_n();
                area[3] = area[3] + pos.func_177958_n();
                area[1] = area[1] + pos.func_177956_o();
                area[4] = area[4] + pos.func_177956_o();
                area[2] = area[2] + pos.func_177952_p();
                area[5] = area[5] + pos.func_177952_p();
            }
        }
        return MovedBlock.setBlock(world, pos, this.block, tile);
    }

    public static MovedBlock get(World world, BlockPos pos) {
        IBlockState id = world.func_180495_p(pos);
        NBTTagCompound nbt = null;
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            if (te instanceof IOperatingArea) {
                int[] area = ((IOperatingArea)te).getOperatingArea();
                area[0] = area[0] - pos.func_177958_n();
                area[3] = area[3] - pos.func_177958_n();
                area[1] = area[1] - pos.func_177956_o();
                area[4] = area[4] - pos.func_177956_o();
                area[2] = area[2] - pos.func_177952_p();
                area[5] = area[5] - pos.func_177952_p();
            }
            nbt = new NBTTagCompound();
            te.func_189515_b(nbt);
        }
        return new MovedBlock(id, nbt);
    }

    public static boolean setBlock(World world, BlockPos pos, IBlockState state, TileEntity tile) {
        int bz;
        int p;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IBlockState state0 = chunk.func_177435_g(pos);
        Block block = state.func_177230_c();
        int oldLight = state0.getLightValue((IBlockAccess)world, pos);
        int oldOpac = state0.getLightOpacity((IBlockAccess)world, pos);
        world.func_175713_t(pos);
        if (state0 == state) {
            world.func_175690_a(pos, tile);
            world.func_184138_a(pos, state0, state, 3);
            return true;
        }
        int bx = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        if (y >= chunk.field_76638_b[p = (bz = pos.func_177952_p() & 0xF) << 4 | bx] - 1) {
            chunk.field_76638_b[p] = -999;
        }
        int h = chunk.func_177445_q()[p];
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, world.field_73011_w.func_191066_m());
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = y >= h;
        }
        extendedblockstorage.func_177484_a(bx, y & 0xF, bz, state);
        if (extendedblockstorage.func_177485_a(bx, y & 0xF, bz).func_177230_c() != block) {
            return false;
        }
        if (flag) {
            chunk.func_76603_b();
        } else {
            int opac = state.getLightOpacity((IBlockAccess)world, pos);
            if (opac > 0) {
                if (y >= h) {
                    chunk.func_76615_h(bx, y + 1, bz);
                }
            } else if (y == h - 1) {
                chunk.func_76615_h(bx, y, bz);
            }
            if (opac != oldOpac && (opac < oldOpac || chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                chunk.func_76595_e(bx, bz);
            }
        }
        world.func_175690_a(pos, tile);
        chunk.func_177427_f(true);
        if (state.getLightOpacity((IBlockAccess)world, pos) != oldOpac || state.getLightValue((IBlockAccess)world, pos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(pos);
            world.field_72984_F.func_76319_b();
        }
        world.func_184138_a(pos, state0, state, 3);
        return true;
    }

    public static void moveEntity(Entity entity, int dim, double x, double y, double z) {
        int dimO = entity.field_70170_p.field_73011_w.getDimension();
        if (dim != dimO) {
            MinecraftServer server = ((WorldServer)entity.field_70170_p).func_73046_m();
            WorldServer worldO = server.func_71218_a(dimO);
            WorldServer worldN = server.func_71218_a(dim);
            if (entity instanceof EntityPlayerMP) {
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, dim, (net.minecraft.world.Teleporter)new Teleporter(worldN, x, y, z));
            } else {
                entity.field_71093_bK = dim;
                entity.field_70170_p.func_72900_e(entity);
                entity.field_70128_L = false;
                server.func_184103_al().transferEntityToWorld(entity, 0, worldO, worldN, (net.minecraft.world.Teleporter)new Teleporter(worldN, x, y, z));
            }
        } else if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).func_70634_a(x, y, z);
        } else {
            entity.func_70107_b(x, y, z);
        }
    }

    public static class Teleporter
    extends net.minecraft.world.Teleporter {
        private final double x;
        private final double y;
        private final double z;

        public Teleporter(WorldServer worldIn, double x, double y, double z) {
            super(worldIn);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void func_180266_a(Entity entity, float rot) {
            entity.func_70012_b(this.x, this.y, this.z, rot, entity.field_70125_A);
        }
    }
}

