/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.api.IAbstractTile;
import cd4017be.lib.templates.SharedNetwork;
import cd4017be.lib.util.ICachableInstance;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class MultiblockComp<C extends MultiblockComp<C, N>, N extends SharedNetwork<C, N>>
implements ICachableInstance {
    public N network;
    public final IAbstractTile tile;
    protected long uid;
    public byte con = (byte)63;
    public boolean updateCon = true;

    public MultiblockComp(IAbstractTile tile) {
        this.tile = tile;
    }

    public long getUID() {
        return this.uid;
    }

    public void setUID(long uid) {
        if (this.uid != 0L) {
            return;
        }
        this.uid = uid;
        if (this.network != null) {
            ((SharedNetwork)this.network).components.remove(0L);
            ((SharedNetwork)this.network).components.put(uid, this);
        }
    }

    public boolean canConnect(byte side) {
        return (this.con >> side & 1) != 0;
    }

    public void setConnect(byte side, boolean c) {
        boolean c0 = this.canConnect(side);
        if (!c && c0) {
            ((SharedNetwork)this.network).onDisconnect((MultiblockComp)this, side);
            this.con = (byte)(this.con & ~(1 << side));
        } else if (c && !c0) {
            this.updateCon = true;
            this.con = (byte)(this.con | 1 << side);
        }
    }

    public C getNeighbor(byte side) {
        ICapabilityProvider te = this.tile.getTileOnSide(EnumFacing.field_82609_l[side]);
        if (te == null) {
            return null;
        }
        MultiblockComp comp = (MultiblockComp)te.getCapability(this.getCap(), EnumFacing.field_82609_l[side ^ 1]);
        return (C)(comp != null && comp.canConnect((byte)(side ^ 1)) ? comp : null);
    }

    public abstract Capability<C> getCap();

    @Override
    public boolean invalid() {
        return this.network == null || this.tile.invalid();
    }
}

