/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.property.PropertyBoolean;
import cd4017be.lib.property.PropertyByte;
import cd4017be.lib.render.IHardCodedModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class MultipartModel
implements IModel,
IHardCodedModel {
    public final IModelProvider[] modelProvider;
    public final ResourceLocation[] baseModels;
    public final MultipartBlock block;

    public MultipartModel(MultipartBlock block) {
        this.block = block;
        if (block.baseState == null) {
            this.baseModels = new ResourceLocation[]{new ModelResourceLocation(block.getRegistryName(), "base")};
        } else {
            Collection states = block.baseState.func_177700_c();
            this.baseModels = new ResourceLocation[states.size()];
            Iterator iterator = states.iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                this.baseModels[s] = new ModelResourceLocation(block.getRegistryName(), "base" + s);
            }
        }
        this.modelProvider = new IModelProvider[block.modules.length];
        for (int i = 0; i < block.modules.length; ++i) {
            IUnlistedProperty<?> prop = block.modules[i];
            if (!(prop instanceof PropertyBoolean)) continue;
            this.modelProvider[i] = new ProviderBool((ResourceLocation)new ModelResourceLocation(block.getRegistryName(), prop.getName()));
        }
    }

    public MultipartModel setPipeVariants(int n) {
        for (int i = 0; i < this.block.modules.length; ++i) {
            IUnlistedProperty<?> prop = this.block.modules[i];
            if (!(prop instanceof PropertyByte) || this.modelProvider[i] != null) continue;
            ResourceLocation[] locs = new ResourceLocation[n];
            for (int j = 0; j < n; ++j) {
                locs[j] = new ModelResourceLocation(this.block.getRegistryName(), prop.getName() + j);
            }
            this.modelProvider[i] = new ProviderByte(locs);
        }
        return this;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (ResourceLocation resourceLocation : this.baseModels) {
            list.add(resourceLocation);
        }
        for (IModelProvider iModelProvider : this.modelProvider) {
            Collection<ResourceLocation> c = iModelProvider.getDependencies();
            if (c == null) continue;
            list.addAll(c);
        }
        return list;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        IBakedModel[] models = new IBakedModel[this.baseModels.length];
        for (int i = 0; i < this.baseModels.length; ++i) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.baseModels[i], (String)("missing base Model " + i));
            models[i] = model.bake(state, format, textureGetter);
        }
        for (IModelProvider provider : this.modelProvider) {
            provider.bake(state, format, textureGetter);
        }
        return new BakedMultipart(models);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    @Override
    public void onReload() {
    }

    public class ProviderByte
    implements IModelProvider {
        private final ResourceLocation[] models;
        private final IBakedModel[] baked;

        public ProviderByte(ResourceLocation ... models) {
            this.models = models;
            this.baked = new IBakedModel[models.length];
        }

        @Override
        public IBakedModel getModelFor(Object val) {
            byte var = (Byte)val;
            return var >= 0 && var < this.models.length ? this.baked[var] : null;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Arrays.asList(this.models);
        }

        @Override
        public void bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            for (int i = 0; i < this.models.length; ++i) {
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.models[i], (String)"missing");
                this.baked[i] = model.bake(model.getDefaultState(), format, textureGetter);
            }
        }
    }

    public class ProviderBool
    implements IModelProvider {
        private final ResourceLocation model;
        private IBakedModel baked;

        public ProviderBool(ResourceLocation model) {
            this.model = model;
        }

        @Override
        public IBakedModel getModelFor(Object val) {
            return val == Boolean.TRUE ? this.baked : null;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Arrays.asList(this.model);
        }

        @Override
        public void bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.model, (String)"missing");
            this.baked = model.bake(model.getDefaultState(), format, textureGetter);
        }
    }

    public static interface IModelProvider {
        public IBakedModel getModelFor(Object var1);

        public Collection<ResourceLocation> getDependencies();

        public void bake(IModelState var1, VertexFormat var2, Function<ResourceLocation, TextureAtlasSprite> var3);
    }

    public class BakedMultipart
    implements IBakedModel {
        private final IBakedModel[] base;

        private BakedMultipart(IBakedModel[] base) {
            this.base = base;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            list.addAll(this.base[MultipartModel.this.block.baseState == null ? 0 : (Integer)state.func_177229_b((IProperty)MultipartModel.this.block.baseState)].func_188616_a(state, side, rand));
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                for (int i = 0; i < MultipartModel.this.block.modules.length; ++i) {
                    IBakedModel model = MultipartModel.this.modelProvider[i].getModelFor(exState.getValue(MultipartModel.this.block.modules[i]));
                    if (model == null) continue;
                    list.addAll(model.func_188616_a(state, side, rand));
                }
            }
            return list;
        }

        public boolean func_177555_b() {
            return this.base[0].func_177555_b();
        }

        public boolean func_177556_c() {
            return this.base[0].func_177556_c();
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base[0].func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

