/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.render.IHardCodedModel;
import cd4017be.lib.render.IModeledTESR;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.render.model.ModelContext;
import cd4017be.lib.render.model.ModelVariant;
import cd4017be.lib.render.model.RawModelData;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Script;
import cd4017be.lib.util.Orientation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpecialModelLoader
implements ICustomModelLoader {
    public static final String SCRIPT_PREFIX = "models/block/_";
    public static final SpecialModelLoader instance = new SpecialModelLoader();
    public static final StateMapper stateMapper = new StateMapper();
    private static String mod = "";
    private IResourceManager resourceManager;
    private HashMap<String, ModelContext> scriptModels = new HashMap();
    public HashMap<ResourceLocation, IModel> models = new HashMap();
    public HashSet<String> mods = new HashSet();
    public ArrayList<IModeledTESR> tesrs = new ArrayList();

    public static void setMod(String name) {
        mod = name;
        SpecialModelLoader.instance.mods.add(name);
    }

    public static void registerFluid(Fluid fluid) {
        Block block = fluid.getBlock();
        if (block == null || !mod.equals(block.getRegistryName().func_110624_b())) {
            return;
        }
        ModelFluid model = new ModelFluid(fluid);
        SpecialModelLoader.instance.models.put(new ResourceLocation(mod, "models/block/" + fluid.getName()), (IModel)model);
        ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)stateMapper);
    }

    public static void registerBlockModel(Block block, IModel model) {
        String[] name = block.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/block/" + name[1]), model);
    }

    public static void registerItemModel(Item item, IModel model) {
        String[] name = item.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/item/" + name[1]), model);
    }

    public static <T extends TileEntity> void registerTESR(Class<T> tile, TileEntitySpecialRenderer<T> tesr) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, tesr);
        if (tesr instanceof IModeledTESR) {
            SpecialModelLoader.instance.tesrs.add((IModeledTESR)tesr);
        }
    }

    private SpecialModelLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void cleanUp() {
        for (IModeledTESR tesr : this.tesrs) {
            tesr.bakeModels(this.resourceManager);
        }
        for (ModelContext cont : this.scriptModels.values()) {
            Iterator it = cont.modules.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Module m = (Module)e.getValue();
                if (!(m instanceof Script) || ((String)e.getKey()).startsWith("tesr.")) continue;
                it.remove();
            }
        }
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        this.cleanUp();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        Iterator<IModel> it = this.models.values().iterator();
        while (it.hasNext()) {
            IModel m = it.next();
            if (m instanceof IHardCodedModel) {
                ((IHardCodedModel)m).onReload();
                continue;
            }
            it.remove();
        }
        this.scriptModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.mods.contains(modelLocation.func_110624_b()) && (modelLocation.func_110623_a().startsWith(SCRIPT_PREFIX) || this.models.containsKey(modelLocation));
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        IModel model = this.models.get(modelLocation);
        if (model != null) {
            return model;
        }
        String path = modelLocation.func_110623_a();
        int p = path.indexOf(35);
        if (p >= 0) {
            String s = path.substring(p + 1);
            Orientation o = Orientation.valueOf(s.substring(0, 1).toUpperCase() + s.substring(1));
            model = this.loadModel(new ResourceLocation(modelLocation.func_110624_b(), path.substring(0, p)));
            return new ModelVariant(model, (IModelState)o.getModelRotation());
        }
        if (path.startsWith(SCRIPT_PREFIX) && (model = this.loadScriptModel(modelLocation)) != null) {
            this.models.put(modelLocation, model);
        }
        return model;
    }

    private IModel loadScriptModel(ResourceLocation modelLocation) throws Exception {
        String methodName;
        String domain = modelLocation.func_110624_b();
        String scriptName = modelLocation.func_110623_a().substring(SCRIPT_PREFIX.length());
        int p = scriptName.indexOf(46);
        if (p >= 0) {
            methodName = scriptName.substring(p + 1);
            scriptName = scriptName.substring(0, p);
        } else {
            methodName = "main()";
        }
        ModelContext cont = this.scriptModels.get(domain);
        if (cont == null) {
            cont = new ModelContext(new ResourceLocation(domain, "models/block/"));
            this.scriptModels.put(domain, cont);
        }
        Module script = cont.getOrLoad(scriptName, this.resourceManager);
        cont.run(script, methodName);
        return new RawModelData(script, cont);
    }

    public static IntArrayModel loadTESRModel(String domain, String name) throws Exception {
        String methodName;
        int p = name.indexOf(46);
        if (p >= 0) {
            methodName = name.substring(p + 1);
            name = name.substring(0, p);
        } else {
            methodName = "main()";
        }
        ModelContext cont = SpecialModelLoader.instance.scriptModels.get(domain);
        if (cont == null) {
            cont = new ModelContext(new ResourceLocation(domain, "models/block/"));
            SpecialModelLoader.instance.scriptModels.put(domain, cont);
        }
        Module script = cont.getOrLoad("tesr." + name, SpecialModelLoader.instance.resourceManager);
        cont.run(script, methodName);
        return new IntArrayModel(cont, IntArrayModel.getTextures(script));
    }

    public static class StateMapper
    implements IStateMapper {
        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
            ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), "normal");
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                map.put(state, loc);
            }
            return map;
        }
    }
}

