/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.block.AdvancedBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class MultipartBlock
extends AdvancedBlock {
    public PropertyInteger baseState;
    public IUnlistedProperty<?>[] modules;

    public MultipartBlock(String id, Material m, SoundType sound, int flags, Class<? extends TileEntity> tile) {
        super(id, m, sound, flags, tile);
    }

    protected abstract IUnlistedProperty<?>[] createModules();

    protected abstract PropertyInteger createBaseState();

    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray;
        this.baseState = this.createBaseState();
        this.modules = this.createModules();
        if (this.baseState == null) {
            iPropertyArray = new IProperty[]{};
        } else {
            IProperty[] iPropertyArray2 = new IProperty[1];
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[0] = this.baseState;
        }
        return new ExtendedBlockState((Block)this, iPropertyArray, this.modules);
    }

    public IBlockState func_176203_a(int meta) {
        return this.baseState == null ? this.func_176223_P() : this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.baseState, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.baseState == null ? 0 : (Integer)state.func_177229_b((IProperty)this.baseState);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB box = this.boundingBox[0];
        if (box == field_185505_j) {
            return box;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModularTile) {
            IModularTile tile = (IModularTile)te;
            for (int i = 1; i < this.boundingBox.length; ++i) {
                AxisAlignedBB box1 = this.boundingBox[i];
                if (box1 == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                if (box1 == field_185505_j) {
                    return box1;
                }
                box = box.func_111270_a(box1);
            }
        }
        return box;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> list, Entity entity, boolean b) {
        AxisAlignedBB box = this.boundingBox[0];
        MultipartBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)box);
        if (box == field_185505_j) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModularTile) {
            IModularTile tile = (IModularTile)te;
            for (int i = 1; i < this.boundingBox.length; ++i) {
                box = this.boundingBox[i];
                if (box == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                MultipartBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)box);
                if (box != field_185505_j) continue;
                return;
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te;
        int p = 0;
        AxisAlignedBB box = this.boundingBox[p];
        RayTraceResult collision = box.func_72327_a(start = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), end = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        if (collision != null) {
            end = collision.field_72307_f;
        }
        if (box != field_185505_j && (te = world.func_175625_s(pos)) instanceof IModularTile) {
            IModularTile tile = (IModularTile)te;
            for (int i = 1; i < this.boundingBox.length; ++i) {
                box = this.boundingBox[i];
                if (box == field_185506_k || !tile.isModulePresent(i - 1)) continue;
                RayTraceResult collision1 = box.func_72327_a(start, end);
                if (collision1 != null) {
                    collision = collision1;
                    end = collision.field_72307_f;
                    p = i;
                }
                if (box == field_185505_j) break;
            }
        }
        if (collision != null) {
            collision = new RayTraceResult(end.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collision.field_178784_b, pos);
            collision.subHit = p;
        }
        return collision;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState eState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModularTile) {
            IModularTile tile = (IModularTile)te;
            for (int i = 0; i < this.modules.length; ++i) {
                IUnlistedProperty<?> module = this.modules[i];
                eState = eState.withProperty(module, tile.getModuleState(i));
            }
        }
        return eState;
    }

    public static interface IModularTile {
        public <T> T getModuleState(int var1);

        public boolean isModulePresent(int var1);
    }
}

