/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.block.BaseBlock;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class AdvancedBlock
extends BaseBlock {
    public final Class<? extends TileEntity> tileEntity;
    protected EnumBlockRenderType renderType;
    protected AxisAlignedBB[] boundingBox;
    protected int flags;
    private BlockRenderLayer blockLayer = BlockRenderLayer.SOLID;

    public AdvancedBlock(String id, Material m, SoundType sound, int flags, @Nullable Class<? extends TileEntity> tile) {
        super(id, m);
        this.func_149672_a(sound);
        this.field_149787_q = (flags & 1) == 0;
        this.flags = flags << 15;
        this.tileEntity = tile;
        if (tile != null) {
            if (INeighborAwareTile.class.isAssignableFrom(tile)) {
                this.flags |= 1;
            }
            if (ISelfAwareTile.class.isAssignableFrom(tile)) {
                this.flags |= 2;
            }
            if (IInteractiveTile.class.isAssignableFrom(tile)) {
                this.flags |= 4;
            }
            if (ITilePlaceHarvest.class.isAssignableFrom(tile)) {
                this.flags |= 8;
            }
            if (IRedstoneTile.class.isAssignableFrom(tile)) {
                this.flags |= 0x10;
            }
            if (ITileCollision.class.isAssignableFrom(tile)) {
                this.flags |= 0x20;
            }
            if ((flags & 4) == 0 && DataContainer.IGuiData.class.isAssignableFrom(tile)) {
                this.flags |= 0x40;
            }
            GameRegistry.registerTileEntity(this.tileEntity, (String)this.getRegistryName().toString());
        }
        this.renderType = EnumBlockRenderType.MODEL;
        this.boundingBox = new AxisAlignedBB[]{field_185505_j};
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileEntity != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.tileEntity != null) {
            try {
                try {
                    return this.tileEntity.getConstructor(IBlockState.class).newInstance(state);
                }
                catch (NoSuchMethodException e) {
                    return this.tileEntity.newInstance();
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block b, BlockPos src) {
        if ((this.flags & 1) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof INeighborAwareTile) {
            ((INeighborAwareTile)te).neighborBlockChange(b, src);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos npos) {
        if ((this.flags & 1) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof INeighborAwareTile) {
            ((INeighborAwareTile)te).neighborTileChange(npos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if ((this.flags & 2) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ISelfAwareTile) {
            ((ISelfAwareTile)te).breakBlock();
        }
        world.func_175713_t(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing s, float X, float Y, float Z) {
        TileEntity te;
        if ((this.flags & 4) != 0 && (te = world.func_175625_s(pos)) instanceof IInteractiveTile && ((IInteractiveTile)te).onActivated(player, hand, player.func_184586_b(hand), s, X, Y, Z)) {
            return true;
        }
        if ((this.flags & 0x40) != 0) {
            BlockGuiHandler.openBlockGui(player, world, pos);
            return true;
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if ((this.flags & 4) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInteractiveTile) {
            ((IInteractiveTile)te).onClicked(player);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        if ((this.flags & 8) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITilePlaceHarvest) {
            ((ITilePlaceHarvest)te).onPlaced(entity, item);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (!(te instanceof ITilePlaceHarvest)) {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((this.flags & 8) != 0) {
            super.func_180657_a(world, player, pos, state, null, player.func_184614_ca());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if ((this.flags & 8) == 0) {
            return super.getDrops(world, pos, state, fortune);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITilePlaceHarvest) {
            return ((ITilePlaceHarvest)te).dropItem(state, fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean func_149744_f(IBlockState state) {
        return (this.flags & 0x10) != 0;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (this.flags & 0x10) == 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if ((this.flags & 0x10) == 0) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).redstoneLevel(s.func_176734_d(), false);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        if ((this.flags & 0x10) == 0) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).redstoneLevel(s.func_176734_d(), true);
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if ((this.flags & 0x10) == 0) {
            return false;
        }
        if (side == null) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IRedstoneTile) {
            return ((IRedstoneTile)te).connectRedstone(side.func_176734_d());
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if ((this.flags & 0x20) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITileCollision) {
            ((ITileCollision)te).onEntityCollided(entity);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return (this.flags & 0x10000) == 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.boundingBox[0] == field_185505_j;
    }

    public boolean func_149721_r(IBlockState state) {
        return this.boundingBox[0] == field_185505_j;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos) == field_185505_j;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        AxisAlignedBB box = this.func_185496_a(state, world, pos);
        if (box == field_185505_j) {
            return true;
        }
        switch (side) {
            case DOWN: {
                return box.field_72338_b == AdvancedBlock.field_185505_j.field_72338_b;
            }
            case UP: {
                return box.field_72337_e == AdvancedBlock.field_185505_j.field_72337_e;
            }
            case NORTH: {
                return box.field_72339_c == AdvancedBlock.field_185505_j.field_72339_c;
            }
            case SOUTH: {
                return box.field_72334_f == AdvancedBlock.field_185505_j.field_72334_f;
            }
            case WEST: {
                return box.field_72340_a == AdvancedBlock.field_185505_j.field_72340_a;
            }
            case EAST: {
                return box.field_72336_d == AdvancedBlock.field_185505_j.field_72336_d;
            }
        }
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void setRenderType(EnumBlockRenderType t) {
        this.renderType = t;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.renderType;
    }

    public void setBlockLayer(BlockRenderLayer layer) {
        this.blockLayer = layer;
    }

    public BlockRenderLayer func_180664_k() {
        return this.blockLayer;
    }

    public AdvancedBlock setBlockBounds(AxisAlignedBB box) {
        this.boundingBox[0] = box;
        return this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox.length == 1 ? this.boundingBox[0] : this.boundingBox[this.func_176201_c(state)];
    }

    public static interface ITileCollision {
        public void onEntityCollided(Entity var1);
    }

    public static interface IRedstoneTile {
        public int redstoneLevel(EnumFacing var1, boolean var2);

        public boolean connectRedstone(EnumFacing var1);
    }

    public static interface ITilePlaceHarvest {
        public void onPlaced(EntityLivingBase var1, ItemStack var2);

        public List<ItemStack> dropItem(IBlockState var1, int var2);
    }

    public static interface IInteractiveTile {
        public boolean onActivated(EntityPlayer var1, EnumHand var2, ItemStack var3, EnumFacing var4, float var5, float var6, float var7);

        public void onClicked(EntityPlayer var1);
    }

    public static interface ISelfAwareTile {
        public void breakBlock();
    }

    public static interface INeighborAwareTile {
        public void neighborBlockChange(Block var1, BlockPos var2);

        public void neighborTileChange(BlockPos var1);
    }
}

