/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.block.AdvancedBlock;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickRegistry {
    public static final TickRegistry instance = new TickRegistry();
    public ArrayList<IUpdatable> updates = new ArrayList();
    private ArrayList<IUpdatable> swapList = new ArrayList();

    public static void register() {
    }

    private TickRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END && !this.updates.isEmpty()) {
            ArrayList<IUpdatable> list = this.updates;
            this.updates = this.swapList;
            this.swapList = list;
            for (IUpdatable update : list) {
                update.process();
            }
            list.clear();
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load ev) {
        Chunk chunk = ev.getChunk();
        World world = chunk.func_177412_p();
        ChunkPos cp = chunk.func_76632_l();
        boolean loadedN = world.func_175667_e(cp.func_180331_a(0, 0, -1));
        boolean loadedS = world.func_175667_e(cp.func_180331_a(0, 0, 16));
        boolean loadedW = world.func_175667_e(cp.func_180331_a(-1, 0, 0));
        boolean loadedE = world.func_175667_e(cp.func_180331_a(16, 0, 0));
        for (BlockPos pos : chunk.func_177434_r().keySet()) {
            int x = pos.func_177958_n() & 0xF;
            int z = pos.func_177952_p() & 0xF;
            if (z == 0 && loadedN) {
                this.notifyNeighborTile(world, pos, EnumFacing.NORTH);
            } else if (z == 15 && loadedS) {
                this.notifyNeighborTile(world, pos, EnumFacing.SOUTH);
            }
            if (x == 0 && loadedW) {
                this.notifyNeighborTile(world, pos, EnumFacing.WEST);
                continue;
            }
            if (x != 15 || !loadedE) continue;
            this.notifyNeighborTile(world, pos, EnumFacing.EAST);
        }
    }

    private void notifyNeighborTile(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te instanceof AdvancedBlock.INeighborAwareTile) {
            ((AdvancedBlock.INeighborAwareTile)te).neighborTileChange(pos);
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload ev) {
        for (TileEntity te : ev.getChunk().func_177434_r().values()) {
            te.field_145846_f = true;
        }
    }

    public static interface IUpdatable {
        public void process();
    }
}

