/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.api.Capabilities;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.api.energy.EnergyAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.item.ItemMaterial;
import cd4017be.lib.render.ItemMaterialMeshDefinition;
import cd4017be.lib.templates.TabMaterials;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.TooltipUtil;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="cd4017be_lib", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class Lib {
    public static final String ID = "cd4017be_lib";
    @Mod.Instance
    public static Lib instance;
    public static ItemMaterial materials;
    public static final TabMaterials creativeTab;

    public Lib() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FileUtil.initConfigDir(event);
        BlockGuiHandler.register();
        Capabilities.register();
        EnergyAPI.init();
        materials = new ItemMaterial("m");
        materials.func_77637_a(creativeTab);
        Lib.creativeTab.item = new ItemStack((Item)materials);
        RecipeScriptContext.instance = new RecipeScriptContext();
        RecipeScriptContext.instance.setup();
        RecipeScriptContext.instance.run("core.PRE_INIT");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ComputerAPI.register();
        RecipeScriptContext.instance.runAll("INIT");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeScriptContext.instance.runAll("POST_INIT");
        TooltipUtil.addScriptVariables();
    }

    @Mod.EventHandler
    public void afterStart(FMLServerAboutToStartEvent event) {
        RecipeScriptContext.instance = null;
        System.gc();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> ev) {
        ev.getRegistry().register((IForgeRegistryEntry)materials);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerMaterialModels(ModelRegistryEvent ev) {
        BlockItemRegistry.registerRender(materials, (ItemMeshDefinition)new ItemMaterialMeshDefinition(materials));
    }

    static {
        creativeTab = new TabMaterials(ID);
    }
}

