/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.script.Context;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.OreDictStack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class RecipeScriptContext
extends Context {
    private static final Function<Parameters, Object> IT = p -> {
        ItemStack item = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            if (name.indexOf(58) < 0) {
                item = BlockItemRegistry.stack(name, 1);
            } else if (name.startsWith("ore:")) {
                NonNullList list = OreDictionary.getOres((String)(name = name.substring(4)));
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("empty OreDictionary type: " + name);
                }
                item = ((ItemStack)list.get(0)).func_77946_l();
            } else {
                item = new ItemStack(Item.func_111206_d((String)name));
            }
            if (item == null || item.func_77973_b() == null) {
                throw new IllegalArgumentException("invalid item name: " + name);
            }
        } else if (o instanceof ItemStack) {
            item = ((ItemStack)o).func_77946_l();
        } else {
            if (o instanceof OreDictStack) {
                ItemStack[] arr = ((OreDictStack)o).getItems();
                return Arrays.copyOf(arr, arr.length, Object[].class);
            }
            throw new IllegalArgumentException("expected String, ItemStack or OreDictStack @ 0");
        }
        switch (p.param.length) {
            case 4: {
                item.func_77982_d(p.get(3, NBTTagCompound.class));
            }
            case 3: {
                item.func_77964_b((int)p.getNumber(2));
            }
            case 2: {
                item.func_190920_e((int)p.getNumber(1));
            }
        }
        return item;
    };
    private static final Function<Parameters, Object> FL = p -> {
        FluidStack fluid = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            fluid = FluidRegistry.getFluidStack((String)name, (int)0);
            if (fluid == null) {
                throw new IllegalArgumentException("invalid fluid name: " + name);
            }
        } else if (o instanceof FluidStack) {
            fluid = ((FluidStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or FluidStack @ 0");
        }
        switch (p.param.length) {
            case 3: {
                fluid.tag = p.get(2, NBTTagCompound.class);
            }
            case 2: {
                fluid.amount = (int)p.getNumber(1);
            }
        }
        return fluid;
    };
    private static final Function<Parameters, Object> ORE = p -> {
        OreDictStack ore = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            ore = new OreDictStack(name, 1);
        } else if (o instanceof OreDictStack) {
            ore = ((OreDictStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or OreDictStack @ 0");
        }
        if (p.param.length == 2) {
            ore.stacksize = (int)p.getNumber(1);
        }
        return ore;
    };
    private static final Function<Parameters, Object> HASIT = p -> {
        for (Object o : p.param) {
            String name = (String)o;
            if (!(name.indexOf(58) < 0 ? BlockItemRegistry.stack(name, 1) == null : (name.startsWith("ore:") ? OreDictionary.getOres((String)name.substring(4)).isEmpty() : Item.func_111206_d((String)name) == null))) continue;
            return false;
        }
        return true;
    };
    private static final Function<Parameters, Object> HASFL = p -> {
        for (Object o : p.param) {
            if (FluidRegistry.isFluidRegistered((String)((String)o))) continue;
            return false;
        }
        return true;
    };
    private static final Function<Parameters, Object> ORES = p -> OreDictionary.getOres((String)p.getString(0)).toArray();
    private static final Function<Parameters, Object> HASMOD = p -> Loader.isModLoaded((String)p.getString(0));
    private static final Function<Parameters, Object> ADD = p -> {
        RecipeAPI.IRecipeHandler h = RecipeAPI.Handlers.get(p.getString(0));
        if (h == null) {
            throw new IllegalArgumentException(String.format("recipe Handler \"%s\" does'nt exist!", p.param[0]));
        }
        h.addRecipe((Parameters)p);
        return null;
    };
    private static final Function<Parameters, Object> LISTORE = p -> {
        Pattern filter = Pattern.compile(p.getString(0));
        ArrayList<String> list = new ArrayList<String>();
        for (String name : OreDictionary.getOreNames()) {
            if (!filter.matcher(name).matches()) continue;
            list.add(name);
        }
        return list.toArray();
    };
    private static final Function<Parameters, Object> LIST = p -> {
        RecipeAPI.IRecipeList l = RecipeAPI.Lists.get(p.getString(0));
        if (l == null) {
            throw new IllegalArgumentException(String.format("recipe List \"%s\" does'nt exist!", p.param[0]));
        }
        return l.list((Parameters)p);
    };
    private static final Function<Parameters, Object> ISIT = p -> new ItemMatcher(p.get(0, ItemStack.class));
    private static final Function<Parameters, Object> ISFL = p -> new FluidMatcher(p.get(0, FluidStack.class));
    private static final Function<Parameters, Object> N = p -> {
        Object o = p.get(0);
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_190916_E();
        }
        if (o instanceof FluidStack) {
            return ((FluidStack)o).amount;
        }
        if (o instanceof OreDictStack) {
            return ((OreDictStack)o).stacksize;
        }
        return 0;
    };
    public static final List<ScriptFiles.Version> scriptRegistry = new ArrayList<ScriptFiles.Version>();
    public static RecipeScriptContext instance;

    public RecipeScriptContext() {
        this.defFunc.put("it", IT);
        this.defFunc.put("fl", FL);
        this.defFunc.put("ore", ORE);
        this.defFunc.put("hasit", HASIT);
        this.defFunc.put("hasfl", HASFL);
        this.defFunc.put("ores", ORES);
        this.defFunc.put("hasmod", HASMOD);
        this.defFunc.put("add", ADD);
        this.defFunc.put("listore", LISTORE);
        this.defFunc.put("list", LIST);
        this.defFunc.put("isit", ISIT);
        this.defFunc.put("isfl", ISFL);
        this.defFunc.put("n", N);
    }

    public void setup() {
        Script[] scripts;
        File dir = FileUtil.configDir;
        File comp = new File(dir, "compiled.dat");
        HashMap<String, ScriptFiles.Version> versions = new HashMap<String, ScriptFiles.Version>();
        for (ScriptFiles.Version v : scriptRegistry) {
            if (v.fallback == null) continue;
            versions.put(v.name, v);
        }
        boolean reload = true;
        try {
            scripts = ScriptFiles.loadPackage(comp, versions, true);
        }
        catch (IOException e) {
            scripts = null;
            reload = false;
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"loading compiled config scripts failed!", (Object[])new Object[0]);
        }
        for (ScriptFiles.Version v : versions.values()) {
            try {
                FileUtil.copyData(v.fallback, new File(dir, v.name + ".rcp"));
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"copying script preset failed!", (Object[])new Object[0]);
            }
        }
        if (scripts == null && (scripts = ScriptFiles.createCompiledPackage(comp)) == null && reload) {
            try {
                FMLLog.log((Level)Level.INFO, (String)"Falling back to old scripts", (Object[])new Object[0]);
                scripts = ScriptFiles.loadPackage(comp, versions, false);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"loading compiled config scripts failed!", (Object[])new Object[0]);
            }
        }
        if (scripts != null) {
            for (Script s : scripts) {
                this.add(s);
            }
        }
    }

    public void runAll(String p) {
        for (ScriptFiles.Version v : scriptRegistry) {
            this.run(v.name + "." + p);
        }
    }

    public void run(String name) {
        this.reset();
        try {
            this.invoke(name, new Parameters(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.INFO, (String)"skipped %s", (Object[])new Object[]{name});
        }
        catch (ScriptException e) {
            FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.ERROR, (Throwable)e, (String)"script execution failed for %s", (Object[])new Object[]{name});
        }
    }

    static {
        scriptRegistry.add(new ScriptFiles.Version("core"));
    }

    public static class ConfigConstants {
        private final Module m;

        public ConfigConstants(Module m) {
            this.m = m;
        }

        public double getNumber(String name, double fallback) {
            Object o = this.m.read(name);
            if (o instanceof Double) {
                return (Double)o;
            }
            this.m.assign(name, fallback);
            return fallback;
        }

        public double[] getVect(String name, double[] pre) {
            Object o = this.m.read(name);
            if (o instanceof double[]) {
                int i;
                double[] vec = (double[])o;
                int n = Math.min(vec.length, pre.length);
                for (i = 0; i < n; ++i) {
                    pre[i] = vec[i];
                }
                if (n < pre.length) {
                    vec = Arrays.copyOf(vec, pre.length);
                    this.m.assign(name, vec);
                    for (i = n; i < vec.length; ++i) {
                        vec[i] = pre[i];
                    }
                }
                return pre;
            }
            double[] vec = new double[pre.length];
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = pre[i];
            }
            this.m.assign(name, vec);
            return pre;
        }

        public int[] getVect(String name, int[] pre) {
            Object o = this.m.read(name);
            if (o instanceof double[]) {
                int i;
                double[] vec = (double[])o;
                int n = Math.min(vec.length, pre.length);
                for (i = 0; i < n; ++i) {
                    pre[i] = (int)vec[i];
                }
                if (n < pre.length) {
                    vec = Arrays.copyOf(vec, pre.length);
                    this.m.assign(name, vec);
                    for (i = n; i < vec.length; ++i) {
                        vec[i] = pre[i];
                    }
                }
                return pre;
            }
            double[] vec = new double[pre.length];
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = pre[i];
            }
            this.m.assign(name, vec);
            return pre;
        }

        public float[] getVect(String name, float[] pre) {
            Object o = this.m.read(name);
            if (o instanceof double[]) {
                int i;
                double[] vec = (double[])o;
                int n = Math.min(vec.length, pre.length);
                for (i = 0; i < n; ++i) {
                    pre[i] = (float)vec[i];
                }
                if (n < pre.length) {
                    vec = Arrays.copyOf(vec, pre.length);
                    this.m.assign(name, vec);
                    for (i = n; i < vec.length; ++i) {
                        vec[i] = pre[i];
                    }
                }
                return pre;
            }
            double[] vec = new double[pre.length];
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = pre[i];
            }
            this.m.assign(name, vec);
            return pre;
        }

        public <T> T get(String name, Class<T> type, T fallback) {
            Object o = this.m.read(name);
            if (type.isInstance(o)) {
                return type.cast(o);
            }
            this.m.assign(name, fallback);
            return fallback;
        }

        public Object[] getArray(String name, int size) {
            Object o = this.m.read(name);
            if (o instanceof Object[]) {
                Object[] vec = (Object[])o;
                if (vec.length < size) {
                    vec = Arrays.copyOf(vec, size);
                    this.m.assign(name, vec);
                }
                return vec;
            }
            Object[] vec = new Object[size];
            this.m.assign(name, vec);
            return vec;
        }
    }

    public static class FluidMatcher {
        private final FluidStack ref;
        private final boolean ignAm;

        public FluidMatcher(FluidStack stack) {
            this.ref = stack;
            this.ignAm = stack.amount <= 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FluidStack)) {
                return false;
            }
            FluidStack fluid = (FluidStack)obj;
            return fluid.getFluid() == this.ref.getFluid() && (this.ignAm || fluid.amount == this.ref.amount);
        }
    }

    public static class ItemMatcher {
        private final ItemStack ref;
        private final boolean ignDmg;
        private final boolean ignAm;

        public ItemMatcher(ItemStack stack) {
            this.ref = stack;
            this.ignDmg = stack.func_77952_i() == Short.MAX_VALUE;
            this.ignAm = stack.func_190916_E() <= 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemStack)) {
                return false;
            }
            ItemStack item = (ItemStack)obj;
            return !(item.func_77973_b() != this.ref.func_77973_b() || !this.ignDmg && item.func_77952_i() != this.ref.func_77952_i() || !this.ignAm && item.func_190916_E() != this.ref.func_190916_E());
        }
    }
}

