/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.OreGenHandler;
import cd4017be.lib.Lib;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.templates.NBTRecipe;
import cd4017be.lib.util.OreDictStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeAPI {
    public static final HashMap<String, IRecipeHandler> Handlers = new HashMap();
    public static final HashMap<String, IRecipeList> Lists = new HashMap();
    private static final HashMap<String, Integer> UsedNames = new HashMap();

    private static Object[] decodePattern(Parameters p, int i0) {
        String s = p.getString(i0++);
        String[] pattern = s.split("/");
        int n = p.param.length - i0;
        Object[] arr = new Object[n * 2 + pattern.length];
        int j = 0;
        for (String l : pattern) {
            arr[j++] = l;
        }
        for (int i = 0; i < n; ++i) {
            char c = Character.forDigit(i, 9);
            if (s.indexOf(c) < 0) continue;
            arr[j++] = Character.valueOf(c);
            arr[j++] = p.param[i + i0];
        }
        return j < arr.length ? Arrays.copyOf(arr, j) : arr;
    }

    public static String genericName(IRecipe rcp) {
        ItemStack stack = rcp.func_77571_b();
        Item item = stack.func_77973_b();
        ResourceLocation res = item.getRegistryName();
        String name = res.func_110624_b() + "/" + res.func_110623_a();
        if (item.func_77614_k()) {
            name = name + "_" + stack.func_77952_i();
        }
        int n = UsedNames.getOrDefault(name, 0);
        UsedNames.put(name, n + 1);
        if (n > 0) {
            name = name + "_" + RecipeAPI.asLetter(n);
        }
        return name;
    }

    private static String asLetter(int i) {
        String s = "";
        do {
            s = s + (char)(i % 26 + 97);
        } while ((i /= 26) > 26);
        return s;
    }

    private static <T extends IForgeRegistryEntry.Impl<IRecipe>> void addRecipe(T rcp) {
        ForgeRegistries.RECIPES.register(rcp.setRegistryName(RecipeAPI.genericName((IRecipe)rcp)));
    }

    public static Predicate<Object> getFilter(Object o) {
        if (o instanceof String) {
            return new RegexFilter((String)o);
        }
        if (o instanceof ItemStack) {
            ItemStack item = (ItemStack)o;
            return p -> p instanceof ItemStack && item.func_77969_a((ItemStack)p);
        }
        if (o instanceof FluidStack) {
            FluidStack fluid = (FluidStack)o;
            return p -> p instanceof FluidStack && fluid.isFluidEqual((FluidStack)p);
        }
        if (o instanceof OreDictStack) {
            OreDictStack ore = (OreDictStack)o;
            return p -> p instanceof OreDictStack ? ore.ID == ((OreDictStack)p).ID : (p instanceof String ? ore.id.equals((String)p) : p instanceof ItemStack && ore.isEqual((ItemStack)p));
        }
        if (o == null) {
            return p -> p == null;
        }
        return p -> o.equals(p);
    }

    public static void createOreDictEntries(Class<?> c, String name) {
        block3: {
            block2: {
                if (!Block.class.isAssignableFrom(c)) break block2;
                for (Block block : Block.field_149771_c) {
                    Item item;
                    if (!c.isInstance(block) || (item = Item.func_150898_a((Block)block)) == null) continue;
                    OreDictionary.registerOre((String)name, (Item)item);
                }
                break block3;
            }
            if (!Item.class.isAssignableFrom(c)) break block3;
            for (Item item : Item.field_150901_e) {
                if (!c.isInstance(item)) continue;
                OreDictionary.registerOre((String)name, (Item)item);
            }
        }
    }

    static {
        Handlers.put("shaped", p -> RecipeAPI.addRecipe(new ShapedOreRecipe(null, p.get(1, ItemStack.class), RecipeAPI.decodePattern(p, 2))));
        Handlers.put("shapedNBT", p -> RecipeAPI.addRecipe(new NBTRecipe(null, p.get(2, ItemStack.class), p.getString(1), RecipeAPI.decodePattern(p, 3))));
        Handlers.put("ore", p -> {
            String name = p.getString(1);
            for (int i = 2; i < p.param.length; ++i) {
                OreDictionary.registerOre((String)name, (ItemStack)p.get(i, ItemStack.class));
            }
        });
        Lists.put("ore", p -> new Function.FilteredIterator(new Function.ArrayIterator(OreDictionary.getOreNames()), new RegexFilter(p.getString(1))));
        Lists.put("craftIng", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), false));
        Lists.put("craftRes", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), true));
        Handlers.put("shapeless", p -> RecipeAPI.addRecipe(new ShapelessOreRecipe(null, p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length))));
        Handlers.put("smelt", p -> GameRegistry.addSmelting((ItemStack)p.get(1, ItemStack.class), (ItemStack)p.get(2, ItemStack.class), (float)(p.param.length > 3 ? (float)p.getNumber(3) : 0.0f)));
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        Handlers.put("item", p -> Lib.materials.addMaterial((int)p.getNumber(1), p.getString(2)));
    }

    private static class IngredientIterator
    extends Function.ListIterator<Ingredient> {
        private final Predicate<Object> key;
        private Object curElement;

        public IngredientIterator(NonNullList<Ingredient> rcp, Predicate<Object> key) {
            super(rcp);
            this.key = key;
        }

        @Override
        public Object get() {
            return this.curElement;
        }

        @Override
        public void set(Object o) {
            if (o == this.curElement) {
                return;
            }
            if (o instanceof ItemStack) {
                this.arr.set(this.idx, (Ingredient)o);
            } else if (o instanceof OreDictStack) {
                this.arr.set(this.idx, new OreIngredient(((OreDictStack)o).id));
            } else if (o == null) {
                this.arr.remove(this.idx--);
            } else {
                throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
            }
        }

        @Override
        public boolean next() {
            while (++this.idx < this.arr.size()) {
                this.curElement = this.arr.get(this.idx);
                if (this.curElement instanceof List) {
                    List list = (List)this.curElement;
                    if (list.isEmpty()) continue;
                    if (this.key == null) {
                        this.curElement = list.get(0);
                        return true;
                    }
                    for (Object o : list) {
                        if (!this.key.test(o)) continue;
                        this.curElement = o;
                        return true;
                    }
                    continue;
                }
                if (this.key != null && !this.key.test(this.curElement)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CraftingRecipeIterator
    implements Function.Iterator {
        private Iterator<IRecipe> list;
        private final Predicate<Object> key;
        private final boolean in;
        private Object[] curElement;
        private IRecipe curRecipe;

        public CraftingRecipeIterator(Predicate<Object> key, boolean res) {
            this.key = key;
            this.list = CraftingManager.field_193380_a.iterator();
            this.in = !res;
        }

        @Override
        public Object get() {
            return this.curElement;
        }

        @Override
        public void set(Object o) {
            if (o == null) {
                this.list.remove();
            } else if (o == this.curElement && this.curElement[0] != this.curRecipe.func_77571_b()) {
                if (!(this.curElement[0] instanceof ItemStack)) {
                    throw new IllegalArgumentException("ItemStack expected");
                }
                ItemStack item = (ItemStack)this.curElement[0];
                ItemStack itemStack = this.curRecipe.func_77571_b();
            }
        }

        @Override
        public boolean next() {
            while (this.list.hasNext()) {
                this.curRecipe = this.list.next();
                ItemStack result = this.curRecipe.func_77571_b();
                if (!this.in && !this.key.test(result)) continue;
                IngredientIterator ingred = new IngredientIterator((NonNullList<Ingredient>)this.curRecipe.func_192400_c(), this.key);
                this.curElement = new Object[]{result, ingred};
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.list = CraftingManager.field_193380_a.iterator();
        }
    }

    public static class RegexFilter
    implements Predicate<Object> {
        private final Pattern pattern;

        public RegexFilter(String expr) {
            this.pattern = Pattern.compile(expr);
        }

        @Override
        public boolean test(Object o) {
            return o != null && this.pattern.matcher(o.toString()).matches();
        }
    }

    private static class FuelHandler
    implements IRecipeHandler {
        HashMap<Integer, Integer> fuelList = new HashMap();

        public FuelHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        int key(ItemStack item) {
            return Item.func_150891_b((Item)item.func_77973_b()) & 0xFFFF | (item.func_77952_i() & 0xFFFF) << 16;
        }

        @Override
        public void addRecipe(Parameters p) {
            this.fuelList.put(this.key(p.get(1, ItemStack.class)), (int)p.getNumber(2));
        }

        @SubscribeEvent
        public void getBurnTime(FurnaceFuelBurnTimeEvent ev) {
            Integer val = this.fuelList.get(this.key(ev.getItemStack()));
            if (val != null) {
                ev.setBurnTime(val.intValue());
            }
        }
    }

    public static interface IRecipeList {
        public Function.Iterator list(Parameters var1);
    }

    public static interface IRecipeHandler {
        public void addRecipe(Parameters var1);
    }
}

