/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.api.automation.IAreaConfig;
import cd4017be.api.automation.IProtectionHandler;
import cd4017be.api.automation.ProtectLvl;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AreaProtect
implements ForgeChunkManager.LoadingCallback,
IProtectionHandler {
    public static byte permissions = 1;
    public static byte chunkloadPerm = 1;
    public static byte maxChunksPBlock = (byte)24;
    public static AreaProtect instance = new AreaProtect();
    private static boolean registered = false;
    private static Object mod;
    public static ArrayList<IProtectionHandler> handlers;
    public HashMap<Integer, ArrayList<IAreaConfig>> loadedSS = new HashMap();
    public HashMap<Integer, ArrayList<ForgeChunkManager.Ticket>> usedTickets = new HashMap();

    public static void register(Object mod) {
        if (!registered) {
            AreaProtect.mod = mod;
            if (permissions >= 0) {
                MinecraftForge.EVENT_BUS.register((Object)instance);
                handlers.add(instance);
            }
            if (chunkloadPerm >= 0) {
                ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)instance);
            }
        }
        registered = true;
    }

    @SubscribeEvent
    public void handlePlayerInteract(PlayerInteractEvent event) {
        if (permissions < 0 || event.getSide() == Side.CLIENT) {
            return;
        }
        ProtectLvl pl = this.getPlayerAccess(event.getEntityPlayer().func_146103_bH(), event.getEntityPlayer().field_70170_p, event.getPos().func_177958_n() >> 4, event.getPos().func_177952_p() >> 4);
        if (pl == ProtectLvl.Free) {
            return;
        }
        if (event instanceof PlayerInteractEvent.LeftClickBlock || event.getItemStack() != null || pl == ProtectLvl.NoAcces || pl == ProtectLvl.NoInventory) {
            event.setCanceled(true);
        }
    }

    public static ProtectLvl playerAccess(GameProfile name, World world, int chunkX, int chunkZ) {
        ProtectLvl lvl = ProtectLvl.Free;
        for (IProtectionHandler handler : handlers) {
            ProtectLvl tmp = handler.getPlayerAccess(name, world, chunkX, chunkZ);
            if (tmp == ProtectLvl.NoInventory) {
                return tmp;
            }
            if (tmp.ordinal() <= lvl.ordinal()) continue;
            lvl = tmp;
        }
        return lvl;
    }

    public static boolean operationAllowed(GameProfile player, World world, int cx, int cz) {
        for (IProtectionHandler handler : handlers) {
            if (handler.isOperationAllowed(player, world, cx, cz)) continue;
            return false;
        }
        return true;
    }

    public static boolean operationAllowed(GameProfile player, World world, int x0, int x1, int z0, int z1) {
        for (IProtectionHandler handler : handlers) {
            if (handler.isOperationAllowed(player, world, x0, x1, z0, z1)) continue;
            return false;
        }
        return true;
    }

    public static boolean interactingAllowed(GameProfile player, World world, int cx, int cz) {
        for (IProtectionHandler handler : handlers) {
            if (handler.isInteractingAllowed(player, world, cx, cz)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ProtectLvl getPlayerAccess(GameProfile player, World world, int chunkX, int chunkZ) {
        int ac = 0;
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.getDimension());
        if (list == null) {
            return ProtectLvl.Free;
        }
        for (IAreaConfig cfg : list) {
            ac = Math.max(ac, cfg.getProtectLvlFor(player.getName(), chunkX, chunkZ));
        }
        return ProtectLvl.getLvl(ac);
    }

    @Override
    public boolean isOperationAllowed(GameProfile player, World world, int cx, int cz) {
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.getDimension());
        if (list == null) {
            return true;
        }
        for (IAreaConfig cfg : list) {
            if (cfg.getProtectLvlFor(player.getName(), cx, cz) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOperationAllowed(GameProfile player, World world, int x0, int x1, int z0, int z1) {
        z0 >>= 4;
        x1 = x1 + 15 >> 4;
        z1 = z1 + 15 >> 4;
        for (int cx = x0 >>= 4; cx < x1; ++cx) {
            for (int cz = z0; cz < z1; ++cz) {
                if (this.isOperationAllowed(player, world, cx, cz)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isInteractingAllowed(GameProfile player, World world, int cx, int cz) {
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.getDimension());
        if (list == null) {
            return true;
        }
        for (IAreaConfig cfg : list) {
            if (cfg.getProtectLvlFor(player.getName(), cx, cz) <= 1) continue;
            return false;
        }
        return true;
    }

    public void loadSecuritySys(IAreaConfig config) {
        int[] pos = config.getPosition();
        ArrayList<IAreaConfig> list = this.loadedSS.get(pos[3]);
        if (list == null) {
            list = new ArrayList();
            this.loadedSS.put(pos[3], list);
        }
        list.add(config);
        ArrayList<ForgeChunkManager.Ticket> tickets = this.usedTickets.get(pos[3]);
        if (tickets != null) {
            for (ForgeChunkManager.Ticket t : tickets) {
                NBTTagCompound tag = t.getModData();
                if (tag.func_74762_e("bx") != pos[0] || tag.func_74762_e("by") != pos[1] || tag.func_74762_e("bz") != pos[2]) continue;
                config.setTicket(t);
                break;
            }
        }
    }

    public void removeChunkLoader(IAreaConfig config) {
        int d = config.getPosition()[3];
        ArrayList<ForgeChunkManager.Ticket> list = this.usedTickets.get(d);
        ForgeChunkManager.Ticket t = config.getTicket();
        if (t != null) {
            config.setTicket(null);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.usedTickets.remove(d);
                }
            }
        }
    }

    public void supplyTicket(IAreaConfig config, World world) {
        ForgeChunkManager.Ticket t;
        NBTTagCompound tag;
        if (chunkloadPerm < 0) {
            return;
        }
        int[] p = config.getPosition();
        ArrayList<ForgeChunkManager.Ticket> list = this.usedTickets.get(p[3]);
        if (list != null) {
            for (ForgeChunkManager.Ticket t2 : list) {
                tag = t2.getModData();
                if (tag.func_74762_e("bx") != p[0] || tag.func_74762_e("by") != p[1] || tag.func_74762_e("bz") != p[2]) continue;
                config.setTicket(t2);
                return;
            }
        }
        if ((t = ForgeChunkManager.requestTicket((Object)mod, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) == null) {
            return;
        }
        tag = t.getModData();
        tag.func_74768_a("bx", p[0]);
        tag.func_74768_a("by", p[1]);
        tag.func_74768_a("bz", p[2]);
        t.setChunkListDepth((int)maxChunksPBlock);
        config.setTicket(t);
    }

    public void unloadSecuritySys(IAreaConfig config) {
        int d = config.getPosition()[3];
        ArrayList<IAreaConfig> list = this.loadedSS.get(d);
        if (list != null) {
            list.remove(config);
            if (list.isEmpty()) {
                this.loadedSS.remove(d);
            }
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        ArrayList<Object> list = this.usedTickets.get(world.field_73011_w.getDimension());
        if (list == null) {
            list = new ArrayList();
            this.usedTickets.put(world.field_73011_w.getDimension(), list);
        }
        list.addAll(tickets);
    }

    static {
        handlers = new ArrayList();
    }
}

