/*
 * Decompiled with CFR 0.152.
 */
package multiblock;

import cd4017be.api.IAbstractTile;
import cd4017be.circuits.Objects;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.templates.MultiblockComp;
import cd4017be.lib.util.Utils;
import multiblock.SharedInteger;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class IntegerComp
extends MultiblockComp<IntegerComp, SharedInteger> {
    public final int mask;
    public int inputState;
    public short rsIO;

    public IntegerComp(IAbstractTile tile, int bitSize) {
        super(tile);
        this.mask = -1 >>> 32 - bitSize;
    }

    public void onStateChange() {
        for (int i = 0; i < 6; ++i) {
            if ((this.rsIO >> i * 2 & 2) == 0) continue;
            Utils.updateRedstoneOnSide((TileEntity)((TileEntity)this.tile), (int)((SharedInteger)this.network).outputState, (EnumFacing)EnumFacing.field_82609_l[i]);
        }
    }

    public void setConnect(byte side, boolean c) {
        boolean c0 = this.canConnect(side);
        if (!c && c0) {
            ((SharedInteger)this.network).onDisconnect(this, side);
            this.con = (byte)(this.con & ~(1 << side));
        } else if (c && !c0) {
            this.con = (byte)(this.con | 1 << side);
            if (!this.updateCon) {
                this.updateCon = true;
                TickRegistry.instance.updates.add((TickRegistry.IUpdatable)this.tile);
            }
        }
    }

    public void updateInput() {
        World world = ((TileEntity)this.tile).func_145831_w();
        BlockPos pos = ((TileEntity)this.tile).func_174877_v();
        int newIn = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((this.rsIO >> i * 2 & 1) == 0) continue;
            EnumFacing s = EnumFacing.field_82609_l[i];
            newIn |= world.func_175651_c(pos.func_177972_a(s), s);
        }
        if ((newIn = this.convertSignal(newIn)) != this.inputState) {
            this.inputState = newIn;
            ((SharedInteger)this.network).markStateDirty();
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.con = nbt.func_74771_c("con");
        ((SharedInteger)this.network).setIO(this, nbt.func_74765_d("io"));
        this.inputState = nbt.func_74762_e("state");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("con", this.con);
        nbt.func_74777_a("io", this.rsIO);
        nbt.func_74768_a("state", this.inputState);
    }

    public int convertSignal(int s) {
        return (s & ~this.mask) == 0 ? s : (s < 0 ? 0 : this.mask);
    }

    public Capability<IntegerComp> getCap() {
        return Objects.RS_INTEGER_CAPABILITY;
    }
}

