/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.ILinkedInventory;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.BaseTileEntity;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;

public class InvConnector
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
AdvancedBlock.IInteractiveTile,
AdvancedBlock.ITilePlaceHarvest,
ILinkedInventory,
MultipartBlock.IModularTile,
ITickable {
    private boolean linkUpdate = true;
    private BlockPos linkPos = Utils.NOWHERE;
    private TileEntity linkObj;
    private EnumFacing conDir;

    public void neighborBlockChange(Block b, BlockPos src) {
        this.linkUpdate = true;
    }

    public void neighborTileChange(BlockPos src) {
        this.linkUpdate = true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.conDir = EnumFacing.func_82600_a((int)nbt.func_74771_c("dir"));
        this.linkUpdate = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("dir", (byte)this.conDir.ordinal());
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.linkUpdate) {
            return;
        }
        TileEntity last = this.linkObj;
        TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)this.conDir);
        if (te == null) {
            this.linkPos = Utils.NOWHERE;
            this.linkObj = null;
        } else if (te instanceof ILinkedInventory) {
            if (((ILinkedInventory)te).getLinkDir() == this.conDir.func_176734_d()) {
                this.linkObj = null;
                this.linkPos = Utils.NOWHERE;
            } else {
                this.linkPos = ((ILinkedInventory)te).getLinkPos();
                this.linkObj = this.field_145850_b.func_175625_s(this.linkPos);
                if (this.linkObj instanceof ILinkedInventory) {
                    this.linkObj = null;
                }
                if (this.linkObj == null) {
                    this.linkPos = Utils.NOWHERE;
                }
            }
        } else {
            this.linkObj = te;
            this.linkPos = te.func_174877_v();
        }
        if (this.linkObj != last) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), this.linkUpdate);
            this.markUpdate();
        }
        this.linkUpdate = false;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (player.func_70093_af() && item.func_190926_b()) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (this.linkObj == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Not Linked!"));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Linked to %s @ %s", this.field_145850_b.func_180495_p(this.linkPos).func_177230_c().func_149732_F(), this.linkPos.toString())));
            }
            return true;
        }
        if (item.func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                this.connect();
            }
            return true;
        }
        return false;
    }

    public void onClicked(EntityPlayer player) {
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.connect();
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        return list;
    }

    private void connect() {
        for (int i = 1; i < 6; ++i) {
            EnumFacing d = EnumFacing.field_82609_l[(this.conDir.ordinal() + i) % 6];
            if (Utils.neighborTile((TileEntity)this, (EnumFacing)d) == null) continue;
            this.conDir = d;
            this.markUpdate();
            this.linkUpdate = true;
            return;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.conDir = EnumFacing.func_82600_a((int)pkt.func_148857_g().func_74771_c("dir"));
        this.linkPos = pkt.func_148857_g().func_74767_n("link") ? new BlockPos(0, 0, 0) : new BlockPos(0, -1, 0);
        this.markUpdate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("dir", (byte)this.conDir.ordinal());
        nbt.func_74757_a("link", this.linkPos.func_177956_o() >= 0);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public BlockPos getLinkPos() {
        return this.linkPos;
    }

    public EnumFacing getLinkDir() {
        return this.conDir;
    }

    public TileEntity getLinkObj() {
        return this.linkObj;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing s) {
        return this.linkObj == null ? false : this.linkObj.hasCapability(cap, s);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing s) {
        return (T)(this.linkObj == null ? null : this.linkObj.getCapability(cap, s));
    }

    public <T> T getModuleState(int m) {
        EnumFacing d = EnumFacing.field_82609_l[m];
        return (T)Byte.valueOf(d == this.conDir ? (this.linkPos.func_177956_o() >= 0 ? (byte)2 : 1) : (this.isModulePresent(m) ? (byte)0 : -1));
    }

    public boolean isModulePresent(int m) {
        EnumFacing d = EnumFacing.field_82609_l[m];
        if (d == this.conDir) {
            return true;
        }
        TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)d);
        return te instanceof ILinkedInventory && ((ILinkedInventory)te).getLinkDir() == d.func_176734_d();
    }
}

