/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.IAbstractTile;
import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.templates.PassiveMultiblockTile;
import cd4017be.lib.util.Utils;
import java.util.List;
import multiblock.IntegerComp;
import multiblock.SharedInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class IntegerPipe
extends PassiveMultiblockTile<IntegerComp, SharedInteger>
implements AdvancedBlock.ITilePlaceHarvest,
AdvancedBlock.IRedstoneTile,
AdvancedBlock.IInteractiveTile,
MultipartBlock.IModularTile,
IQuickRedstoneHandler {
    public IntegerPipe() {
        this.comp = new IntegerComp((IAbstractTile)this, this.bitSize());
        new SharedInteger((IntegerComp)this.comp);
    }

    protected int bitSize() {
        return 32;
    }

    public void onRedstoneStateChange(EnumFacing side, int value, TileEntity src) {
        ((IntegerComp)this.comp).updateInput();
    }

    public void neighborBlockChange(Block b, BlockPos pos) {
        if (b != Blocks.field_150429_aA) {
            this.checkCons();
        }
        ((IntegerComp)this.comp).updateInput();
        super.neighborBlockChange(b, pos);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.checkCons();
    }

    protected void checkCons() {
        short io = ((IntegerComp)this.comp).rsIO;
        for (EnumFacing s : EnumFacing.field_82609_l) {
            byte d;
            ICapabilityProvider te = this.getTileOnSide(s);
            if (te == null || !(te instanceof IDirectionalRedstone) || (d = ((IDirectionalRedstone)te).getRSDirection(s.func_176734_d())) == 0) continue;
            io = (short)(io | ((d & 1) << 1 | (d & 2) >> 1) << s.ordinal() * 2);
        }
        if (io != ((IntegerComp)this.comp).rsIO) {
            ((SharedInteger)((IntegerComp)this.comp).network).setIO((IntegerComp)this.comp, io);
            this.markUpdate();
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        if (item.func_190926_b()) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            dir = Utils.hitSide((float)X, (float)Y, (float)Z);
            byte s = (byte)dir.func_176745_a();
            if (player.func_70093_af()) {
                boolean con = !((IntegerComp)this.comp).canConnect(s);
                ((IntegerComp)this.comp).setConnect(s, con);
                ICapabilityProvider te = this.getTileOnSide(dir);
                if (te != null && te instanceof IntegerPipe) {
                    IntegerPipe pipe = (IntegerPipe)te;
                    ((IntegerComp)pipe.comp).setConnect((byte)(s ^ 1), con);
                    pipe.markUpdate();
                }
            } else {
                s = (byte)(s * 2);
                ((SharedInteger)((IntegerComp)this.comp).network).setIO((IntegerComp)this.comp, (short)(((IntegerComp)this.comp).rsIO & ~(3 << s) | ((((IntegerComp)this.comp).rsIO >> s) + 1 & 3) << s));
            }
            this.markUpdate();
            return true;
        }
        return false;
    }

    public void onClicked(EntityPlayer player) {
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        return !strong && (((IntegerComp)this.comp).rsIO >> side.ordinal() * 2 & 2) != 0 ? ((IntegerComp)this.comp).convertSignal(((SharedInteger)((IntegerComp)this.comp).network).outputState) : 0;
    }

    public boolean connectRedstone(EnumFacing side) {
        return (((IntegerComp)this.comp).rsIO >> side.ordinal() * 2 & 3) != 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        ((IntegerComp)this.comp).writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        ((IntegerComp)this.comp).readFromNBT(nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        ((IntegerComp)this.comp).readFromNBT(pkt.func_148857_g());
        this.markUpdate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        ((IntegerComp)this.comp).writeToNBT(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public <T> T getModuleState(int m) {
        int c = ((IntegerComp)this.comp).rsIO >> m * 2 & 3;
        return (T)Byte.valueOf(c != 0 ? (byte)c : (this.isModulePresent(m) ? (byte)0 : (byte)-1));
    }

    public boolean isModulePresent(int m) {
        if ((((IntegerComp)this.comp).rsIO >> m * 2 & 3) != 0) {
            return true;
        }
        if (!((IntegerComp)this.comp).canConnect((byte)m)) {
            return false;
        }
        EnumFacing dir = EnumFacing.field_82609_l[m];
        ICapabilityProvider te = this.getTileOnSide(dir);
        return te != null && te.hasCapability(((IntegerComp)this.comp).getCap(), dir.func_176734_d());
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        return this.makeDefaultDrops(null);
    }
}

