/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.BaseTileEntity;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyValve
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
AdvancedBlock.IRedstoneTile,
ITickable,
IDirectionalRedstone,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver,
IEnergyStorage {
    private TileEntity out;
    public int tickInt = 1;
    public boolean measure;
    public boolean update;
    public int flow;
    public int state;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            EnumFacing dir = this.getOrientation().front;
            this.out = Utils.neighborTile((TileEntity)this, (EnumFacing)dir.func_176734_d());
        }
        if (this.field_145850_b.func_82737_E() % (long)this.tickInt != 0L) {
            return;
        }
        if (this.measure) {
            this.flow = Integer.MAX_VALUE - this.flow;
            if (this.flow != this.state) {
                this.state = this.flow;
                this.field_145850_b.func_175685_c(this.field_174879_c, Blocks.field_150429_aA, false);
            }
            this.flow = Integer.MAX_VALUE;
        } else {
            this.flow = this.state > 0 ? this.state : 0;
        }
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        if (this.field_145850_b.field_72995_K || this.measure) {
            return;
        }
        this.state = 0;
        for (EnumFacing s : EnumFacing.field_82609_l) {
            this.state |= this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(s), s);
        }
    }

    public void neighborTileChange(BlockPos src) {
        this.update = true;
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        return strong || !this.measure ? 0 : this.state;
    }

    public boolean connectRedstone(EnumFacing side) {
        return this.getRSDirection(side) != 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flow = nbt.func_74762_e("flow");
        this.state = nbt.func_74762_e("state");
        this.tickInt = nbt.func_74762_e("tickInt");
        this.measure = nbt.func_74767_n("measure");
        this.update = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("flow", this.flow);
        nbt.func_74768_a("state", this.state);
        nbt.func_74768_a("tickInt", this.tickInt);
        nbt.func_74757_a("measure", this.measure);
        return super.func_189515_b(nbt);
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        byte cmd = data.readByte();
        if (cmd == 0) {
            this.tickInt = data.readInt();
            if (this.tickInt < 1) {
                this.tickInt = 1;
            } else if (this.tickInt > 1200) {
                this.tickInt = 1200;
            }
        } else if (cmd == 1) {
            boolean bl = this.measure = !this.measure;
            if (this.measure) {
                this.flow = 0;
            } else {
                this.neighborBlockChange(null, this.field_174879_c);
            }
        }
    }

    public int[] getSyncVariables() {
        return new int[]{this.flow, this.state, this.tickInt, this.measure ? 1 : 0};
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.flow = v;
                break;
            }
            case 1: {
                this.state = v;
                break;
            }
            case 2: {
                this.tickInt = v;
                break;
            }
            case 3: {
                this.measure = v != 0;
            }
        }
    }

    public byte getRSDirection(EnumFacing s) {
        return this.measure ? (byte)2 : 1;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityEnergy.ENERGY && facing != null && facing == this.getOrientation().front;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (facing != null && facing == this.getOrientation().front && cap == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return null;
    }

    public int receiveEnergy(int am, boolean sim) {
        IEnergyStorage stor;
        if (am > this.flow) {
            am = this.flow;
        }
        if (am > 0 && this.out != null && !this.out.func_145837_r() && (stor = (IEnergyStorage)this.out.getCapability(CapabilityEnergy.ENERGY, this.getOrientation().front)) != null) {
            am = stor.receiveEnergy(am, sim);
            if (!sim) {
                this.flow -= am;
            }
            return am;
        }
        return 0;
    }

    public int extractEnergy(int am, boolean sim) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public void initContainer(DataContainer container) {
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }
}

