/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.BaseTileEntity;
import cd4017be.lib.templates.LinkedInventory;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CircuitDesigner
extends BaseTileEntity
implements DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver {
    public ItemStack dataItem = ItemStack.field_190927_a;
    private GameProfile lastPlayer;
    public final Module[] modules = new Module[70];
    public int selMod = -1;
    public int lastPos = 0;
    public long modified = 1L;
    public boolean renderAll;
    private final ByteBuf data = Unpooled.buffer();
    public String name = "";

    public CircuitDesigner() {
        this.data.writeByte(0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.dataItem = new ItemStack(nbt.func_74775_l("item"));
        this.readNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.writeNBT(nbt);
        nbt.func_74782_a("item", (NBTBase)this.dataItem.func_77955_b(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    private NBTTagCompound writeNBT(NBTTagCompound nbt) {
        byte[] b = new byte[this.data.readableBytes()];
        this.data.readBytes(b);
        this.data.resetReaderIndex();
        nbt.func_74773_a("data", b);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("mode", this.renderAll);
        return nbt;
    }

    private void readNBT(NBTTagCompound nbt) {
        this.data.clear();
        byte[] b = nbt.func_74770_j("data");
        this.data.writeBytes(b);
        this.name = nbt.func_74779_i("name");
        this.renderAll = nbt.func_74767_n("mode");
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer sender) throws IOException {
        byte cmd = dis.readByte();
        switch (cmd) {
            case 0: {
                this.data.clear();
                this.data.writeBytes((ByteBuf)dis);
                this.lastPlayer = sender.func_146103_bH();
                this.modify();
                break;
            }
            case 1: {
                if (this.dataItem.func_77973_b() != Objects.circuit_plan) break;
                this.dataItem.func_77982_d(this.writeNBT(new NBTTagCompound()));
                break;
            }
            case 2: {
                if (this.dataItem.func_77973_b() == Objects.circuit_plan && this.dataItem.func_77942_o()) {
                    this.readNBT(this.dataItem.func_77978_p());
                } else {
                    this.data.clear();
                    this.data.writeByte(0).writeByte(0);
                    this.name = "";
                }
                this.modify();
                this.lastPlayer = null;
                break;
            }
            case 3: {
                this.name = dis.func_150789_c(16);
                break;
            }
            case 6: {
                this.renderAll = false;
                break;
            }
            case 7: {
                this.renderAll = true;
            }
        }
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)new LinkedInventory(1, 1, i -> this.dataItem, (item, i) -> {
            this.dataItem = item;
        }), 0, 202, 232));
        cont.addPlayerInventory(8, 174);
        if (this.field_145850_b.field_72995_K) {
            this.modified = 0L;
        } else {
            cont.extraRef = new LastState();
            if (this.lastPlayer != null && this.lastPlayer.equals((Object)container.player.func_146103_bH())) {
                this.lastPlayer = null;
            }
        }
    }

    public boolean detectAndSendChanges(DataContainer cont, PacketBuffer dos) {
        LastState ls = (LastState)cont.extraRef;
        int chng = 0;
        int p = dos.writerIndex();
        dos.writeByte(chng);
        if (!(this.modified <= ls.edited || this.lastPlayer != null && this.lastPlayer.equals((Object)cont.player.func_146103_bH()))) {
            chng |= 1;
            dos.writeBytes(this.data, 0, this.data.writerIndex());
            ls.edited = this.modified;
        }
        if (!this.name.equals(ls.name)) {
            chng |= 2;
            dos.func_180714_a(this.name);
            ls.name = this.name;
        }
        if (this.renderAll != ls.drawAll) {
            chng |= this.renderAll ? 8 : 4;
            ls.drawAll = this.renderAll;
        }
        if (chng == 0) {
            return false;
        }
        dos.setByte(p, chng);
        return true;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
        byte chng = dis.readByte();
        if ((chng & 1) != 0) {
            this.deserialize((ByteBuf)dis);
            this.fixCons();
            this.modified = 0L;
        }
        if ((chng & 2) != 0) {
            this.name = dis.func_150789_c(16);
        }
        if ((chng & 0xC) != 0) {
            this.renderAll = (chng & 8) != 0;
        }
    }

    public ByteBuf serialize() {
        ByteBuf dos = Unpooled.buffer();
        int n = 0;
        int p = dos.writerIndex();
        dos.writeByte(n);
        int pnp = 0;
        for (Module m : this.modules) {
            if (m == null) continue;
            if (m.pos > pnp) {
                dos.writeByte(-1);
                dos.writeByte(m.pos - pnp);
                ++n;
            }
            int t = m.type.ordinal();
            if (m.type.isNum) {
                t |= m.size - 1 << 6;
            } else if (m.type.varInAm) {
                t |= m.cons() - 1 << 6;
            }
            dos.writeByte(t);
            for (Con c : m.cons) {
                if (c == null) continue;
                dos.writeByte(c.getAddr() & 0x3F | (c.type & 3) << 6);
            }
            byte[] b = m.label.getBytes();
            dos.writeByte(b.length);
            dos.writeBytes(b);
            pnp = m.pos + m.size;
            ++n;
        }
        dos.setByte(p, n);
        return dos;
    }

    public void deserialize(ByteBuf dis) {
        Arrays.fill(this.modules, null);
        int p = 0;
        for (int n = dis.readByte() & 0xFF; n > 0; --n) {
            byte t = dis.readByte();
            if (t == -1) {
                p += dis.readByte() & 0xFF;
                continue;
            }
            Module m = new Module(ModuleType.values()[t & 0x3F]);
            int sz = (t >> 6 & 3) + 1;
            if (m.type.isNum) {
                m.size = sz;
            } else if (m.type.varInAm) {
                for (int i = sz; i < m.cons.length; ++i) {
                    m.cons[i] = null;
                }
            }
            for (Con c : m.cons) {
                if (c == null) continue;
                byte b = dis.readByte();
                c.addr = b & 0x3F;
                c.type = (byte)(c.type & 4 | b >> 6 & 3);
            }
            byte[] b = new byte[dis.readByte() & 0xFF];
            dis.readBytes(b);
            m.label = new String(b);
            m.setPos(p);
            p += m.size;
        }
    }

    public void fixCons() {
        for (Module m : this.modules) {
            if (m == null) continue;
            for (Con c : m.cons) {
                if (c == null) continue;
                int addr = c.getAddr();
                c.setAddr(this.find(addr), addr);
            }
        }
    }

    public void modify() {
        ++this.modified;
    }

    public void add(ModuleType t) {
        if (t == ModuleType.OUT) {
            for (int i = 64; i < this.modules.length; ++i) {
                if (this.modules[i] != null) continue;
                Module m = new Module(t);
                this.selMod = i;
                m.setPos(this.selMod);
                ++this.modified;
                break;
            }
        } else {
            if (this.selMod < 0) {
                this.selMod = 63;
                while (this.selMod >= 0 && this.modules[this.selMod] == null) {
                    --this.selMod;
                }
            }
            ++this.selMod;
            Module m = new Module(t);
            m.setPos(this.selMod);
            ++this.modified;
        }
    }

    public void move(int cur, int pos) {
        Module m = this.modules[cur];
        if (m != null) {
            m.setPos(pos);
            ++this.modified;
        }
    }

    public Module find(int mp) {
        if (mp >= this.modules.length) {
            return null;
        }
        int l = mp - 3;
        while (mp >= l && mp >= 0) {
            Module m = this.modules[mp];
            if (m != null) {
                return m.size + mp > l + 3 ? m : null;
            }
            --mp;
        }
        return null;
    }

    public int[] getSyncVariables() {
        return null;
    }

    public void setSyncVariable(int i, int v) {
    }

    public static class LastState {
        String name;
        boolean drawAll;
        boolean output;
        long edited;
    }

    public static enum ModuleType {
        CST(0, 0, 1),
        IN(0, 0, 1),
        OR(4, 0, 6),
        NOR(4, 0, 6),
        AND(4, 0, 6),
        NAND(4, 0, 6),
        XOR(4, 0, 6),
        XNOR(4, 0, 6),
        BUF(0, 1, 1),
        NOT(1, 0, 2),
        LS(0, 2, 0),
        NLS(0, 2, 0),
        EQ(0, 2, 0),
        NEQ(0, 2, 0),
        NEG(0, 1, 1),
        ABS(0, 1, 1),
        ADD(0, 2, 1),
        SUB(0, 2, 1),
        MUL(0, 2, 1),
        DIV(0, 2, 1),
        MOD(0, 2, 1),
        MIN(0, 2, 1),
        MAX(0, 2, 1),
        SWT(1, 2, 1),
        CNT1(2, 0, 1),
        CNT2(2, 2, 1),
        RNG(0, 1, 1),
        SQRT(0, 1, 1),
        OUT(0, 1, 0);

        public final int binCon;
        public final int numCon;
        public final boolean varInAm;
        public final boolean can8bit;
        public final boolean isNum;

        private ModuleType(int bc, int nc, int type) {
            this.binCon = bc;
            this.numCon = nc;
            this.isNum = (type & 1) != 0;
            this.can8bit = (type & 2) != 0;
            this.varInAm = (type & 4) != 0;
        }

        public int cons() {
            return this.binCon + this.numCon;
        }

        public byte conType(int i) {
            return i >= this.binCon ? (byte)0 : 4;
        }

        @SideOnly(value=Side.CLIENT)
        public int conRenderPos(int i) {
            if (this == OUT) {
                return 2;
            }
            switch (this.cons()) {
                case 1: {
                    return 6;
                }
                case 2: {
                    return 3 + i * 7;
                }
                case 3: {
                    return 2 + i * 4;
                }
                case 4: {
                    return 2 + i * 3;
                }
            }
            return 0;
        }
    }

    public class Module {
        public final Con[] cons;
        public final ModuleType type;
        public int pos;
        public int size;
        public int selCon;
        public String label = "";

        public Module(ModuleType type) {
            this.type = type;
            this.size = 1;
            this.pos = -1;
            this.cons = new Con[type.cons()];
            for (int i = 0; i < this.cons.length; ++i) {
                this.cons[i] = new Con(-1, type.conType(i));
            }
            if (type == ModuleType.CST) {
                this.label = "0";
            }
        }

        public int cons() {
            if (this.type.varInAm) {
                int n = 0;
                for (Con c : this.cons) {
                    if (c == null) continue;
                    ++n;
                }
                return n;
            }
            return this.cons.length;
        }

        public void setPos(int p) {
            Module m;
            if (this.pos >= 0 && CircuitDesigner.this.modules[this.pos] == this) {
                CircuitDesigner.this.modules[this.pos] = null;
            }
            if ((m = CircuitDesigner.this.find(p)) != null && m.pos < p) {
                p = m.pos + m.size;
            }
            if (this.type == ModuleType.OUT ? p < 64 || p + this.size > CircuitDesigner.this.modules.length : p < 0 || p + this.size > 64) {
                return;
            }
            for (int i = p + this.size - 1; i >= p; --i) {
                m = CircuitDesigner.this.modules[i];
                if (m == null) continue;
                m.setPos(p + this.size);
            }
            this.pos = p;
            CircuitDesigner.this.modules[this.pos] = this;
        }

        public void resize(int s) {
            this.size = s;
            this.setPos(this.pos);
        }

        public void addCon() {
            for (int i = 0; i < this.cons.length; ++i) {
                if (this.cons[i] != null) continue;
                this.cons[i] = new Con(-1, this.type.conType(i));
                break;
            }
        }

        public void removeCon() {
            for (int i = this.cons.length - 1; i > 0; --i) {
                if (this.cons[i] == null) continue;
                this.cons[i] = null;
                break;
            }
        }
    }

    public static class Con {
        public Module mod;
        public int addr;
        public byte type;

        public Con(int ad, byte t) {
            this.addr = ad;
            this.type = t;
        }

        public int getAddr() {
            return this.mod != null ? this.mod.pos + this.addr : this.addr;
        }

        public void setAddr(Module m, int ad) {
            this.mod = m;
            this.addr = this.mod != null ? ad - this.mod.pos : ad;
        }
    }
}

