/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.ISensor;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.BaseTileEntity;
import cd4017be.lib.templates.LinkedInventory;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BlockSensor
extends BaseTileEntity
implements AdvancedBlock.ITilePlaceHarvest,
AdvancedBlock.IRedstoneTile,
ITickable,
IDirectionalRedstone,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver {
    public int tickInt = 20;
    private ItemStack sensor = ItemStack.field_190927_a;
    public float mult = 1.0f;
    public float ofs = 0.0f;
    public int output;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % (long)this.tickInt != 0L) {
            return;
        }
        int nstate = this.sensor.func_77973_b() instanceof ISensor ? (int)Math.floor(((ISensor)this.sensor.func_77973_b()).measure(this.sensor, this.field_145850_b, this.field_174879_c) * (double)this.mult + (double)this.ofs) : 0;
        if (this.output != nstate) {
            this.output = nstate;
            Utils.updateRedstoneOnSide((TileEntity)this, (int)nstate, (EnumFacing)this.getOrientation().front);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.output = nbt.func_74762_e("out");
        this.mult = nbt.func_74760_g("sca");
        this.ofs = nbt.func_74760_g("ofs");
        this.tickInt = nbt.func_74765_d("time");
        this.sensor = new ItemStack(nbt.func_74775_l("item"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("out", this.output);
        nbt.func_74776_a("sca", this.mult);
        nbt.func_74776_a("ofs", this.ofs);
        nbt.func_74777_a("time", (short)this.tickInt);
        nbt.func_74782_a("item", (NBTBase)this.sensor.func_77955_b(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        byte cmd = data.readByte();
        switch (cmd) {
            case 0: {
                this.mult = data.readFloat();
                break;
            }
            case 1: {
                this.ofs = data.readFloat();
                break;
            }
            case 2: {
                this.tickInt = data.readShort();
                if (this.tickInt < 1) {
                    this.tickInt = 1;
                    break;
                }
                if (this.tickInt <= 1200) break;
                this.tickInt = 1200;
            }
        }
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        return strong || side != this.getOrientation().front ? 0 : this.output;
    }

    public boolean connectRedstone(EnumFacing side) {
        return side == this.getOrientation().front;
    }

    public byte getRSDirection(EnumFacing s) {
        return this.connectRedstone(s) ? (byte)2 : 0;
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)new LinkedInventory(1, 1, i -> this.sensor, (item, i) -> {
            this.sensor = item;
        }), 0, 62, 16));
        cont.addPlayerInventory(8, 50);
    }

    public int[] getSyncVariables() {
        return new int[]{Float.floatToIntBits(this.mult), Float.floatToIntBits(this.ofs), this.tickInt, this.output};
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.mult = Float.intBitsToFloat(v);
                break;
            }
            case 1: {
                this.ofs = Float.intBitsToFloat(v);
                break;
            }
            case 2: {
                this.tickInt = v;
                break;
            }
            case 3: {
                this.output = v;
            }
        }
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        if (!this.sensor.func_190926_b()) {
            list.add(this.sensor);
        }
        return list;
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }
}

