/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.circuits.tileEntity.CircuitDesigner;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.SlotItemType;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.BaseTileEntity;
import cd4017be.lib.templates.BasicInventory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import net.minecraft.block.Block;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class Assembler
extends BaseTileEntity
implements ITickable,
DataContainer.IGuiData,
TileContainer.ISlotClickHandler {
    private static final Item circuit = Item.func_150898_a((Block)Objects.circuit);
    public static final String[] tagNames = new String[]{"IO", "Cap", "Gate", "Calc"};
    public static final ItemStack[] materials = new ItemStack[4];
    public int[] N = new int[9];
    public final BasicInventory inventory = new BasicInventory(8);
    NBTTagCompound code;
    private boolean recompile;

    public Assembler() {
        this.inventory.onModify = this::onSetSlot;
        this.inventory.restriction = this::insertAmount;
        this.N[8] = -1;
    }

    public void func_73660_a() {
        block15: {
            ItemStack item;
            block14: {
                int i;
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (this.recompile) {
                    this.compile();
                    this.recompile = false;
                }
                if (this.N[8] > 0) {
                    return;
                }
                item = this.inventory.items[1];
                if (item.func_190926_b()) break block14;
                boolean done = true;
                for (i = 0; i < 4; ++i) {
                    ItemStack stack;
                    int m = this.N[i + 4];
                    int n = this.N[i];
                    if (m > n) {
                        stack = this.inventory.insertItem(3 + i, materials[i].func_77946_l(), false);
                        if (stack.func_190916_E() == 0) {
                            this.N[i + 4] = --m;
                        }
                    } else if (m < n && (stack = this.inventory.extractItem(3 + i, 1, false)).func_190916_E() != 0) {
                        this.N[i + 4] = ++m;
                    }
                    done &= m == n;
                }
                if (!done) break block15;
                item.func_77982_d(this.code);
                this.inventory.items[1] = this.inventory.insertItem(2, item, false);
                for (i = 4; i < 8; ++i) {
                    this.N[i] = 0;
                }
                break block15;
            }
            if (this.inventory.items[0].func_77973_b() == circuit) {
                this.inventory.items[1] = item = this.inventory.extractItem(0, 1, false);
                NBTTagCompound nbt = item.func_77978_p();
                if (nbt == null) {
                    for (int i = 4; i < 8; ++i) {
                        this.N[i] = 0;
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.N[i + 4] = nbt.func_74771_c(tagNames[i]);
                    }
                }
            }
        }
    }

    public void compile() {
        ItemStack item = this.inventory.items[7];
        if (item.func_77973_b() != Objects.circuit_plan || !item.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                this.N[i] = 0;
            }
            this.N[8] = -1;
            this.code = null;
            return;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int size = 0;
        int logic = 0;
        int calc = 0;
        int io = 0;
        int maxAddr = 0;
        NBTTagList list = new NBTTagList();
        ByteBuf out = Unpooled.buffer();
        ByteBuffer data = ByteBuffer.wrap(nbt.func_74770_j("data"));
        ByteBuffer cst = ByteBuffer.allocate(64);
        try {
            int p = 0;
            int skip = 0;
            for (int n = data.get() & 0xFF; n > 0; --n) {
                int sz;
                NBTTagCompound tag;
                byte t = data.get();
                if (t == -1) {
                    int l = data.get() & 0xFF;
                    p += l;
                    skip += l;
                    continue;
                }
                CircuitDesigner.ModuleType mt = CircuitDesigner.ModuleType.values()[t & 0x3F];
                if (mt == CircuitDesigner.ModuleType.OUT) {
                    tag = new NBTTagCompound();
                    tag.func_74757_a("d", true);
                    byte addr = data.get();
                    if (this.addrSize(addr, mt, 0) >= size) {
                        this.N[8] = 1;
                        return;
                    }
                    tag.func_74774_a("p", addr);
                    byte[] str = new byte[data.get()];
                    data.get(str);
                    tag.func_74778_a("n", new String(str));
                    list.func_74742_a((NBTBase)tag);
                    io += (addr >> 6 & 3) * 4 + 8;
                    p = 64;
                    skip = 0;
                    continue;
                }
                if (p >= 64) {
                    this.N[8] = 3;
                    return;
                }
                if (mt == CircuitDesigner.ModuleType.CST) {
                    skip += sz;
                    byte[] str = new byte[data.get()];
                    data.get(str);
                    int c = Integer.parseInt(new String(str));
                    for (sz = (t >> 6 & 3) + 1; sz > 0; --sz) {
                        cst.put(p++, (byte)c);
                        c >>= 8;
                    }
                } else {
                    while (skip > 0) {
                        int l = Math.min(skip, 4);
                        out.writeByte((int)((byte)(l - 1 << 6)));
                        skip -= l;
                    }
                    out.writeByte((int)t);
                    if (mt == CircuitDesigner.ModuleType.IN) {
                        tag = new NBTTagCompound();
                        tag.func_74757_a("d", false);
                        tag.func_74774_a("p", (byte)(p & 0x3F | t & 0xC0));
                        io += sz * 4 + 4;
                        byte[] str = new byte[data.get()];
                        data.get(str);
                        tag.func_74778_a("n", new String(str));
                        list.func_74742_a((NBTBase)tag);
                        p += sz;
                    } else {
                        byte[] buf = new byte[mt.varInAm ? sz : mt.cons()];
                        data.get(buf);
                        out.writeBytes(buf);
                        for (int i = 0; i < buf.length; ++i) {
                            maxAddr = Math.max(maxAddr, this.addrSize(buf[i], mt, i));
                        }
                        logic += Assembler.logicCost(mt, sz);
                        calc += Assembler.calcCost(mt, sz);
                        data.position(data.get() + data.position());
                        p += mt.isNum ? sz : 1;
                    }
                }
                size = p;
            }
            if (data.position() != data.limit()) {
                throw new IllegalStateException(String.format("Only read %d of %d bytes!", data.position(), data.limit()));
            }
        }
        catch (Exception e) {
            String s = " ";
            for (byte b : data.array()) {
                s = s + Integer.toHexString(b & 0xFF) + " ";
            }
            FMLLog.log((String)"Circuit Assembler", (Level)Level.ERROR, (Throwable)e, (String)"crashed while compiling schematic data: [%s]", (Object[])new Object[]{s});
            this.N[8] = 4;
            return;
        }
        if (maxAddr >= size) {
            this.N[8] = 1;
            return;
        }
        if (list.func_74745_c() > 6) {
            this.N[8] = 2;
            return;
        }
        this.N[8] = 0;
        String name = nbt.func_74779_i("name");
        this.code = nbt = new NBTTagCompound();
        this.N[0] = io;
        nbt.func_74774_a(tagNames[0], (byte)this.N[0]);
        this.N[1] = size;
        nbt.func_74774_a(tagNames[1], (byte)this.N[1]);
        this.N[2] = logic;
        nbt.func_74774_a(tagNames[2], (byte)this.N[2]);
        this.N[3] = calc;
        nbt.func_74774_a(tagNames[3], (byte)this.N[3]);
        byte[] b = new byte[size + out.writerIndex()];
        cst.get(b, 0, size);
        out.readBytes(b, size, out.writerIndex());
        nbt.func_74773_a("data", b);
        nbt.func_74782_a("io", (NBTBase)list);
        nbt.func_74778_a("name", name);
    }

    private int addrSize(byte val, CircuitDesigner.ModuleType mt, int i) {
        return (val & 0x3F) + (mt.conType(i) < 4 ? val >> 6 & 3 : 0);
    }

    public static int logicCost(CircuitDesigner.ModuleType t, int sz) {
        switch (t) {
            case OR: 
            case NOR: 
            case AND: 
            case NAND: 
            case XOR: 
            case XNOR: {
                return (sz + 1) / 2;
            }
            case NOT: {
                return 1;
            }
            case LS: 
            case NLS: 
            case EQ: 
            case NEQ: {
                return 2;
            }
            case SWT: 
            case MIN: 
            case MAX: {
                return (sz + 1) / 2 + 1;
            }
            case CNT1: {
                return 1;
            }
            case CNT2: {
                return 2;
            }
        }
        return 0;
    }

    public static int calcCost(CircuitDesigner.ModuleType t, int sz) {
        switch (t) {
            case MIN: 
            case MAX: 
            case CNT1: 
            case NEG: 
            case ABS: {
                return (sz + 1) / 2;
            }
            case ADD: 
            case SUB: {
                return sz;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 1 + sz;
            }
            case CNT2: {
                return sz;
            }
            case RNG: {
                return sz + 2;
            }
            case SQRT: {
                return 2 * sz + 6;
            }
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.read(nbt.func_150295_c("items", 10));
        this.recompile = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.write());
        return super.func_189515_b(nbt);
    }

    public void initContainer(DataContainer container) {
        TileContainer c = (TileContainer)container;
        c.clickHandler = this;
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 0, 152, 16, new ItemStack[]{new ItemStack(circuit, 64), new ItemStack(circuit, 64, 1), new ItemStack(circuit, 64, 2)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 2, 152, 52, new ItemStack[0]));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 3, 26, 16, new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)materials[0], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 4, 8, 16, new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)materials[1], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 5, 8, 52, new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)materials[2], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 6, 26, 52, new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)materials[3], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 7, 116, 34, new ItemStack[]{new ItemStack((Item)Objects.circuit_plan, 1)}));
        c.addPlayerInventory(8, 86);
    }

    public int[] getSyncVariables() {
        return this.N;
    }

    public boolean transferStack(ItemStack item, int s, TileContainer container) {
        if (s < 7) {
            return false;
        }
        container.func_75135_a(item, 2, 6, false);
        if (item.func_190916_E() > 0) {
            container.func_75135_a(item, 0, 1, false);
        }
        if (item.func_190916_E() > 0) {
            container.func_75135_a(item, 6, 7, false);
        }
        return true;
    }

    public int insertAmount(int s, ItemStack insert) {
        if (s >= 3 && s < 7 && !insert.func_77969_a(materials[s - 3]) || s == 7 && insert.func_77973_b() != Objects.circuit_plan || s == 0 && insert.func_77973_b() != circuit) {
            return 0;
        }
        return Math.min(64, insert.func_77976_d());
    }

    public void onSetSlot(ItemStack item, int s) {
        this.recompile |= s == 7;
    }

    public boolean slotClick(ItemStack item, Slot slot, int b, ClickType c, TileContainer cont) {
        return false;
    }

    public void setSyncVariable(int i, int v) {
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }
}

