/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.item;

import cd4017be.api.circuits.ISensor;
import cd4017be.circuits.gui.GuiTimeSensor;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.DefaultItem;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.IGuiItem;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTimeSensor
extends DefaultItem
implements ISensor,
IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver {
    public double RangeSQ = 400.0;

    public ItemTimeSensor(String id) {
        super(id);
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> list, boolean b) {
        if (item.func_77942_o()) {
            list.add(TooltipUtil.formatLink((BlockPos)BlockPos.func_177969_a((long)item.func_77978_p().func_74763_f("link")), (EnumFacing)EnumFacing.func_82600_a((int)item.func_77978_p().func_74771_c("side"))));
        }
        super.func_77624_a(item, player, list, b);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74772_a("link", pos.func_177986_g());
        nbt.func_74774_a("side", (byte)side.ordinal());
        return EnumActionResult.SUCCESS;
    }

    public double measure(ItemStack sensor, World world, BlockPos det) {
        if (!sensor.func_77942_o()) {
            return 0.0;
        }
        NBTTagCompound nbt = sensor.func_77978_p();
        BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("link"));
        EnumFacing side = EnumFacing.func_82600_a((int)nbt.func_74771_c("side"));
        long ref = nbt.func_74763_f("ref");
        long interv = nbt.func_74763_f("int");
        byte src = nbt.func_74771_c("src");
        byte mode = nbt.func_74771_c("mode");
        long time = this.getTime(src, world);
        if (mode == 1 && time >= ref + interv) {
            nbt.func_74772_a("ref", ref += interv);
        } else if (mode > 1 && pos.func_177951_i((Vec3i)det) < this.RangeSQ && world.func_175651_c(pos, side.func_176734_d()) > 0) {
            if (mode == 2) {
                ref = time;
                nbt.func_74772_a("ref", ref);
            } else {
                nbt.func_74772_a("ref", ref += interv);
                nbt.func_74772_a("int", time - ref);
            }
        }
        return (double)(mode == 3 ? interv : time - ref) / 1000.0;
    }

    private long getTime(byte src, World world) {
        return src == 0 ? world.func_82737_E() * 50L : (src == 1 ? world.func_72820_D() * 50L : System.currentTimeMillis());
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiTimeSensor(new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player));
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender, ItemStack item, int slot) throws IOException {
        byte cmd;
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if ((cmd = data.readByte()) == 0) {
            byte src = data.readByte();
            item.func_77978_p().func_74774_a("src", src);
            item.func_77978_p().func_74772_a("ref", this.getTime(src, sender.field_70170_p));
        } else if (cmd == 1) {
            item.func_77978_p().func_74774_a("mode", data.readByte());
        } else if (cmd == 2) {
            item.func_77978_p().func_74772_a("ref", data.readLong());
        } else if (cmd == 3) {
            item.func_77978_p().func_74772_a("int", data.readLong());
        }
    }
}

