/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GuiMachine;
import java.util.Calendar;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class GuiTimeSensor
extends GuiMachine {
    private final InventoryPlayer inv;

    public GuiTimeSensor(DataContainer cont) {
        super((Container)cont);
        this.MAIN_TEX = new ResourceLocation("circuits", "textures/gui/fluid_sensor.png");
        this.bgTexY = 150;
        this.inv = cont.player.field_71071_by;
    }

    public void func_73866_w_() {
        this.field_146999_f = 112;
        this.field_147000_g = 76;
        super.func_73866_w_();
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 0, 7, 15, 18, 18, 0).texture(112, 150).setTooltip("timeSensor.mode#"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 1, 25, 15, 80, 18, -1).setTooltip("timeSensor.srcT#"));
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 2, 8, 43, 96, 7, 20).color(-16760704, -49088));
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 3, 8, 61, 96, 7, 20).color(-16760704, -49088));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        NBTTagCompound nbt = this.getTag();
        this.drawLocString(this.field_147003_i + 26, this.field_147009_r + 16, 8, -16777088, "timeSensor.src" + nbt.func_74771_c("src"), new Object[0]);
        this.drawLocString(this.field_147003_i + 8, this.field_147009_r + 34, 8, -12566464, "timeSensor.ref", new Object[0]);
        this.drawLocString(this.field_147003_i + 8, this.field_147009_r + 52, 8, -12566464, "timeSensor.int", new Object[0]);
    }

    private NBTTagCompound getTag() {
        NBTTagCompound nbt = ((ItemStack)this.inv.field_70462_a.get(this.inv.field_70461_c)).func_77978_p();
        return nbt != null ? nbt : new NBTTagCompound();
    }

    protected Object getDisplVar(int id) {
        NBTTagCompound nbt = this.getTag();
        switch (id) {
            case 0: {
                return (int)nbt.func_74771_c("mode");
            }
            case 1: {
                return (int)nbt.func_74771_c("src");
            }
            case 2: {
                return this.formatTime(nbt.func_74763_f("ref"), nbt.func_74771_c("src"));
            }
            case 3: {
                return this.formatTime(nbt.func_74763_f("int"), (byte)0);
            }
        }
        return null;
    }

    private String formatTime(long t, byte src) {
        if (src == 0) {
            String s = String.format("%02d", (int)(t % 60000L) / 1000);
            if (t % 1000L >= 10L) {
                s = s + String.format(".%02d", t % 1000L / 10L);
            }
            if (t >= 60000L) {
                s = String.format("%02d:", (int)(t % 3600000L) / 60000) + s;
            }
            if (t >= 3600000L) {
                s = String.format("%02d:", (int)(t % 86400000L) / 3600000) + s;
            }
            if (t >= 86400000L) {
                s = String.format("%dd ", (int)(t / 86400000L)) + s;
            }
            return s;
        }
        if (src == 1) {
            return String.format("day %d %d:%02d.%02d", (int)(t / 1200000L), (int)(t %= 1200000L) / 60000, (int)(t %= 60000L) / 1000, (int)(t % 1000L) / 10);
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        return String.format("%d.%02d.%d %d:%02d:%02d", c.get(5), c.get(2) + 1, c.get(1), c.get(11), c.get(12), c.get(13));
    }

    private long parseTime(String s, byte src) {
        s = s.trim();
        if (src == 0 || src == 1) {
            long t = 0L;
            if (s.startsWith("day")) {
                int p = s.indexOf(32, 4);
                if (p < 0) {
                    p = s.length();
                }
                t = (long)Integer.parseInt(s.substring(3, p).trim()) * 1200000L;
                s = s.substring(p).trim();
            } else {
                int p = s.indexOf(100);
                if (p >= 0) {
                    t += (long)Integer.parseInt(s.substring(0, p)) * 86400000L;
                    s = s.substring(p + 1).trim();
                }
            }
            String[] s1 = s.split(":");
            t += (long)(Float.parseFloat(s1[s1.length - 1]) * 1000.0f);
            if (s1.length >= 2) {
                t += (long)(Integer.parseInt(s1[s1.length - 2]) * 60000);
            }
            if (s1.length >= 3) {
                t += (long)(Integer.parseInt(s1[s1.length - 3]) * 3600000);
            }
            return t;
        }
        String[] s1 = s.split("[\\. :]");
        Calendar c = Calendar.getInstance();
        c.set(Integer.parseInt(s1[2]), Integer.parseInt(s1[1]) - 1, Integer.parseInt(s1[0]), Integer.parseInt(s1[3]), Integer.parseInt(s1[4]), Integer.parseInt(s1[5]));
        return c.getTimeInMillis();
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        NBTTagCompound nbt = this.getTag();
        PacketBuffer dos = BlockGuiHandler.getPacketForItem((int)this.inv.field_70461_c);
        switch (id) {
            case 0: {
                dos.writeByte(1).writeByte((nbt.func_74771_c("mode") + ((Integer)obj == 0 ? 1 : 3)) % 4);
                break;
            }
            case 1: {
                dos.writeByte(0).writeByte((nbt.func_74771_c("src") + ((Integer)obj == 0 ? 1 : 2)) % 3);
                break;
            }
            case 2: {
                try {
                    dos.writeByte(2).writeLong(this.parseTime((String)obj, nbt.func_74771_c("src")));
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
            case 3: {
                try {
                    dos.writeByte(3).writeLong(this.parseTime((String)obj, (byte)0));
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        if (send) {
            BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
        }
    }
}

