/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TooltipUtil {
    public static String CURRENT_DOMAIN = "";
    private static String ShiftHint;
    private static String AltHint;
    private static String FluidDispUnit;
    private static String EnergyDispUnit;
    private static String PowerDispUnit;
    private static String LinkPosFormat;
    private static String LinkPosFormat1;
    public static String[] sides;
    private static final HashMap<String, String> variables;
    private static final Pattern varInsertion;
    private static final Pattern variantReplacement;
    private static final Pattern numberFormat;
    private static String lastKey;
    private static String lastValue;
    private static final String[] DecScale;
    private static final int ofsDecScale = 6;

    public static String unlocalizedNameFor(IForgeRegistryEntry.Impl<?> obj) {
        ResourceLocation loc = obj.getRegistryName();
        return (loc.func_110624_b().equals(CURRENT_DOMAIN) ? CURRENT_DOMAIN : "cd4017be") + '.' + loc.func_110623_a();
    }

    public static String getShiftHint() {
        if (ShiftHint == null && (ShiftHint = I18n.func_74838_a((String)"cd4017be.shiftHint")) == "cd4017be.shiftHint") {
            ShiftHint = "<SHIFT for info>";
        }
        return ShiftHint;
    }

    public static String getAltHint() {
        if (AltHint == null && (AltHint = I18n.func_74838_a((String)"cd4017be.altHint")) == "cd4017be.altHint") {
            AltHint = "<ALT for extra>";
        }
        return AltHint;
    }

    public static String getFluidUnit() {
        if (FluidDispUnit == null && (FluidDispUnit = I18n.func_74838_a((String)"cd4017be.fluidUnit")) == "cd4017be.fluidUnit") {
            FluidDispUnit = "B";
        }
        return FluidDispUnit;
    }

    public static String getEnergyUnit() {
        if (EnergyDispUnit == null && (EnergyDispUnit = I18n.func_74838_a((String)"cd4017be.energyUnit")) == "cd4017be.energyUnit") {
            EnergyDispUnit = "kJ";
        }
        return EnergyDispUnit;
    }

    public static String getPowerUnit() {
        if (PowerDispUnit == null && (PowerDispUnit = I18n.func_74838_a((String)"cd4017be.powerUnit")) == "cd4017be.powerUnit") {
            PowerDispUnit = "kW";
        }
        return PowerDispUnit;
    }

    public static String formatLink(BlockPos pos, EnumFacing side) {
        if (LinkPosFormat == null && (LinkPosFormat = I18n.func_74838_a((String)"cd4017be.linkPos")) == "cd4017be.linkPos") {
            LinkPosFormat = "Link: x=%d y=%d z=%d %s";
        }
        return String.format(LinkPosFormat, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side != null ? sides[side.ordinal()] : "");
    }

    public static String formatLink(BlockPos pos, EnumFacing side, int dim) {
        if (LinkPosFormat1 == null && (LinkPosFormat1 = I18n.func_74838_a((String)"cd4017be.linkPos1")) == "cd4017be.linkPos1") {
            LinkPosFormat1 = "Link: x=%d y=%d z=%d %s @dim %d";
        }
        return String.format(LinkPosFormat1, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side != null ? sides[side.ordinal()] : "", dim);
    }

    public static void addConfigReference(ConfigurationFile cfg) {
        block15: for (Map.Entry<String, Object> var : cfg.variables.entrySet()) {
            String text;
            String id = var.getKey();
            Object val = var.getValue();
            switch (id.charAt(0)) {
                case 'A': {
                    switch (id.charAt(1)) {
                        case 'B': {
                            int i;
                            Object[] arr = (boolean[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, "" + arr[i]);
                            }
                            continue block15;
                        }
                        case 'W': {
                            int i;
                            Object[] arr = (byte[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, "" + arr[i]);
                            }
                            continue block15;
                        }
                        case 'S': {
                            int i;
                            Object[] arr = (short[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, "" + arr[i]);
                            }
                            continue block15;
                        }
                        case 'I': {
                            int i;
                            Object[] arr = (int[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, "" + arr[i]);
                            }
                            continue block15;
                        }
                        case 'L': {
                            int i;
                            Object[] arr = (long[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, "" + arr[i]);
                            }
                            continue block15;
                        }
                        case 'F': {
                            int i;
                            Object[] arr = (float[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, TooltipUtil.formatNumber((double)arr[i], 3, 0));
                            }
                            continue block15;
                        }
                        case 'D': {
                            int i;
                            Object[] arr = (double[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, TooltipUtil.formatNumber((double)arr[i], 3, 0));
                            }
                            continue block15;
                        }
                        case 'T': {
                            int i;
                            Object[] arr = (String[])val;
                            for (i = 0; i < arr.length; ++i) {
                                variables.put(id + ":" + i, (String)arr[i]);
                            }
                            break;
                        }
                    }
                    continue block15;
                }
                case 'F': {
                    text = TooltipUtil.formatNumber(((Float)val).floatValue(), 3, 0);
                    break;
                }
                case 'D': {
                    text = TooltipUtil.formatNumber((Double)val, 3, 0);
                    break;
                }
                default: {
                    text = val.toString();
                }
            }
            variables.put(id, text);
        }
    }

    public static void addScriptVariables() {
        RecipeScriptContext cont = RecipeScriptContext.instance;
        for (ScriptFiles.Version v : RecipeScriptContext.scriptRegistry) {
            Script m = (Script)cont.modules.get(v.name);
            if (m == null) continue;
            for (Map.Entry<String, Object> var : m.variables.entrySet()) {
                TooltipUtil.addVar(var.getKey(), var.getValue());
            }
        }
    }

    private static void addVar(String name, Object o) {
        if (o instanceof Double) {
            variables.put(name, TooltipUtil.formatNumber((Double)o, 4, 0));
        } else if (o instanceof double[]) {
            double[] arr = (double[])o;
            for (int i = 0; i < arr.length; ++i) {
                variables.put(name + ":" + i, TooltipUtil.formatNumber(arr[i], 4, 0));
            }
        } else if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            for (int i = 0; i < arr.length; ++i) {
                TooltipUtil.addVar(name + ":" + i, arr[i]);
            }
        } else if (o instanceof ItemStack) {
            ItemStack item = (ItemStack)o;
            variables.put(name, (item.func_190916_E() > 1 ? item.func_190916_E() + "x " : "") + item.func_82833_r());
        } else if (o != null) {
            variables.put(name, o.toString());
        }
    }

    public static String getConfigFormat(String s) {
        Matcher m;
        if (s.equals(lastKey)) {
            return lastValue;
        }
        lastKey = s;
        String t = I18n.func_74838_a((String)s);
        if (t.equals(s)) {
            m = variantReplacement.matcher(s);
            if (!m.find()) {
                lastValue = s;
                return lastValue;
            }
            String n = m.group(1);
            t = I18n.func_74838_a((String)(s = s.substring(0, m.start(1)) + "i" + s.substring(m.end(1))));
            if (t.equals(s)) {
                lastValue = s;
                return lastValue;
            }
            t = t.replace("\\i", n);
        }
        s = t.trim().replace("\\n", "\n");
        m = varInsertion.matcher(s);
        String s1 = "";
        while (m.find()) {
            String var = variables.get(m.group(1));
            if (var == null) continue;
            s1 = s1 + s.substring(0, m.start()) + var;
            s = s.substring(m.end());
            m.reset(s);
        }
        lastValue = s1 + s;
        return lastValue;
    }

    public static String format(String s, Object ... args) {
        s = I18n.func_74838_a((String)s).trim().replace("\\n", "\n");
        try {
            Matcher m = numberFormat.matcher(s);
            String s1 = "";
            while (m.find()) {
                double val = 0.0;
                int exp = 0;
                int n = 3;
                String g = m.group(1);
                if (g != null) {
                    val = (Double)args[Integer.parseInt(g)];
                } else {
                    for (Object o : args) {
                        if (!(o instanceof Double)) continue;
                        val = (Double)o;
                        break;
                    }
                }
                g = m.group(2);
                if (g != null && !g.isEmpty()) {
                    exp = Integer.parseInt(g);
                }
                if ((g = m.group(3)) != null) {
                    n = Integer.parseInt(g);
                }
                s1 = s1 + s.substring(0, m.start()) + TooltipUtil.formatNumber(val, n, exp);
                s = s.substring(m.end());
                m.reset(s);
            }
            return String.format(s1 + s, args);
        }
        catch (IllegalFormatException e) {
            return s + "\n" + e.toString();
        }
    }

    public static String translate(String s) {
        return I18n.func_74838_a((String)s);
    }

    public static boolean hasTranslation(String s) {
        return I18n.func_94522_b((String)s);
    }

    public static String formatNumber(double x, int w, int c) {
        String ds;
        double s = Math.signum(x);
        if (x == 0.0 || Double.isNaN(x) || Double.isInfinite(x)) {
            return "" + x;
        }
        int o = (int)Math.floor(Math.log10(x * s)) + 18;
        int p = (o + c) / 3;
        int n = w - o + p * 3 - 1;
        if (p < 0) {
            return "0";
        }
        if (p > DecScale.length) {
            return "" + (s == -1.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        String tex = String.format("%." + n + "f", x *= Math.pow(0.001, p - 6));
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex + DecScale[p];
    }

    public static String formatNumber(double x, int w) {
        String ds;
        String tex = String.format("%." + w + "f", x);
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    static {
        sides = new String[]{"B", "T", "N", "S", "W", "E"};
        variables = new HashMap();
        varInsertion = Pattern.compile("\\\\<([\\w:]+)>");
        variantReplacement = Pattern.compile("\\:(\\d+)");
        numberFormat = Pattern.compile("%(?:(\\d+)\\$)?(?:(-?\\d?)\\.(\\d+))?u");
        DecScale = new String[]{"a", "f", "p", "n", "u", "m", "", "k", "M", "G", "T", "P", "E"};
    }
}

