/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.api.IAbstractTile;
import cd4017be.lib.templates.ITankContainer;
import cd4017be.lib.templates.Inventory;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

@Deprecated
public class TankContainer
implements ITankContainer {
    public long sideCfg = 0L;
    public final FluidStack[] fluids;
    public final Tank[] tanks;

    public TankContainer(int l, int t) {
        if (t > 4 || t > l) {
            throw new IllegalArgumentException("Too many tanks! " + t + " / " + (l < 4 ? l : 4));
        }
        this.fluids = new FluidStack[l];
        this.tanks = new Tank[t];
    }

    public TankContainer tank(int i, int cap, byte dir, int in, int out, Fluid ... types) {
        this.tanks[i] = new Tank(i, cap, dir, in, out, types);
        if (types.length == 1) {
            this.fluids[i] = new FluidStack(this.tanks[i].types[0], 0);
            this.sideCfg |= 1L << i + 48;
        }
        return this;
    }

    public void update(IAbstractTile tile, Inventory inv) {
        FluidStack fluid;
        for (EnumFacing s : EnumFacing.field_82609_l) {
            ICapabilityProvider te;
            byte cfg = (byte)(this.sideCfg >> s.ordinal() * 8);
            if (cfg == 0 || (te = tile.getTileOnSide(s)) == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, s.func_176734_d())) continue;
            IFluidHandler access = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, s.func_176734_d());
            for (Tank t : this.tanks) {
                int c = cfg & 3;
                cfg = (byte)(cfg >> 2);
                if (c == 1 && t.dir == -1) {
                    Fluid f;
                    fluid = this.fluids[t.idx];
                    if (fluid != null) {
                        if ((fluid = access.drain(new FluidStack(fluid, t.cap - fluid.amount), true)) == null) continue;
                        this.fluids[t.idx].amount += fluid.amount;
                        continue;
                    }
                    if (t.types == null) {
                        this.fluids[t.idx] = access.drain(t.cap, true);
                        continue;
                    }
                    Fluid[] fluidArray = t.types;
                    int n = fluidArray.length;
                    for (int i = 0; i < n && (this.fluids[t.idx] = access.drain(new FluidStack(f = fluidArray[i], t.cap), true)) == null; ++i) {
                    }
                    continue;
                }
                if (c != 2 || t.dir != 1 || (fluid = this.fluids[t.idx]) == null || fluid.amount <= 0 || (fluid.amount -= access.fill(fluid.copy(), true)) > 0 || (this.sideCfg >> t.idx + 48 & 1L) != 0L) continue;
                this.fluids[t.idx] = null;
            }
        }
        if (inv != null) {
            for (Tank t : this.tanks) {
                ItemFluidUtil.StackedFluidAccess acc;
                if (t.inSlot >= 0 && ((fluid = this.fluids[t.idx]) == null || fluid.amount < t.cap) && (acc = new ItemFluidUtil.StackedFluidAccess(inv.items[t.inSlot])).valid()) {
                    if (fluid != null) {
                        if ((fluid = acc.drain(new FluidStack(fluid, t.cap - fluid.amount), true)) != null) {
                            this.fluids[t.idx].amount += fluid.amount;
                        }
                    } else if (t.types == null) {
                        this.fluids[t.idx] = acc.drain(t.cap, true);
                    } else {
                        Tank f;
                        Tank[] tankArray = t.types;
                        int n = tankArray.length;
                        for (int i = 0; i < n && (this.fluids[t.idx] = acc.drain(new FluidStack((Fluid)(f = tankArray[i]), t.cap), true)) == null; ++i) {
                        }
                    }
                    inv.items[t.inSlot] = acc.result();
                }
                if (t.outSlot < 0 || (fluid = this.fluids[t.idx]) == null || fluid.amount <= 0 || !(acc = new ItemFluidUtil.StackedFluidAccess(inv.items[t.outSlot])).valid()) continue;
                if ((fluid.amount -= acc.fill(fluid.copy(), true)) <= 0 && (this.sideCfg >> t.idx + 48 & 1L) == 0L) {
                    this.fluids[t.idx] = null;
                }
                inv.items[t.outSlot] = acc.result();
            }
        }
    }

    @Override
    public FluidStack getTank(int i) {
        return this.fluids[i];
    }

    @Override
    public int getCapacity(int i) {
        return this.tanks[i].cap;
    }

    @Override
    public void setTank(int i, FluidStack fluid) {
        this.fluids[i] = fluid;
    }

    @Override
    public int getTanks() {
        return this.tanks.length;
    }

    public void setFluid(int t, FluidStack fluid) {
        if (fluid != null && fluid.amount == 0) {
            fluid = null;
        }
        if (fluid == null && this.fluids[t] != null && (this.sideCfg >> t + 48 & 1L) != 0L) {
            this.fluids[t].amount = 0;
        } else {
            this.fluids[t] = fluid;
        }
    }

    public int getAmount(int t) {
        return this.fluids[t] == null ? 0 : this.fluids[t].amount;
    }

    public int getSpace(int t) {
        return this.fluids[t] == null ? this.tanks[t].cap : this.tanks[t].cap - this.fluids[t].amount;
    }

    public int fill(int t, FluidStack fluid, boolean doFill) {
        FluidStack stack = this.fluids[t];
        if (!(stack == null ? this.tanks[t].acceptsType(fluid.getFluid()) : stack.isFluidEqual(fluid))) {
            return 0;
        }
        int rem = this.tanks[t].cap - (stack == null ? 0 : stack.amount);
        if (rem > fluid.amount) {
            rem = fluid.amount;
        }
        if (doFill && rem > 0) {
            if (stack != null) {
                stack.amount += rem;
            } else {
                this.fluids[t] = new FluidStack(fluid, rem);
            }
        }
        return rem;
    }

    public FluidStack drain(int t, int amount, boolean doDrain) {
        FluidStack stack = this.fluids[t];
        if (stack == null || stack.amount <= 0) {
            return null;
        }
        int rem = Math.min(amount, stack.amount);
        if (doDrain && (stack.amount -= rem) <= 0 && (this.sideCfg >> t + 48 & 1L) == 0L) {
            this.fluids[t] = null;
        }
        return new FluidStack(stack, rem);
    }

    public byte getConfig(int s, int t) {
        if (s >= 0) {
            return (byte)(this.sideCfg >> 8 * s + 2 * t & 3L);
        }
        if (t < 0 || t >= this.tanks.length) {
            return 0;
        }
        byte dir = this.tanks[t].dir;
        return (byte)(dir < 0 ? 1 : (dir > 0 ? 2 : 3));
    }

    public boolean canUnlock(int t) {
        return this.tanks[t].types == null || this.tanks[t].types.length != 1;
    }

    public boolean isLocked(int t) {
        return (this.sideCfg >> 48 + t & 1L) != 0L;
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.sideCfg = nbt.func_74763_f(name + "Cfg");
        for (int f = 0; f < this.fluids.length; ++f) {
            String tagName = name + Integer.toHexString(f);
            this.fluids[f] = nbt.func_150297_b(tagName, 10) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(tagName)) : null;
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74772_a(name + "Cfg", this.sideCfg);
        for (int f = 0; f < this.fluids.length; ++f) {
            if (this.fluids[f] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.fluids[f].writeToNBT(tag);
            nbt.func_74782_a(name + Integer.toHexString(f), (NBTBase)tag);
        }
    }

    public class Access
    implements IFluidHandler {
        final TankAccess[] accs;

        public Access(EnumFacing s) {
            int ml = TankContainer.this.tanks.length;
            if (s == null) {
                this.accs = new TankAccess[ml];
                for (int i = 0; i < ml; ++i) {
                    this.accs[i] = new TankAccess(i, 3);
                }
            } else {
                int c = (int)(TankContainer.this.sideCfg >> s.ordinal() * 8);
                int n = Integer.bitCount((c | c >> 1) & 0x55);
                this.accs = new TankAccess[n];
                int i = 0;
                int j = 0;
                while (j < n) {
                    int k = c >> i * 2 & 3;
                    if (k != 0) {
                        this.accs[j++] = new TankAccess(i, k);
                    }
                    ++i;
                }
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.accs;
        }

        public int fill(FluidStack fluid, boolean doFill) {
            int am = fluid.amount;
            for (TankAccess acc : this.accs) {
                FluidStack stack;
                if ((acc.dir & 1) == 0 || !((stack = TankContainer.this.fluids[acc.idx]) != null ? stack.isFluidEqual(fluid) : TankContainer.this.tanks[acc.idx].acceptsType(fluid.getFluid()))) continue;
                int rem = TankContainer.this.tanks[acc.idx].cap - (stack == null ? 0 : stack.amount);
                if (rem > am) {
                    rem = am;
                    am = 0;
                } else {
                    am -= rem;
                }
                if (doFill && rem > 0) {
                    if (stack != null) {
                        stack.amount += rem;
                    } else {
                        TankContainer.this.fluids[acc.idx] = new FluidStack(fluid, rem);
                    }
                }
                if (am > 0) continue;
                return fluid.amount;
            }
            return fluid.amount - am;
        }

        public FluidStack drain(FluidStack fluid, boolean doDrain) {
            int am = fluid.amount;
            for (TankAccess acc : this.accs) {
                FluidStack stack;
                if ((acc.dir & 2) == 0 || (stack = TankContainer.this.fluids[acc.idx]) == null || stack.amount <= 0 || !stack.isFluidEqual(fluid)) continue;
                stack = TankContainer.this.fluids[acc.idx];
                int rem = Math.min(am, stack.amount);
                am -= rem;
                if (doDrain && (stack.amount -= rem) <= 0 && (TankContainer.this.sideCfg >> acc.idx + 48 & 1L) == 0L) {
                    TankContainer.this.fluids[acc.idx] = null;
                }
                if (am > 0) continue;
                return fluid.copy();
            }
            return am == fluid.amount ? null : new FluidStack(fluid, fluid.amount - am);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack fluid = null;
            for (TankAccess acc : this.accs) {
                int rem;
                FluidStack stack;
                if ((acc.dir & 2) == 0 || (stack = TankContainer.this.fluids[acc.idx]) == null || stack.amount <= 0) continue;
                if (fluid == null) {
                    rem = Math.min(maxDrain, stack.amount);
                    fluid = new FluidStack(stack, rem);
                } else {
                    if (!stack.isFluidEqual(fluid)) continue;
                    rem = Math.min(maxDrain - fluid.amount, stack.amount);
                    fluid.amount += rem;
                }
                if (doDrain && (stack.amount -= rem) <= 0 && (TankContainer.this.sideCfg >> acc.idx + 48 & 1L) == 0L) {
                    TankContainer.this.fluids[acc.idx] = null;
                }
                if (fluid.amount < maxDrain) continue;
                return fluid;
            }
            return fluid;
        }
    }

    class TankAccess
    implements IFluidTankProperties {
        final int idx;
        final int dir;

        TankAccess(int id, int dir) {
            this.idx = id;
            this.dir = dir;
        }

        public FluidStack getContents() {
            return TankContainer.this.fluids[this.idx] == null ? null : TankContainer.this.fluids[this.idx].copy();
        }

        public int getCapacity() {
            return TankContainer.this.tanks[this.idx].cap;
        }

        public boolean canFill() {
            return (this.dir & 1) != 0;
        }

        public boolean canDrain() {
            return (this.dir & 2) != 0;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return (this.dir & 1) != 0 && TankContainer.this.tanks[this.idx].acceptsType(fluidStack.getFluid());
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return (this.dir & 2) != 0 && TankContainer.this.tanks[this.idx].acceptsType(fluidStack.getFluid());
        }
    }

    public class Tank {
        public final int idx;
        public final int cap;
        public final int inSlot;
        public final int outSlot;
        public final byte dir;
        public final Fluid[] types;

        private Tank(int idx, int cap, byte dir, int in, int out, Fluid ... types) {
            this.idx = idx;
            this.cap = cap;
            this.types = types.length == 0 ? null : types;
            this.dir = dir;
            this.inSlot = in;
            this.outSlot = out;
        }

        public boolean acceptsType(Fluid type) {
            if (this.types == null) {
                return true;
            }
            for (Fluid f : this.types) {
                if (type != f) continue;
                return true;
            }
            return false;
        }
    }
}

