/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.util.ArrayMath;
import cd4017be.lib.util.Stack;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.script.ScriptException;

public class Function {
    private static final int TICK_LIMIT = 262144;
    private static final int REC_LIMIT = 64;
    private final byte[] code;
    public final int Nparam;
    public final int lineOfs;
    public final int Nstack;
    public final boolean hasReturn;
    public final String name;
    private final short[] codeIndices;
    private final short[] lineNumbers;
    public Script script;

    public Function(int param, int stack, int lineOfs, byte[] code, boolean ret, String name, HashMap<Short, Short> lines) {
        this.Nparam = param;
        this.Nstack = stack;
        this.lineOfs = lineOfs;
        this.code = code;
        this.hasReturn = ret;
        this.name = name;
        this.lineNumbers = new short[lines.size()];
        int i = 0;
        for (short s : lines.keySet()) {
            this.lineNumbers[i++] = s;
        }
        Arrays.sort(this.lineNumbers);
        this.codeIndices = new short[this.lineNumbers.length];
        for (i = 0; i < this.lineNumbers.length; ++i) {
            this.codeIndices[i] = lines.get(this.lineNumbers[i]);
        }
    }

    public Object apply(Parameters param) throws ScriptException {
        if (param.param.length != this.Nparam) {
            throw new ScriptException("wrong number of parameters!", this.name, this.lineOfs);
        }
        Stack<Object> stack = new Stack<Object>(this.Nstack);
        stack.fill(param.param);
        ByteBuffer code = ByteBuffer.wrap(this.code);
        int n = 0;
        try {
            while (code.hasRemaining()) {
                if (++n > 262144) {
                    throw new Exception("ran for more than 262144 cycles: infinite loop?");
                }
                Operator lo = Operator.operators[code.get()];
                lo.eval(code, stack, this.script);
            }
            return this.hasReturn ? stack.rem() : null;
        }
        catch (ScriptException ex) {
            throw ex;
        }
        catch (Exception ex) {
            int p = Arrays.binarySearch(this.codeIndices, (short)code.position());
            p = p == -1 ? this.lineOfs : this.lineOfs + this.lineNumbers[p < 0 ? -2 - p : p];
            String msg = ex.getMessage();
            throw (ScriptException)new ScriptException(ex.getClass().getSimpleName() + (msg == null ? "" : ": " + msg), this.name, p).initCause(ex);
        }
    }

    public Function(String name, DataInputStream dis) throws IOException {
        this.name = name;
        int i = dis.readByte();
        this.Nparam = i & 0x7F;
        this.hasReturn = (i & 0x80) != 0;
        this.Nstack = dis.readByte() & 0xFF;
        this.code = new byte[dis.readShort() & 0xFFFF];
        dis.read(this.code);
        this.lineOfs = dis.readShort() & 0xFFFF;
        i = dis.readShort();
        this.lineNumbers = new short[i];
        this.codeIndices = new short[i];
        for (int j = 0; j < i; ++j) {
            this.codeIndices[j] = dis.readShort();
            this.lineNumbers[j] = dis.readShort();
        }
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.Nparam & 0x7F | (this.hasReturn ? 128 : 0));
        dos.writeByte(this.Nstack);
        dos.writeShort(this.code.length);
        dos.write(this.code);
        dos.writeShort(this.lineOfs);
        dos.writeShort(this.lineNumbers.length);
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            dos.writeShort(this.codeIndices[i]);
            dos.writeShort(this.lineNumbers[i]);
        }
    }

    public int size() {
        return this.code.length;
    }

    public static String getName(ByteBuffer code, boolean big) {
        int n = big ? code.getShort() & 0xFFFF : code.get() & 0xFF;
        byte[] data = new byte[n];
        code.get(data);
        return new String(data);
    }

    public static void putName(ByteBuffer code, String name, boolean big) {
        byte[] data = name.getBytes();
        if (big) {
            code.putShort((short)data.length);
        } else {
            code.put((byte)data.length);
        }
        code.put(data);
    }

    public static class FilteredIterator
    implements Iterator {
        private final Iterator it;
        private final Predicate<Object> key;

        public FilteredIterator(Iterator it, Predicate<Object> key) {
            this.it = it;
            this.key = key;
        }

        @Override
        public Object get() {
            return this.it.get();
        }

        @Override
        public void set(Object o) {
            this.it.set(o);
        }

        @Override
        public boolean next() {
            while (this.it.next()) {
                if (!this.key.test(this.it.get())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.it.reset();
        }
    }

    public static class ListIterator<T>
    implements Iterator {
        protected final List<T> arr;
        protected int idx;

        public ListIterator(List<T> arr) {
            this.arr = arr;
            this.idx = -1;
        }

        @Override
        public Object get() {
            return this.arr.get(this.idx);
        }

        @Override
        public void set(Object o) {
            this.arr.set(this.idx, o);
        }

        @Override
        public boolean next() {
            return ++this.idx < this.arr.size();
        }

        @Override
        public void reset() {
            this.idx = -1;
        }
    }

    public static class ArrayIterator
    implements Iterator {
        protected final Object[] arr;
        protected int idx;

        public ArrayIterator(Object[] arr) {
            this.arr = arr;
            this.idx = -1;
        }

        @Override
        public Object get() {
            return this.arr[this.idx];
        }

        @Override
        public void set(Object o) {
            this.arr[this.idx] = o;
        }

        @Override
        public boolean next() {
            return ++this.idx < this.arr.length;
        }

        @Override
        public void reset() {
            this.idx = -1;
        }
    }

    private static class VectIterator
    implements Iterator {
        private final double[] vec;
        private int idx;

        public VectIterator(double[] vec) {
            this.vec = vec;
            this.idx = -1;
        }

        @Override
        public Object get() {
            return this.vec[this.idx];
        }

        @Override
        public void set(Object o) {
            this.vec[this.idx] = (Double)o;
        }

        @Override
        public boolean next() {
            return ++this.idx < this.vec.length;
        }

        @Override
        public void reset() {
            this.idx = -1;
        }
    }

    private static class NumIterator
    implements Iterator {
        private final double max;
        private double idx;

        public NumIterator(double max) {
            this.max = max;
            this.idx = -1.0;
        }

        @Override
        public Object get() {
            return this.idx;
        }

        @Override
        public void set(Object o) {
            this.idx = (Double)o;
        }

        @Override
        public boolean next() {
            double d;
            this.idx += 1.0;
            return d < this.max;
        }

        @Override
        public void reset() {
            this.idx = -1.0;
        }
    }

    public static interface Iterator {
        public Object get();

        public void set(Object var1);

        public boolean next();

        public void reset();
    }

    public static enum Operator {
        gloc(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(stack.get(code.get()));
            }
        }
        ,
        gvar(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                String name = Function.getName(code, false);
                Module m = name.indexOf(46) < 0 ? cont : cont.context;
                stack.add(m.read(name));
            }
        }
        ,
        sloc(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.set(code.get(), stack.rem());
            }
        }
        ,
        svar(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                String name = Function.getName(code, false);
                Object obj = stack.rem();
                if (name.indexOf(46) < 0) {
                    cont.variables.put(name, obj);
                } else {
                    cont.context.assign(name, obj);
                }
            }
        }
        ,
        cst_N(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(code.getDouble());
            }
        }
        ,
        cst_T(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(Function.getName(code, true));
            }
        }
        ,
        cst_true(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(true);
            }
        }
        ,
        cst_false(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(false);
            }
        }
        ,
        cst_nil(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                stack.add(null);
            }
        }
        ,
        go(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                int p = code.getShort() & 0xFFFF;
                code.position(p);
            }
        }
        ,
        goif(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                int pos = code.getShort() & 0xFFFF;
                if (((Boolean)stack.rem()).booleanValue()) {
                    code.position(pos);
                }
            }
        }
        ,
        goifn(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                int pos = code.getShort() & 0xFFFF;
                if (!((Boolean)stack.rem()).booleanValue()) {
                    code.position(pos);
                }
            }
        }
        ,
        call(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                if (++cont.context.recursion > 64) {
                    throw new Exception("more than 64 recursive function calls");
                }
                String name = Function.getName(code, false);
                byte n = code.get();
                Object[] param = new Object[n & 0x7F];
                stack.drain((Object[])param);
                Module m = name.indexOf(46) < 0 ? cont : cont.context;
                Object ret = m.invoke(name, new Parameters(param));
                if ((n & 0x80) != 0) {
                    stack.add(ret);
                }
                --cont.context.recursion;
            }
        }
        ,
        call_save(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                int r;
                if ((r = cont.context.recursion++) >= 64) {
                    throw new Exception("more than 64 recursive function calls");
                }
                String name = Function.getName(code, false);
                byte n = code.get();
                Object[] param = new Object[n & 0x7F];
                stack.drain((Object[])param);
                Module m = name.indexOf(46) < 0 ? cont : cont.context;
                try {
                    Object ret = m.invoke(name, new Parameters(param));
                    if ((n & 0x80) != 0) {
                        stack.add(ret);
                    }
                    stack.add(true);
                }
                catch (Exception e) {
                    stack.add(false);
                }
                cont.context.recursion = r;
            }
        }
        ,
        arr_get(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object pos = stack.rem();
                Object obj = stack.rem();
                if (obj instanceof double[]) {
                    stack.add(((double[])obj)[((Double)pos).intValue()]);
                } else if (obj instanceof String) {
                    Object[] ind = (Object[])pos;
                    stack.add(((String)obj).substring(((Double)ind[0]).intValue(), ((Double)ind[1]).intValue()));
                } else if (obj instanceof Object[]) {
                    stack.add(((Object[])obj)[((Double)pos).intValue()]);
                } else {
                    throw new IllegalArgumentException("array expected!");
                }
            }
        }
        ,
        arr_set(-3){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object pos = stack.rem();
                Object obj = stack.rem();
                Object arr = stack.rem();
                if (arr instanceof double[]) {
                    ((double[])arr)[((Double)pos).intValue()] = (Double)obj;
                } else if (arr instanceof String) {
                    Object[] ind = (Object[])pos;
                    int p0 = ((Double)ind[0]).intValue();
                    int p1 = ((Double)ind[1]).intValue();
                    String s0 = (String)arr;
                    String s1 = obj.toString();
                    stack.add(s0.substring(0, p0).concat(s1).concat(s0.substring(p1)));
                } else if (arr instanceof Object[]) {
                    ((Object[])arr)[((Double)pos).intValue()] = obj;
                } else {
                    throw new IllegalArgumentException("array expected!");
                }
            }
        }
        ,
        arr_l(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object obj = stack.rem();
                if (obj instanceof double[]) {
                    stack.add(((double[])obj).length);
                } else if (obj instanceof String) {
                    stack.add(((String)obj).length());
                } else if (obj instanceof Object[]) {
                    stack.add(((Object[])obj).length);
                } else {
                    throw new IllegalArgumentException("array expected!");
                }
            }
        }
        ,
        arr_pack(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object[] arr = new Object[code.get() & 0xFF];
                stack.drain((Object[])arr);
                stack.add(arr);
            }
        }
        ,
        vec_pack(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object[] arr = new Object[code.get() & 0xFF];
                stack.drain((Object[])arr);
                int n = 0;
                for (Object obj : arr) {
                    if (obj instanceof double[]) {
                        n += ((double[])obj).length;
                        continue;
                    }
                    ++n;
                }
                double[] vec = new double[n];
                int j = 0;
                for (int i = 0; i < arr.length; ++i) {
                    Object obj;
                    obj = arr[i];
                    if (obj instanceof double[]) {
                        double[] sub = (double[])obj;
                        System.arraycopy(sub, 0, vec, j, sub.length);
                        j += sub.length;
                        continue;
                    }
                    vec[j++] = (Double)obj;
                }
                stack.add(vec);
            }
        }
        ,
        text_pack(1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object[] arr = new Object[code.get() & 0xFF];
                stack.drain((Object[])arr);
                String s = "";
                for (Object obj : arr) {
                    s = s + obj.toString();
                }
                stack.add(s);
            }
        }
        ,
        add(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object b = stack.rem();
                Object a = stack.rem();
                Object c = b instanceof double[] ? (a instanceof double[] ? ArrayMath.add((double[])a, (double[])b) : ArrayMath.ofs((double[])b, (Double)a)) : (a instanceof double[] ? ArrayMath.ofs((double[])a, (Double)b) : (Object)((Double)a + (Double)b));
                stack.add(c);
            }
        }
        ,
        sub(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object b = stack.rem();
                Object a = stack.rem();
                Object c = b instanceof double[] ? (a instanceof double[] ? ArrayMath.sub((double[])a, (double[])b) : ArrayMath.neg((double[])b, (Double)a)) : (a instanceof double[] ? ArrayMath.ofs((double[])a, -((Double)b).doubleValue()) : (Object)((Double)a - (Double)b));
                stack.add(c);
            }
        }
        ,
        mul(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object b = stack.rem();
                Object a = stack.rem();
                Object c = b instanceof double[] ? (a instanceof double[] ? ArrayMath.mul((double[])a, (double[])b) : ArrayMath.sca((double[])b, (Double)a)) : (a instanceof double[] ? ArrayMath.sca((double[])a, (Double)b) : (Object)((Double)a * (Double)b));
                stack.add(c);
            }
        }
        ,
        div(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                Object b = stack.rem();
                Object a = stack.rem();
                Object c = b instanceof double[] ? (a instanceof double[] ? ArrayMath.div((double[])a, (double[])b) : ArrayMath.inv((double[])b, (Double)a)) : (a instanceof double[] ? ArrayMath.sca((double[])a, 1.0 / (Double)b) : (Object)((Double)a / (Double)b));
                stack.add(c);
            }
        }
        ,
        neg(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object a = stack.rem();
                Object c = a instanceof double[] ? ArrayMath.neg((double[])a, 0.0) : (Object)(-((Double)a).doubleValue());
                stack.add(c);
            }
        }
        ,
        inv(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object a = stack.rem();
                Object c = a instanceof double[] ? ArrayMath.inv((double[])a, 1.0) : (Object)(1.0 / (Double)a);
                stack.add(c);
            }
        }
        ,
        mod(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                double b = (Double)stack.rem();
                double a = (Double)stack.rem();
                stack.add(a % b);
            }
        }
        ,
        eq(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object b = stack.rem();
                Object a = stack.rem();
                stack.add(a == null ? b == null : b.equals(a));
            }
        }
        ,
        neq(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Object b = stack.rem();
                Object a = stack.rem();
                stack.add(a == null ? b != null : !b.equals(a));
            }
        }
        ,
        ls(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                double b = (Double)stack.rem();
                double a = (Double)stack.rem();
                stack.add(a < b);
            }
        }
        ,
        nls(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                double b = (Double)stack.rem();
                double a = (Double)stack.rem();
                stack.add(a >= b);
            }
        }
        ,
        gr(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                double b = (Double)stack.rem();
                double a = (Double)stack.rem();
                stack.add(a > b);
            }
        }
        ,
        ngr(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                double b = (Double)stack.rem();
                double a = (Double)stack.rem();
                stack.add(a <= b);
            }
        }
        ,
        and(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(a & b);
            }
        }
        ,
        or(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(a | b);
            }
        }
        ,
        nand(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(!(a & b));
            }
        }
        ,
        nor(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(!(a | b));
            }
        }
        ,
        xor(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(a ^ b);
            }
        }
        ,
        xnor(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) {
                boolean b = (Boolean)stack.rem();
                boolean a = (Boolean)stack.rem();
                stack.add(!a ^ b);
            }
        }
        ,
        form(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                stack.add(String.format(Function.getName(code, false), stack.rem()));
            }
        }
        ,
        clear(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                stack.setPos(code.get());
            }
        }
        ,
        iterate(-1){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                Iterator it;
                Object arr = stack.get();
                if (arr instanceof Iterator) {
                    it = (Iterator)arr;
                } else if (arr instanceof Object[]) {
                    it = new ArrayIterator((Object[])arr);
                    stack.set(it);
                } else if (arr instanceof double[]) {
                    it = new VectIterator((double[])arr);
                    stack.set(it);
                } else {
                    it = new NumIterator((Double)arr);
                    stack.set(it);
                }
                int p = code.getShort() & 0xFFFF;
                if (it.next()) {
                    stack.add(it.get());
                } else {
                    stack.rem();
                    code.position(p);
                }
            }
        }
        ,
        end(0){

            @Override
            public void eval(ByteBuffer code, Stack<Object> stack, Script cont) throws Exception {
                stack.setPos(code.get());
                Object val = stack.rem();
                Iterator it = (Iterator)stack.get();
                it.set(val);
                code.position(code.getShort() & 0xFFFF);
            }
        };

        public final int stack;
        public static final Operator[] operators;

        private Operator(int stack) {
            this.stack = stack;
        }

        public abstract void eval(ByteBuffer var1, Stack<Object> var2, Script var3) throws Exception;

        static {
            operators = Operator.values();
        }
    }
}

