/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.util.Orientation;
import java.nio.FloatBuffer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Util {
    public static final FloatBuffer[] matrices = new FloatBuffer[16];
    public static final Util instance;
    public static int RenderFrame;

    @Deprecated
    public static void moveAndOrientToBlock(double x, double y, double z, int dir) {
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        FloatBuffer mat = matrices[dir];
        mat.rewind();
        GL11.glMultMatrix((FloatBuffer)mat);
    }

    public static void moveAndOrientToBlock(double x, double y, double z, Orientation o) {
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrix((FloatBuffer)mat);
    }

    public static void rotateTo(Orientation o) {
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrix((FloatBuffer)mat);
    }

    public static void luminate(TileEntity te, EnumFacing side, int b) {
        BlockPos pos = side == null ? te.func_174877_v() : te.func_174877_v().func_177972_a(side);
        World world = te.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        int l = world.func_175626_b(pos, Math.max(state.getLightValue((IBlockAccess)world, pos), b));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(l & 0xFFFF), (float)(l >> 16));
    }

    public static void rotate(int[] data, int px, ModelRotation rot) {
        int py = px + 1;
        int pz = px + 2;
        switch (rot) {
            case X0_Y0: {
                return;
            }
            case X0_Y90: {
                int i = data[pz];
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X0_Y180: {
                data[px] = Util.neg(data[px]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X0_Y270: {
                int i = data[px];
                data[px] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y0: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y90: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X90_Y180: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = i;
                data[px] = Util.neg(data[px]);
                return;
            }
            case X90_Y270: {
                int i = data[px];
                data[px] = Util.neg(data[py]);
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X180_Y0: {
                data[py] = Util.neg(data[py]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X180_Y90: {
                data[py] = Util.neg(data[py]);
                int i = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X180_Y180: {
                data[px] = Util.neg(data[px]);
                data[py] = Util.neg(data[py]);
                return;
            }
            case X180_Y270: {
                data[py] = Util.neg(data[py]);
                int i = data[px];
                data[px] = Util.neg(data[pz]);
                data[pz] = Util.neg(i);
                return;
            }
            case X270_Y0: {
                int i = data[pz];
                data[pz] = data[py];
                data[py] = Util.neg(i);
                return;
            }
            case X270_Y90: {
                int i = data[py];
                data[py] = Util.neg(data[pz]);
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X270_Y180: {
                int i = data[pz];
                data[pz] = Util.neg(data[py]);
                data[py] = Util.neg(i);
                data[px] = Util.neg(data[px]);
                return;
            }
            case X270_Y270: {
                int i = data[pz];
                data[pz] = Util.neg(data[px]);
                data[px] = data[py];
                data[py] = Util.neg(i);
                return;
            }
        }
    }

    private static int neg(int i) {
        return Float.floatToRawIntBits(1.0f - Float.intBitsToFloat(i));
    }

    private Util() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        ++RenderFrame;
    }

    public static int[] texturedRect(float x, float y, float z, float w, float h, float tx, float ty, float tw, float th) {
        return new int[]{Float.floatToIntBits(x), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty + th), Float.floatToIntBits(x), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty + th)};
    }

    static {
        Vec3d X = new Vec3d(1.0, 0.0, 0.0);
        Vec3d Y = new Vec3d(0.0, 1.0, 0.0);
        Vec3d Z = new Vec3d(0.0, 0.0, 1.0);
        for (Orientation o : Orientation.values()) {
            Vec3d x1 = o.rotate(X);
            Vec3d y1 = o.rotate(Y);
            Vec3d z1 = o.rotate(Z);
            FloatBuffer buff = BufferUtils.createFloatBuffer((int)16);
            buff.put(new float[]{(float)x1.field_72450_a, (float)x1.field_72448_b, (float)x1.field_72449_c, 0.0f, (float)y1.field_72450_a, (float)y1.field_72448_b, (float)y1.field_72449_c, 0.0f, (float)z1.field_72450_a, (float)z1.field_72448_b, (float)z1.field_72449_c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            buff.flip();
            Util.matrices[o.ordinal()] = buff;
        }
        instance = new Util();
        RenderFrame = 0;
    }
}

