/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.api.IAbstractTile;
import cd4017be.lib.block.OrientedBlock;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseTileEntity
extends TileEntity
implements IAbstractTile {
    private IBlockState blockState;

    public BaseTileEntity() {
    }

    public BaseTileEntity(IBlockState state) {
        this.blockState = state;
        this.field_145854_h = this.blockState.func_177230_c();
    }

    public IBlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145854_h = this.blockState.func_177230_c();
        }
        return this.blockState;
    }

    public Orientation getOrientation() {
        this.getBlockState();
        if (this.field_145854_h instanceof OrientedBlock) {
            return (Orientation)((Object)this.blockState.func_177229_b((IProperty)((OrientedBlock)this.field_145854_h).orientProp));
        }
        return Orientation.N;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void markUpdate() {
        this.getBlockState();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.blockState, this.blockState, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public void onChunkUnload() {
        this.field_145846_f = true;
        this.clearData();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.clearData();
    }

    protected void clearData() {
    }

    @Override
    public boolean invalid() {
        return this.field_145846_f;
    }

    @Override
    public ICapabilityProvider getTileOnSide(EnumFacing s) {
        return Utils.neighborTile(this, s);
    }

    public BlockPos pos() {
        return this.field_174879_c;
    }

    protected List<ItemStack> makeDefaultDrops(NBTTagCompound tag) {
        this.getBlockState();
        ItemStack item = new ItemStack(this.field_145854_h, 1, this.field_145854_h.func_180651_a(this.blockState));
        item.func_77982_d(tag);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        list.add(item);
        return list;
    }

    public boolean canPlayerAccessUI(EntityPlayer player) {
        return !player.field_70128_L && !this.field_145846_f && this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 64.0;
    }

    public String getName() {
        return TooltipUtil.translate(this.func_145838_q().func_149739_a().replace("tile.", "gui.").concat(".name"));
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.blockState = null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return newState.func_177230_c() != oldState.func_177230_c();
    }
}

