/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.AutomationRecipes;
import cd4017be.api.recipes.OreGenHandler;
import cd4017be.lib.Lib;
import cd4017be.lib.NBTRecipe;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.util.OreDictStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeAPI {
    public static final HashMap<String, IRecipeHandler> Handlers = new HashMap();
    public static final HashMap<String, IRecipeList> Lists = new HashMap();

    public static Predicate<Object> getFilter(Object o) {
        if (o instanceof String) {
            return new RegexFilter((String)o);
        }
        if (o instanceof ItemStack) {
            ItemStack item = (ItemStack)o;
            return p -> p instanceof ItemStack && item.func_77969_a((ItemStack)p);
        }
        if (o instanceof FluidStack) {
            FluidStack fluid = (FluidStack)o;
            return p -> p instanceof FluidStack && fluid.isFluidEqual((FluidStack)p);
        }
        if (o instanceof OreDictStack) {
            OreDictStack ore = (OreDictStack)o;
            return p -> p instanceof OreDictStack ? ore.ID == ((OreDictStack)p).ID : (p instanceof String ? ore.id.equals((String)p) : p instanceof ItemStack && ore.isEqual((ItemStack)p));
        }
        if (o == null) {
            return p -> p == null;
        }
        return p -> o.equals(p);
    }

    public static void createOreDictEntries(Class<?> c, String name) {
        block3: {
            block2: {
                if (!Block.class.isAssignableFrom(c)) break block2;
                for (Block block : Block.field_149771_c) {
                    Item item;
                    if (!c.isInstance(block) || (item = Item.func_150898_a((Block)block)) == null) continue;
                    OreDictionary.registerOre((String)name, (Item)item);
                }
                break block3;
            }
            if (!Item.class.isAssignableFrom(c)) break block3;
            for (Item item : Item.field_150901_e) {
                if (!c.isInstance(item)) continue;
                OreDictionary.registerOre((String)name, (Item)item);
            }
        }
    }

    static {
        Handlers.put("shaped", p -> {
            int i;
            String[] pattern = p.getString(2).split("/");
            int n = p.param.length - 3;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 3];
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(p.get(1, ItemStack.class), arr));
        });
        Handlers.put("shapedNBT", p -> {
            int i;
            String[] pattern = p.getString(3).split("/");
            int n = p.param.length - 4;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 4];
            }
            GameRegistry.addRecipe((IRecipe)new NBTRecipe(p.get(2, ItemStack.class), p.getString(1), arr));
        });
        Handlers.put("ore", p -> {
            String name = p.getString(1);
            for (int i = 2; i < p.param.length; ++i) {
                OreDictionary.registerOre((String)name, (ItemStack)p.get(i, ItemStack.class));
            }
        });
        Lists.put("ore", p -> new Function.FilteredIterator(new Function.ArrayIterator(OreDictionary.getOreNames()), new RegexFilter(p.getString(1))));
        Lists.put("craftIng", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), false));
        Lists.put("craftRes", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), true));
        Handlers.put("shapeless", p -> GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length))));
        Handlers.put("smelt", p -> GameRegistry.addSmelting((ItemStack)p.get(1, ItemStack.class), (ItemStack)p.get(2, ItemStack.class), (float)(p.param.length > 3 ? (float)p.getNumber(3) : 0.0f)));
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        Handlers.put("item", p -> Lib.materials.addMaterial((int)p.getNumber(1), p.getString(2)));
        if (Loader.isModLoaded((String)"Automation")) {
            Handlers.put("advFurn", p -> {
                FluidStack Fin = null;
                FluidStack Fout = null;
                ArrayList<Object> Iin = new ArrayList<Object>();
                ArrayList<ItemStack> Iout = new ArrayList<ItemStack>();
                for (Object o : p.getArray(1)) {
                    if (o instanceof FluidStack) {
                        Fin = (FluidStack)o;
                        continue;
                    }
                    Iin.add(o);
                }
                for (Object o : p.getArray(2)) {
                    if (o instanceof FluidStack) {
                        Fout = (FluidStack)o;
                        continue;
                    }
                    if (o instanceof ItemStack) {
                        Iout.add((ItemStack)o);
                        continue;
                    }
                    throw new IllegalArgumentException("expected ItemStack or FluidStack as element of array @ 2");
                }
                AutomationRecipes.addRecipe(new AutomationRecipes.LFRecipe(Fin, Iin.isEmpty() ? null : Iin.toArray(new Object[Iin.size()]), Fout, Iout.isEmpty() ? null : Iout.toArray(new ItemStack[Iout.size()]), (float)p.getNumber(3)));
            });
            Handlers.put("compAs", p -> AutomationRecipes.addCmpRecipe(p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length)));
            Handlers.put("electr", p -> AutomationRecipes.addRecipe(new AutomationRecipes.ElRecipe(p.get(1), p.get(2), p.get(3), (float)p.getNumber(4))));
            Handlers.put("cool", p -> AutomationRecipes.addRecipe(new AutomationRecipes.CoolRecipe(p.get(1), p.get(2), p.get(3), p.get(4), (float)p.getNumber(5))));
            Handlers.put("trash", p -> AutomationRecipes.addRecipe(new AutomationRecipes.GCRecipe(p.get(1, ItemStack.class), p.get(2, ItemStack.class), (int)p.getNumber(3))));
            Handlers.put("heatRad", p -> AutomationRecipes.addRadiatorRecipe(p.get(1, FluidStack.class), p.get(2, FluidStack.class)));
            Handlers.put("algae", p -> AutomationRecipes.bioList.add(new AutomationRecipes.BioEntry(p.get(1), (int)p.getNumber(2), (int)p.getNumber(3))));
        }
    }

    private static class ShapedIngredients
    extends Function.ArrayIterator {
        private final Predicate<Object> key;
        private Object curElement;

        public ShapedIngredients(ShapedOreRecipe rcp, Predicate<Object> key) {
            super(rcp.getInput());
            this.key = key;
        }

        @Override
        public Object get() {
            return this.curElement;
        }

        @Override
        public void set(Object o) {
            if (o == this.curElement) {
                return;
            }
            if (o == null || o instanceof ItemStack) {
                this.arr[this.idx] = o;
            } else if (o instanceof OreDictStack) {
                this.arr[this.idx] = OreDictionary.getOres((String)((OreDictStack)o).id);
            } else {
                throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
            }
        }

        @Override
        public boolean next() {
            while (++this.idx < this.arr.length) {
                this.curElement = this.arr[this.idx];
                if (this.curElement instanceof List) {
                    List list = (List)this.curElement;
                    if (list.isEmpty()) continue;
                    if (this.key == null) {
                        this.curElement = list.get(0);
                        return true;
                    }
                    for (Object o : list) {
                        if (!this.key.test(o)) continue;
                        this.curElement = o;
                        return true;
                    }
                    continue;
                }
                if (this.key != null && !this.key.test(this.curElement)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ShapelessIngredients
    extends Function.ListIterator<Object> {
        private final Predicate<Object> key;
        private Object curElement;

        public ShapelessIngredients(ShapelessOreRecipe rcp, Predicate<Object> key) {
            super(rcp.getInput());
            this.key = key;
        }

        @Override
        public Object get() {
            return this.curElement;
        }

        @Override
        public void set(Object o) {
            if (o == this.curElement) {
                return;
            }
            if (o instanceof ItemStack) {
                this.arr.set(this.idx, o);
            } else if (o instanceof OreDictStack) {
                this.arr.set(this.idx, OreDictionary.getOres((String)((OreDictStack)o).id));
            } else if (o == null) {
                this.arr.remove(this.idx--);
            } else {
                throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
            }
        }

        @Override
        public boolean next() {
            while (++this.idx < this.arr.size()) {
                this.curElement = this.arr.get(this.idx);
                if (this.curElement instanceof List) {
                    List list = (List)this.curElement;
                    if (list.isEmpty()) continue;
                    if (this.key == null) {
                        this.curElement = list.get(0);
                        return true;
                    }
                    for (Object o : list) {
                        if (!this.key.test(o)) continue;
                        this.curElement = o;
                        return true;
                    }
                    continue;
                }
                if (this.key != null && !this.key.test(this.curElement)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CraftingRecipeIterator
    implements Function.Iterator {
        private final List<IRecipe> list;
        private final Predicate<Object> key;
        private final boolean in;
        private int idx;
        private Object[] curElement;
        private IRecipe curRecipe;

        public CraftingRecipeIterator(Predicate<Object> key, boolean res) {
            this.key = key;
            this.list = CraftingManager.func_77594_a().func_77592_b();
            this.in = !res;
            this.idx = -1;
        }

        @Override
        public Object get() {
            return this.curElement;
        }

        @Override
        public void set(Object o) {
            if (this.list.get(this.idx) != this.curRecipe) {
                throw new ConcurrentModificationException();
            }
            if (o == null) {
                this.list.remove(this.idx--);
            } else if (o == this.curElement && this.curElement[0] != this.curRecipe.func_77571_b()) {
                if (!(this.curElement[0] instanceof ItemStack)) {
                    throw new IllegalArgumentException("ItemStack expected");
                }
                ItemStack item = (ItemStack)this.curElement[0];
                ItemStack res = this.curRecipe.func_77571_b();
                if (res != null) {
                    res.func_77964_b(item.func_77952_i());
                    res.func_77982_d(item.func_77978_p());
                    res.func_190920_e(item.func_190916_E());
                }
            }
        }

        @Override
        public boolean next() {
            int l = this.list.size();
            while (++this.idx < l) {
                Function.Iterator ingred;
                this.curRecipe = this.list.get(this.idx);
                ItemStack result = this.curRecipe.func_77571_b();
                if (!this.in && !this.key.test(result)) continue;
                if (this.curRecipe instanceof ShapedOreRecipe) {
                    ingred = new ShapedIngredients((ShapedOreRecipe)this.curRecipe, this.in ? this.key : null);
                } else if (this.curRecipe instanceof ShapelessOreRecipe) {
                    ingred = new ShapelessIngredients((ShapelessOreRecipe)this.curRecipe, this.in ? this.key : null);
                } else if (this.curRecipe instanceof ShapedRecipes) {
                    ingred = new Function.ArrayIterator(((ShapedRecipes)this.curRecipe).field_77574_d);
                    if (this.in) {
                        ingred = new Function.FilteredIterator(ingred, this.key);
                    }
                } else {
                    if (!(this.curRecipe instanceof ShapelessRecipes)) continue;
                    ingred = new Function.ListIterator(((ShapelessRecipes)this.curRecipe).field_77579_b);
                    if (this.in) {
                        ingred = new Function.FilteredIterator(ingred, this.key);
                    }
                }
                if (this.in) {
                    if (!ingred.next()) continue;
                    ingred.reset();
                }
                this.curElement = new Object[]{result, ingred};
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.idx = -1;
        }
    }

    public static class RegexFilter
    implements Predicate<Object> {
        private final Pattern pattern;

        public RegexFilter(String expr) {
            this.pattern = Pattern.compile(expr);
        }

        @Override
        public boolean test(Object o) {
            return o != null && this.pattern.matcher(o.toString()).matches();
        }
    }

    private static class FuelHandler
    implements IRecipeHandler,
    IFuelHandler {
        HashMap<Integer, Integer> fuelList = new HashMap();

        public FuelHandler() {
            GameRegistry.registerFuelHandler((IFuelHandler)this);
        }

        int key(ItemStack item) {
            return Item.func_150891_b((Item)item.func_77973_b()) & 0xFFFF | (item.func_77952_i() & 0xFFFF) << 16;
        }

        @Override
        public void addRecipe(Parameters p) {
            this.fuelList.put(this.key(p.get(1, ItemStack.class)), (int)p.getNumber(2));
        }

        public int getBurnTime(ItemStack fuel) {
            Integer val = this.fuelList.get(this.key(fuel));
            return val == null ? 0 : val;
        }
    }

    public static interface IRecipeList {
        public Function.Iterator list(Parameters var1);
    }

    public static interface IRecipeHandler {
        public void addRecipe(Parameters var1);
    }
}

