/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.circuits;

import cd4017be.api.circuits.ISensor;
import cd4017be.lib.DefaultItem;
import cd4017be.lib.util.TooltipUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class ItemBlockSensor
extends DefaultItem
implements ISensor {
    public double RangeSQ;

    public ItemBlockSensor(String id, float range) {
        super(id);
        this.RangeSQ = range * range;
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> list, boolean b) {
        if (item.func_77942_o()) {
            list.add(TooltipUtil.formatLink(BlockPos.func_177969_a((long)item.func_77978_p().func_74763_f("link")), EnumFacing.func_82600_a((int)item.func_77978_p().func_74771_c("side"))));
        }
        super.func_77624_a(item, player, list, b);
    }

    @Override
    public String func_77653_i(ItemStack item) {
        return String.format(super.func_77653_i(item), Float.valueOf(item.func_77942_o() ? item.func_77978_p().func_74760_g("cache") : 0.0f));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            this.measure(stack, world, entity.func_180425_c());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74772_a("link", pos.func_177986_g());
        nbt.func_74774_a("side", (byte)side.ordinal());
        return EnumActionResult.SUCCESS;
    }

    @Override
    public double measure(ItemStack sensor, World world, BlockPos src) {
        NBTTagCompound nbt = sensor.func_77978_p();
        if (nbt == null) {
            return 0.0;
        }
        BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("link"));
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || pos.func_177951_i((Vec3i)src) > this.RangeSQ || !world.func_175667_e(pos)) {
            return nbt.func_74760_g("cache");
        }
        EnumFacing side = EnumFacing.func_82600_a((int)nbt.func_74771_c("side"));
        float x = this.measure(sensor, nbt, world, pos, side);
        nbt.func_74776_a("cache", x);
        return x;
    }

    protected abstract float measure(ItemStack var1, NBTTagCompound var2, World var3, BlockPos var4, EnumFacing var5);
}

