/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;

public class MatterOrbItemHandler {
    public static void addInformation(ItemStack item, List<String> list) {
        if (MatterOrbItemHandler.isMatterOrb(item)) {
            IMatterOrb orb = (IMatterOrb)item.func_77973_b();
            list.add(String.format("Item storage: %d / %d types", MatterOrbItemHandler.getUsedTypes(item), orb.getMaxTypes(item)));
        }
    }

    public static int getUsedTypes(ItemStack item) {
        if (MatterOrbItemHandler.isMatterOrb(item)) {
            IMatterOrb orb = (IMatterOrb)item.func_77973_b();
            String tag = orb.getMatterTag(item);
            MatterOrbItemHandler.createNBT(item, tag);
            return item.func_77978_p().func_150295_c(tag, 10).func_74745_c();
        }
        return 0;
    }

    public static ItemStack getItem(ItemStack item, int s) {
        if (!MatterOrbItemHandler.isMatterOrb(item)) {
            return null;
        }
        IMatterOrb orb = (IMatterOrb)item.func_77973_b();
        String tag = orb.getMatterTag(item);
        MatterOrbItemHandler.createNBT(item, tag);
        NBTTagList list = item.func_77978_p().func_150295_c(tag, 10);
        if (list.func_74745_c() <= s) {
            return null;
        }
        NBTTagCompound nbt = list.func_150305_b(s);
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("i")), nbt.func_74762_e("n"), (int)nbt.func_74765_d("d"));
        if (nbt.func_74764_b("t")) {
            stack.func_77982_d(nbt.func_74775_l("t"));
        }
        return stack;
    }

    public static ItemStack[] getAllItems(ItemStack item) {
        if (!MatterOrbItemHandler.isMatterOrb(item)) {
            return new ItemStack[0];
        }
        IMatterOrb orb = (IMatterOrb)item.func_77973_b();
        String tag = orb.getMatterTag(item);
        MatterOrbItemHandler.createNBT(item, tag);
        NBTTagList list = item.func_77978_p().func_150295_c(tag, 10);
        ItemStack[] cont = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            cont[i] = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("i")), nbt.func_74762_e("n"), (int)nbt.func_74765_d("d"));
            if (!nbt.func_74764_b("t")) continue;
            cont[i].func_77982_d(nbt.func_74775_l("t"));
        }
        return cont;
    }

    public static ItemStack decrStackSize(ItemStack item, int s, int n) {
        if (!MatterOrbItemHandler.isMatterOrb(item) || n <= 0) {
            return null;
        }
        IMatterOrb orb = (IMatterOrb)item.func_77973_b();
        String tag = orb.getMatterTag(item);
        MatterOrbItemHandler.createNBT(item, tag);
        NBTTagList list = item.func_77978_p().func_150295_c(tag, 10);
        if (list.func_74745_c() <= s) {
            return null;
        }
        NBTTagCompound nbt = list.func_150305_b(s);
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("i")), nbt.func_74762_e("n"), (int)nbt.func_74765_d("d"));
        if (nbt.func_74764_b("t")) {
            stack.func_77982_d(nbt.func_74775_l("t"));
        }
        if (n >= stack.func_190916_E()) {
            list.func_74744_a(s);
            return stack;
        }
        nbt.func_74768_a("n", stack.func_190916_E() - n);
        stack.func_190920_e(n);
        return stack;
    }

    public static boolean canInsert(ItemStack item, ItemStack ... stacks) {
        if (!MatterOrbItemHandler.isMatterOrb(item)) {
            return false;
        }
        if (stacks == null || stacks.length == 0) {
            return true;
        }
        IMatterOrb orb = (IMatterOrb)item.func_77973_b();
        String tag = orb.getMatterTag(item);
        MatterOrbItemHandler.createNBT(item, tag);
        NBTTagList list = item.func_77978_p().func_150295_c(tag, 10);
        int l = list.func_74745_c() + stacks.length;
        int max = orb.getMaxTypes(item);
        for (int i = 0; i < stacks.length && l - i > max; ++i) {
            boolean miss = true;
            for (int j = 0; j < l; ++j) {
                NBTTagCompound nbt = list.func_150305_b(j);
                if (nbt.func_74765_d("i") != Item.func_150891_b((Item)stacks[i].func_77973_b()) || nbt.func_74765_d("d") != stacks[i].func_77952_i() || (nbt.func_74764_b("t") || stacks[i].func_77978_p() != null) && (stacks[i].func_77978_p() == null || !stacks[i].func_77978_p().equals((Object)nbt.func_74781_a("t")))) continue;
                miss = false;
                break;
            }
            if (!miss) continue;
            return false;
        }
        return true;
    }

    public static ItemStack[] addItemStacks(ItemStack item, ItemStack ... stacks) {
        if (!MatterOrbItemHandler.isMatterOrb(item)) {
            return stacks;
        }
        if (stacks == null || stacks.length == 0) {
            return new ItemStack[0];
        }
        IMatterOrb orb = (IMatterOrb)item.func_77973_b();
        String tag = orb.getMatterTag(item);
        MatterOrbItemHandler.createNBT(item, tag);
        NBTTagList list = item.func_77978_p().func_150295_c(tag, 10);
        int max = orb.getMaxTypes(item);
        int n = stacks.length + list.func_74745_c() - max;
        ItemStack[] remain = new ItemStack[n < 0 ? 0 : n];
        n = 0;
        for (ItemStack stack : stacks) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                if (nbt.func_74765_d("i") != Item.func_150891_b((Item)stack.func_77973_b()) || nbt.func_74765_d("d") != stack.func_77952_i() || (nbt.func_74764_b("t") || stack.func_77978_p() != null) && (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)nbt.func_74781_a("t")))) continue;
                nbt.func_74768_a("n", nbt.func_74762_e("n") + stack.func_190916_E());
                stack.func_190920_e(0);
                break;
            }
            if (stack.func_190916_E() > 0 && list.func_74745_c() < max) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74777_a("i", (short)Item.func_150891_b((Item)stack.func_77973_b()));
                nbt.func_74768_a("n", stack.func_190916_E());
                nbt.func_74777_a("d", (short)stack.func_77952_i());
                if (stack.func_77978_p() != null) {
                    nbt.func_74782_a("t", (NBTBase)stack.func_77978_p());
                }
                list.func_74742_a((NBTBase)nbt);
                continue;
            }
            if (stack.func_190916_E() <= 0) continue;
            remain[n++] = stack;
        }
        return remain.length == n ? remain : Arrays.copyOf(remain, n);
    }

    public static boolean isMatterOrb(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IMatterOrb;
    }

    public static void createNBT(ItemStack item, String tag) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (!item.func_77978_p().func_74764_b(tag)) {
            item.func_77978_p().func_74782_a(tag, (NBTBase)new NBTTagList());
        }
    }

    public static class Access
    implements IItemHandler {
        public final InventoryPlayer inv;
        public int slot;
        public int tool;

        public Access(InventoryPlayer inv) {
            this.inv = inv;
            this.slot = 0;
            this.tool = inv.field_70461_c;
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int s) {
            if (s == 0) {
                return null;
            }
            ItemStack stack = MatterOrbItemHandler.getItem((ItemStack)this.inv.field_70462_a.get(this.tool), this.slot);
            if (stack != null) {
                stack.func_190920_e(1);
            }
            return stack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean sim) {
            if (slot != 0) {
                return stack;
            }
            if (sim) {
                return MatterOrbItemHandler.canInsert((ItemStack)this.inv.field_70462_a.get(this.tool), stack) ? null : stack;
            }
            ItemStack[] rem = MatterOrbItemHandler.addItemStacks((ItemStack)this.inv.field_70462_a.get(this.tool), stack.func_77946_l());
            return rem.length == 0 ? null : rem[0];
        }

        public ItemStack extractItem(int s, int amount, boolean simulate) {
            if (s == 0) {
                return null;
            }
            if (simulate) {
                ItemStack stack = MatterOrbItemHandler.getItem((ItemStack)this.inv.field_70462_a.get(this.tool), this.slot);
                if (stack.func_190916_E() > amount) {
                    stack.func_190920_e(amount);
                }
                return stack;
            }
            return MatterOrbItemHandler.decrStackSize((ItemStack)this.inv.field_70462_a.get(this.tool), this.slot, amount);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    }

    public static interface IMatterOrb {
        public int getMaxTypes(ItemStack var1);

        public String getMatterTag(ItemStack var1);
    }
}

