/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.lib.templates.InventoryItem;
import cd4017be.lib.util.Utils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryItemHandler {
    public static void addInformation(ItemStack item, List<String> list) {
        if (InventoryItemHandler.isInventoryItem(item)) {
            IItemStorage inv = (IItemStorage)item.func_77973_b();
            int n = 0;
            if (item.func_77978_p() != null) {
                n = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10).func_74745_c();
            }
            list.add(String.format("Slots: %d / %d used", n, inv.getSizeInventory(item)));
        }
    }

    public static ItemStack insertItemStack(ItemStack item, ItemStack stack) {
        int s;
        if (!InventoryItemHandler.isInventoryItem(item) || stack == null) {
            return stack;
        }
        stack = stack.func_77946_l();
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        boolean[] emptyS = new boolean[inv.getSizeInventory(item)];
        for (int i = 0; i < list.func_74745_c() && stack != null; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            s = tag.func_74771_c("slot") & 0xFF;
            if (s >= emptyS.length) continue;
            emptyS[s] = true;
            ItemStack it = new ItemStack(tag);
            if (!Utils.itemsEqual(stack, it)) continue;
            if (it.func_190916_E() + stack.func_190916_E() <= it.func_77976_d()) {
                it.func_190917_f(stack.func_190916_E());
                stack = null;
            } else {
                stack.func_190918_g(it.func_77976_d() - it.func_190916_E());
                it.func_190920_e(it.func_77976_d());
            }
            it.func_77955_b(tag);
        }
        if (stack != null) {
            s = 0;
            while (emptyS[s]) {
                if (++s < emptyS.length) continue;
                return stack;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77955_b(nbt);
            nbt.func_74774_a("slot", (byte)s);
            list.func_74742_a((NBTBase)nbt);
        }
        return null;
    }

    public static ItemStack[] getItemList(ItemStack item) {
        if (!InventoryItemHandler.isInventoryItem(item) || item.func_77978_p() == null) {
            return new ItemStack[0];
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        ItemStack[] buff = new ItemStack[list.func_74745_c()];
        int n = 0;
        for (int i = 0; i < buff.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack it = new ItemStack(tag);
            for (int j = 0; j < n && it != null; ++j) {
                if (!Utils.itemsEqual(buff[j], it)) continue;
                buff[j].func_190917_f(it.func_190916_E());
                it = null;
            }
            if (it == null) continue;
            buff[n++] = it;
        }
        ItemStack[] ret = new ItemStack[n];
        System.arraycopy(buff, 0, ret, 0, n);
        return ret;
    }

    public static boolean hasEmptySlot(ItemStack item) {
        if (!InventoryItemHandler.isInventoryItem(item)) {
            return false;
        }
        if (item.func_77978_p() == null) {
            return true;
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        return inv.getSizeInventory(item) > item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10).func_74745_c();
    }

    public static int extractItemStack(ItemStack item, ItemStack stack) {
        if (!InventoryItemHandler.isInventoryItem(item) || item.func_77978_p() == null || stack == null) {
            return 0;
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        int n = stack.func_190916_E();
        for (int i = 0; i < list.func_74745_c() && n > 0; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack it = new ItemStack(tag);
            if (!Utils.itemsEqual(stack, it)) continue;
            if (it.func_190916_E() <= n) {
                n -= it.func_190916_E();
                list.func_74744_a(i--);
                continue;
            }
            it.func_190918_g(n);
            n = 0;
            it.func_77955_b(tag);
        }
        return stack.func_190916_E() - n;
    }

    public static boolean isInventoryItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IItemStorage;
    }

    public static interface IItemStorage
    extends InventoryItem.IItemInventory {
        public int getSizeInventory(ItemStack var1);

        public String getInventoryTag();
    }
}

