/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AntimatterItemHandler {
    public static void addInformation(ItemStack item, List<String> list) {
        if (AntimatterItemHandler.isAntimatterItem(item)) {
            list.add(String.format("Antimatter: %d / %d ng", AntimatterItemHandler.getAntimatter(item), ((IAntimatterItem)item.func_77973_b()).getAmCapacity(item)));
        }
    }

    public static int getAntimatter(ItemStack item) {
        if (item != null && item.func_77973_b() instanceof IAntimatterItem) {
            IAntimatterItem ei = (IAntimatterItem)item.func_77973_b();
            String tag = ei.getAntimatterTag(item);
            AntimatterItemHandler.createNBT(item, tag);
            return item.func_77978_p().func_74762_e(tag);
        }
        return 0;
    }

    public static int addAntimatter(ItemStack item, int n) {
        if (item != null && item.func_77973_b() instanceof IAntimatterItem) {
            int r;
            int s;
            IAntimatterItem ei = (IAntimatterItem)item.func_77973_b();
            String tag = ei.getAntimatterTag(item);
            AntimatterItemHandler.createNBT(item, tag);
            int cap = ei.getAmCapacity(item);
            int e = item.func_77978_p().func_74762_e(tag) + n;
            if (e < 0) {
                s = 0;
                r = n - e;
            } else if (e > cap) {
                s = cap;
                r = n - e + cap;
            } else {
                s = e;
                r = n;
            }
            item.func_77978_p().func_74768_a(tag, s);
            return r;
        }
        return 0;
    }

    public static boolean isAntimatterItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IAntimatterItem;
    }

    private static void createNBT(ItemStack item, String tag) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (!item.func_77978_p().func_74764_b(tag)) {
            item.func_77978_p().func_74768_a(tag, 0);
        }
    }

    public static interface IAntimatterItem {
        public int getAmCapacity(ItemStack var1);

        public String getAntimatterTag(ItemStack var1);
    }
}

