/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.lib.ModTileEntity;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static final BlockPos NOWHERE = new BlockPos(0, -1, 0);
    public static final byte IN = -1;
    public static final byte OUT = 1;
    public static final byte ACC = 0;
    private static final String[] DecScale = new String[]{"a", "f", "p", "n", "u", "m", "", "k", "M", "G", "T", "P", "E"};
    private static final int ofsDecScale = 6;

    public static boolean itemsEqual(ItemStack item0, ItemStack item1) {
        return item0 == null && item1 == null || item0 != null && item1 != null && item0.func_77969_a(item1) && ItemStack.func_77970_a((ItemStack)item0, (ItemStack)item1);
    }

    public static boolean oresEqual(ItemStack item0, ItemStack item1) {
        if (Utils.itemsEqual(item0, item1)) {
            return true;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)item0);
        for (int id1 : OreDictionary.getOreIDs((ItemStack)item1)) {
            for (int id0 : ids) {
                if (id0 != id1) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] accessibleSlots(IInventory inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180463_a(EnumFacing.field_82609_l[side]);
        }
        int[] s = new int[inv.func_70302_i_()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = i;
        }
        return s;
    }

    public static TileEntity getTileOnSide(ModTileEntity tileEntity, byte s) {
        if (tileEntity == null) {
            return null;
        }
        return tileEntity.getLoadedTile(tileEntity.func_174877_v().func_177972_a(EnumFacing.field_82609_l[s]));
    }

    public static String formatNumber(double x, int w, int c) {
        String ds;
        double s = Math.signum(x);
        if (x == 0.0 || Double.isNaN(x) || Double.isInfinite(x)) {
            return "" + x;
        }
        int o = (int)Math.floor(Math.log10(x * s)) + 18;
        int p = (o + c) / 3;
        int n = w - o + p * 3 - 1;
        if (p < 0) {
            return "0";
        }
        if (p > DecScale.length) {
            return "" + (s == -1.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        String tex = String.format("%." + n + "f", x *= Math.pow(0.001, p - 6));
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex + DecScale[p];
    }

    public static String formatNumber(double x, int w) {
        String ds;
        String tex = String.format("%." + w + "f", x);
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    public static FluidStack getFluid(World world, BlockPos pos, boolean sourceOnly) {
        boolean source;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return null;
        }
        if (block instanceof IFluidBlock) {
            FluidStack fluid = ((IFluidBlock)block).drain(world, pos, false);
            if (!sourceOnly && fluid == null) {
                return new FluidStack(((IFluidBlock)block).getFluid(), 0);
            }
            return fluid;
        }
        boolean bl = source = state == block.func_176223_P();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.WATER, source ? 1000 : 0) : null;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return source || !sourceOnly ? new FluidStack(FluidRegistry.LAVA, source ? 1000 : 0) : null;
        }
        return null;
    }

    public static int findStack(ItemStack item, IInventory inv, int[] s, int start) {
        if (item == null) {
            return -1;
        }
        for (int i = start; i < s.length; ++i) {
            if (!Utils.itemsEqual(item, inv.func_70301_a(s[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int mod(int a, int b) {
        return a < 0 ? b - (-a - 1) % b - 1 : a % b;
    }

    public static int div(int a, int b) {
        return a < 0 ? -1 - (-a - 1) / b : a / b;
    }

    public static byte getLookDir(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return 0;
        }
        if (entity.field_70125_A > 45.0f) {
            return 1;
        }
        int d = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (d == 0) {
            return 2;
        }
        if (d == 1) {
            return 5;
        }
        if (d == 2) {
            return 3;
        }
        return 4;
    }

    public static void updateRedstoneOnSide(ModTileEntity te, int value, EnumFacing side) {
        ICapabilityProvider cp = te.getTileOnSide(side);
        if (cp != null && cp instanceof IQuickRedstoneHandler) {
            ((IQuickRedstoneHandler)cp).onRedstoneStateChange(side.func_176734_d(), value, te);
        } else {
            te.func_145831_w().func_180496_d(te.func_174877_v().func_177972_a(side), te.func_145838_q());
        }
    }

    public static int cycleState(int cfg, int i, int m, int r, boolean incr) {
        return cfg & ~(m << i) | ((cfg >> i & m) + (incr ? 1 : r - 1)) % r << i;
    }

    public static int setState(int cfg, int i, int m, int x) {
        return cfg & ~(m << i) | (x & m) << i;
    }

    public static long cycleState(long cfg, int i, long m, int r, boolean incr) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | (long)(((int)(cfg >> i & m) + (incr ? 1 : r - 1)) % r) << i;
    }

    public static long setState(long cfg, int i, long m, int x) {
        return cfg & (m << i ^ 0xFFFFFFFFFFFFFFFFL) | ((long)x & m) << i;
    }

    public static class ItemType {
        public final ItemStack[] types;
        public final boolean meta;
        public final boolean nbt;
        public final int[] ores;

        public ItemType() {
            this.types = null;
            this.ores = null;
            this.meta = false;
            this.nbt = false;
        }

        public ItemType(ItemStack ... types) {
            this.types = types;
            this.ores = null;
            this.meta = true;
            this.nbt = true;
        }

        public ItemType(boolean meta, boolean nbt, boolean ore, ItemStack ... types) {
            this.types = types;
            this.meta = meta;
            this.nbt = nbt;
            if (ore) {
                HashSet<Integer> list = new HashSet<Integer>();
                for (int i = 0; i < types.length; ++i) {
                    for (int j : OreDictionary.getOreIDs((ItemStack)types[i])) {
                        list.add(j);
                    }
                }
                this.ores = new int[list.size()];
                int n = 0;
                Object object = list.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    this.ores[n++] = i;
                }
            } else {
                this.ores = null;
            }
        }

        public boolean matches(ItemStack item) {
            if (item == null) {
                return false;
            }
            if (this.types == null) {
                return true;
            }
            for (ItemStack type : this.types) {
                if (type == null || item.func_77973_b() != type.func_77973_b() || this.meta && item.func_77952_i() != type.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
                return true;
            }
            if (this.ores == null) {
                return false;
            }
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i : this.ores) {
                    if (i != o) continue;
                    return true;
                }
            }
            return false;
        }

        public int getMatch(ItemStack item) {
            if (item == null) {
                return -1;
            }
            if (this.types == null) {
                return -1;
            }
            for (int i = 0; i < this.types.length; ++i) {
                ItemStack type = this.types[i];
                if (type == null || item.func_77973_b() != type.func_77973_b() || this.meta && item.func_77952_i() != type.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
                return i;
            }
            if (this.ores == null) {
                return -1;
            }
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i = 0; i < this.ores.length; ++i) {
                    if (this.ores[i] != o) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

