/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.util.IFilter;
import cd4017be.lib.util.OreDictStack;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFluidUtil {
    public static final String Tag_ItemList = "Items";
    public static final String Tag_ItemIndex = "ItIdx";
    public static final String Tag_FluidList = "Fluids";
    public static final String Tag_FluidIndex = "FlIdx";
    public static final Container CraftContDummy = new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return true;
        }

        public void func_75130_a(IInventory par1IInventory) {
        }
    };

    public static void loadInventory(NBTTagList list, ItemStack[] inv) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int s = tag.func_74771_c("slot") & 0xFF;
            if (s >= inv.length) continue;
            inv[s] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public static NBTTagList saveInventory(ItemStack[] inv) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            inv[i].func_77955_b(tag);
            tag.func_74774_a("slot", (byte)i);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static ItemStack[] loadItems(NBTTagList list) {
        ItemStack[] items = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
        }
        return items;
    }

    public static void loadItems(NBTTagList list, ItemStack[] items) {
        int m = Math.min(items.length, list.func_74745_c());
        for (int i = 0; i < m; ++i) {
            items[i] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
        }
    }

    public static NBTTagList saveItems(ItemStack[] items) {
        NBTTagList list = new NBTTagList();
        for (ItemStack item : items) {
            if (item == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static NBTTagList saveFluids(FluidStack[] fluids) {
        NBTTagList list = new NBTTagList();
        for (FluidStack fluid : fluids) {
            if (fluid == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            fluid.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static FluidStack[] loadFluids(NBTTagList list) {
        FluidStack[] fluids = new FluidStack[list.func_74745_c()];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
        }
        return fluids;
    }

    public static InventoryCrafting craftingInventory(ItemStack[] grid, int size) {
        InventoryCrafting icr = new InventoryCrafting(CraftContDummy, size, size);
        int m = Math.min(grid.length, icr.func_70302_i_());
        for (int i = 0; i < m; ++i) {
            icr.func_70299_a(i, grid[i]);
        }
        return icr;
    }

    public static int transferItems(IItemHandler src, IItemHandler dst, IFilter<ItemStack, IItemHandler> extr, IFilter<ItemStack, IItemHandler> ins) {
        int m = 0;
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stack = src.extractItem(i, 65536, true);
            if (extr != null) {
                stack = extr.getExtract(stack, src);
            }
            if (stack == null || ins != null && (stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)ins.insertAmount(stack, dst))) == null) continue;
            int n = stack.field_77994_a;
            if ((stack = ItemHandlerHelper.insertItemStacked((IItemHandler)dst, (ItemStack)stack, (boolean)false)) != null) {
                n -= stack.field_77994_a;
            }
            src.extractItem(i, n, false);
            m += n;
        }
        return m;
    }

    public static int findStack(ItemStack item, IItemHandler inv, int p) {
        if (item == null) {
            return -1;
        }
        for (int i = p; i < inv.getSlots(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)inv.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack putInSlots(IItemHandler inv, ItemStack stack, int ... slots) {
        for (int s : slots) {
            if (inv.getStackInSlot(s) == null || (stack = inv.insertItem(s, stack, false)) != null) continue;
            return null;
        }
        for (int s : slots) {
            if (inv.getStackInSlot(s) != null || (stack = inv.insertItem(s, stack, false)) != null) continue;
            return null;
        }
        return stack;
    }

    public static int drain(IItemHandler inv, ItemStack item) {
        int n = item.field_77994_a;
        int m = 0;
        for (int i = 0; i < inv.getSlots() && m < n; ++i) {
            ItemStack stack;
            if (!item.func_77969_a(inv.getStackInSlot(i)) || (stack = inv.extractItem(i, n - m, false)) == null) continue;
            m += stack.field_77994_a;
        }
        return m;
    }

    public static int drain(IItemHandler inv, OreDictStack ore, ArrayList<ItemStack> buffer) {
        int n = ore.stacksize;
        int m = 0;
        for (int i = 0; i < inv.getSlots() && m < n; ++i) {
            ItemStack stack;
            if (!ore.isEqual(inv.getStackInSlot(i)) || (stack = inv.extractItem(i, n - m, false)) == null) continue;
            m += stack.field_77994_a;
            ItemFluidUtil.addToList(buffer, stack);
        }
        return m;
    }

    public static void addToList(ArrayList<ItemStack> list, ItemStack item) {
        for (ItemStack stack : list) {
            if (!item.func_77969_a(stack)) continue;
            stack.field_77994_a += item.field_77994_a;
            return;
        }
        list.add(item);
    }

    public static void addToList(ArrayList<FluidStack> list, FluidStack fluid) {
        for (FluidStack stack : list) {
            if (!fluid.isFluidEqual(stack)) continue;
            stack.amount += fluid.amount;
            return;
        }
        list.add(fluid);
    }

    public static ItemStack drain(IItemHandler inv, int am) {
        boolean mss;
        boolean bl = mss = am < 0;
        if (mss) {
            am = 65536;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, am, true);
            if (stack == null) continue;
            stack.field_77994_a = mss ? stack.func_77976_d() : am;
            stack.field_77994_a = ItemFluidUtil.drain(inv, stack);
            return stack;
        }
        return null;
    }

    public static class StackedFluidAccess
    implements IFluidHandler {
        public final IFluidHandler acc;
        private final ItemStack item;
        private final int n;

        public StackedFluidAccess(ItemStack item) {
            int n = this.n = item != null ? item.field_77994_a : 0;
            if (this.n > 0) {
                this.acc = FluidUtil.getFluidHandler((ItemStack)item);
                if (this.acc != null) {
                    item.field_77994_a = 1;
                }
                this.item = item;
            } else {
                this.acc = null;
                this.item = null;
            }
        }

        public boolean valid() {
            return this.acc != null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.acc.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.n > 1) {
                resource = new FluidStack(resource, resource.amount / this.n);
            }
            return this.acc.fill(resource, doFill) * this.n;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack stack;
            if (this.n > 1) {
                resource = new FluidStack(resource, resource.amount / this.n);
            }
            if ((stack = this.acc.drain(resource, doDrain)) != null) {
                stack.amount *= this.n;
            }
            return stack;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack stack = this.acc.drain(maxDrain / this.n, doDrain);
            if (stack != null) {
                stack.amount *= this.n;
            }
            return stack;
        }

        public ItemStack result() {
            this.item.field_77994_a *= this.n;
            return this.item.field_77994_a > 0 && this.item.func_77973_b() != null ? this.item : null;
        }
    }
}

