/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.templates.MultiblockComp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class SharedNetwork<C extends MultiblockComp<C, N>, N extends SharedNetwork<C, N>> {
    protected C core;
    public final HashMap<Long, C> components;
    public boolean update = false;
    private static final byte[] defaultSides = new byte[]{0, 1, 2, 3, 4, 5};
    private static final int spreader = 549568949;

    public SharedNetwork(C core) {
        this.components = new HashMap();
        this.components.put(((MultiblockComp)core).uid, core);
        this.core = core;
        ((MultiblockComp)core).network = this;
    }

    protected SharedNetwork(HashMap<Long, C> comps) {
        this.components = comps;
    }

    public abstract N onSplit(HashMap<Long, C> var1);

    public void onMerged(N network) {
        for (MultiblockComp c : ((SharedNetwork)network).components.values()) {
            c.network = this;
        }
        this.components.putAll(((SharedNetwork)network).components);
    }

    public void add(C comp) {
        if (((MultiblockComp)comp).network == this) {
            return;
        }
        if (((MultiblockComp)comp).invalid()) {
            ((MultiblockComp)comp).updateCon = true;
            return;
        }
        if (this.components.size() >= ((SharedNetwork)((MultiblockComp)comp).network).components.size()) {
            this.onMerged(((MultiblockComp)comp).network);
        } else {
            ((MultiblockComp)comp).network.onMerged((SharedNetwork)this);
        }
    }

    public void remove(C comp) {
        this.components.remove(((MultiblockComp)comp).uid);
        ((MultiblockComp)comp).network = null;
        if (this.core == comp) {
            this.core = null;
        }
        this.markDirty();
    }

    public void onDisconnect(C comp, byte side) {
        if (((MultiblockComp)comp).getNeighbor(side) != null) {
            this.markDirty();
        }
    }

    public void updateCompCon(C comp) {
        for (byte i : this.sides()) {
            Object obj;
            if (!((MultiblockComp)comp).canConnect(i) || (obj = ((MultiblockComp)comp).getNeighbor(i)) == null) continue;
            this.add(obj);
        }
        ((MultiblockComp)comp).updateCon = false;
    }

    public void updateTick(C comp) {
        if (((MultiblockComp)comp).updateCon) {
            this.updateCompCon(comp);
        }
        if (this.core == null) {
            this.core = comp;
        } else if (comp != this.core) {
            return;
        }
        this.updatePhysics();
        if (this.update) {
            this.reassembleNetwork();
            this.update = false;
        }
    }

    public void markDirty() {
        this.update = true;
    }

    protected void updatePhysics() {
    }

    protected byte[] sides() {
        return defaultSides;
    }

    protected void reassembleNetwork() {
        ArrayList queue = new ArrayList();
        while (this.components.size() > 1) {
            HashMap<Long, MultiblockComp> comps = new HashMap<Long, MultiblockComp>();
            queue.clear();
            queue.add(this.core);
            while (!queue.isEmpty()) {
                MultiblockComp obj = (MultiblockComp)queue.remove(queue.size() - 1);
                comps.put(obj.uid, obj);
                for (byte i : this.sides()) {
                    Object obj1;
                    if (!obj.canConnect(i) || (obj1 = obj.getNeighbor(i)) == null || comps.containsKey(((MultiblockComp)obj1).uid)) continue;
                    queue.add(obj1);
                }
            }
            if (comps.size() == this.components.size()) {
                return;
            }
            N network = this.onSplit(comps);
            for (Map.Entry e : comps.entrySet()) {
                ((MultiblockComp)e.getValue()).network = network;
                this.components.remove(e.getKey());
            }
            Iterator iterator = this.components.values().iterator();
            if (!iterator.hasNext()) continue;
            MultiblockComp c = (MultiblockComp)((Object)iterator.next());
            this.core = c;
        }
    }

    public static long ExtPosUID(BlockPos pos, int dimId) {
        return pos.func_177986_g() ^ (long)(dimId *= 549568949) << 32;
    }

    public static long SidedPosUID(long base, int side) {
        return base ^ (long)(side * 549568949);
    }
}

