/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryItem
implements IItemHandlerModifiable {
    private final InventoryPlayer ref;
    private final IItemInventory inv;
    private final ItemStack[] cache;

    public InventoryItem(EntityPlayer player) {
        this.ref = player.field_71071_by;
        ItemStack item = this.ref.field_70462_a[this.ref.field_70461_c];
        if (item == null || !(item.func_77973_b() instanceof IItemInventory)) {
            throw new IllegalArgumentException("Held item not InventoryItem compatible!");
        }
        this.inv = (IItemInventory)item.func_77973_b();
        this.cache = this.inv.loadInventory(item, player);
    }

    public int getSlots() {
        return this.cache.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.cache[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean sim) {
        ItemStack item = this.cache[slot];
        int m = Math.min(stack.func_77976_d() - (item == null ? 0 : item.field_77994_a), stack.field_77994_a);
        if (m <= 0 || item != null && !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) {
            return stack;
        }
        if (!sim) {
            if (item != null) {
                item.field_77994_a -= m;
            } else {
                item = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m);
            }
            this.setStackInSlot(slot, item);
        }
        return (m = stack.field_77994_a - m) > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean sim) {
        ItemStack item = this.getStackInSlot(slot);
        if (item == null) {
            return null;
        }
        int m = Math.min(item.field_77994_a, amount);
        if (!sim) {
            if (item.field_77994_a <= m) {
                this.setStackInSlot(slot, null);
            } else {
                item.field_77994_a -= m;
                this.setStackInSlot(slot, item);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)m);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.cache[slot] = stack;
        ItemStack item = this.ref.field_70462_a[this.ref.field_70461_c];
        if (item != null && item.func_77973_b() == this.inv) {
            this.inv.saveInventory(item, this.ref.field_70458_d, this.cache);
        }
    }

    public void update() {
        ItemStack item = this.ref.field_70462_a[this.ref.field_70461_c];
        if (item != null && item.func_77973_b() == this.inv) {
            ItemStack[] items = this.inv.loadInventory(item, this.ref.field_70458_d);
            System.arraycopy(items, 0, this.cache, 0, Math.min(this.cache.length, items.length));
        }
    }

    public static interface IItemInventory {
        public ItemStack[] loadInventory(ItemStack var1, EntityPlayer var2);

        public void saveInventory(ItemStack var1, EntityPlayer var2, ItemStack[] var3);
    }
}

