/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class Inventory
implements IItemHandlerModifiable {
    public static int ticks = 1;
    public long sideCfg = 0L;
    public final ItemStack[] items;
    public final Group[] groups;
    public final IAccessHandler handler;
    public int shift = 0;
    public int timer = 0;

    public Inventory(int l, int g, IAccessHandler handler) {
        if (g > 5 || g > l) {
            throw new IllegalArgumentException("Too many slot groups! " + g + " / " + (l < 5 ? l : 5));
        }
        this.items = new ItemStack[l];
        this.groups = new Group[g];
        this.handler = handler == null ? new DefaultAccessHandler() : handler;
    }

    public Inventory group(int i, int s, int e, int dir) {
        this.groups[i] = new Group(i, s, e, dir);
        return this;
    }

    public void update(AutomatedTile tile) {
        if (++this.timer < ticks) {
            return;
        }
        this.timer = 0;
        for (byte s = 0; s < 6; s = (byte)(s + 1)) {
            TileEntity te;
            int cfg = (int)(this.sideCfg >> (int)((long)(s * 10)));
            if ((cfg & 0x155) == (cfg & 0x2AA) >> 1 || (te = Utils.getTileOnSide(tile, s)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[s ^ 1])) continue;
            IItemHandler access = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[s ^ 1]);
            int g = 0;
            while (g < this.groups.length) {
                if ((cfg & 3) == 1 && this.groups[g].dir == -1) {
                    Inventory.transferStack(access, new Access(g), this.shift);
                } else if ((cfg & 3) == 2 && this.groups[g].dir == 1) {
                    Inventory.transferStack(new Access(g), access, this.shift);
                }
                ++g;
                cfg >>= 2;
            }
        }
        ++this.shift;
    }

    public static void transferStack(IItemHandler src, IItemHandler dest, int shift) {
        int i;
        int i2;
        int slot = -1;
        int empty = -1;
        ItemStack item = null;
        int ls = src.getSlots();
        for (i2 = 0; i2 < ls && (item = src.extractItem(slot = (i2 + shift) % ls, 65536, true)) == null; ++i2) {
        }
        if (item == null) {
            return;
        }
        if (slot >= (ls = shift % ls)) {
            for (i2 = 0; i2 < ls; ++i2) {
                ItemStack stack;
                if (!item.func_77969_a(src.getStackInSlot(i2)) || (stack = src.extractItem(i2, 65536, true)) == null) continue;
                slot = i2;
                item = stack;
                break;
            }
        }
        int n = item.field_77994_a;
        int ld = dest.getSlots();
        for (i = 0; i < ld; ++i) {
            if (dest.getStackInSlot(i) == null) {
                empty = empty < 0 ? i : empty;
                continue;
            }
            if ((item = dest.insertItem(i, item, false)) == null) break;
        }
        if (empty >= 0 && item != null) {
            for (i = empty; i < ld && (dest.getStackInSlot(i) != null || (item = dest.insertItem(i, item, false)) != null); ++i) {
            }
        }
        if (item != null) {
            n -= item.field_77994_a;
        }
        if (n > 0) {
            src.extractItem(slot, n, false);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74772_a(name + "Cfg", this.sideCfg);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.items[i].func_77955_b(tag);
            nbt.func_74782_a(name + Integer.toHexString(i), (NBTBase)tag);
        }
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.sideCfg = nbt.func_74763_f(name + "Cfg");
        for (int i = 0; i < this.items.length; ++i) {
            String tagName = name + Integer.toHexString(i);
            this.items[i] = nbt.func_150297_b(tagName, 10) ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(tagName)) : null;
        }
    }

    public byte getConfig(int s, int id) {
        if (s >= 0) {
            return (byte)(this.sideCfg >> 10 * s + 2 * id & 3L);
        }
        if (id < 0 || id >= this.groups.length) {
            return 0;
        }
        byte dir = this.groups[id].dir;
        return (byte)(dir < 0 ? 1 : (dir > 0 ? 2 : 3));
    }

    public int getSlots() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int i) {
        return this.items[i];
    }

    public ItemStack insertItem(int i, ItemStack stack, boolean sim) {
        ItemStack item = this.items[i];
        int m = this.handler.insertAm(-1, i, item, stack);
        if (m <= 0) {
            return stack;
        }
        if (!sim) {
            if (item == null) {
                item = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m);
            } else {
                item.field_77994_a += m;
            }
            this.handler.setSlot(-1, i, item);
        }
        return (m = stack.field_77994_a - m) > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m) : null;
    }

    public ItemStack extractItem(int i, int m, boolean sim) {
        ItemStack item = this.items[i];
        if ((m = this.handler.extractAm(-1, i, item, m)) <= 0) {
            return null;
        }
        if (!sim) {
            if (item.field_77994_a <= m) {
                this.handler.setSlot(-1, i, null);
            } else {
                item.field_77994_a -= m;
                this.handler.setSlot(-1, i, item);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)m);
    }

    public void setStackInSlot(int i, ItemStack stack) {
        this.handler.setSlot(-1, i, stack);
    }

    public void dropItems(ModTileEntity te, int s0, int s1) {
        for (int i = s0; i < s1; ++i) {
            te.dropStack(this.items[i]);
        }
    }

    public class DefaultAccessHandler
    implements IAccessHandler {
        @Override
        public int insertAm(int g, int s, ItemStack item, ItemStack insert) {
            int m = Math.min(insert.func_77976_d() - (item == null ? 0 : item.field_77994_a), insert.field_77994_a);
            return item == null || ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)insert) ? m : 0;
        }

        @Override
        public int extractAm(int g, int s, ItemStack item, int extract) {
            return item == null ? 0 : (item.field_77994_a < extract ? item.field_77994_a : extract);
        }

        @Override
        public void setSlot(int g, int s, ItemStack item) {
            Inventory.this.items[s] = item;
        }
    }

    public static interface IAccessHandler {
        public int insertAm(int var1, int var2, ItemStack var3, ItemStack var4);

        public int extractAm(int var1, int var2, ItemStack var3, int var4);

        public void setSlot(int var1, int var2, ItemStack var3);
    }

    public class Access
    implements IItemHandler {
        final int[] slots;
        final byte[] dir;

        public Access(EnumFacing s) {
            int cfg = s != null ? (int)(Inventory.this.sideCfg >> s.ordinal() * 10) & 0x3FF : 1023;
            int n = 0;
            for (Group g : Inventory.this.groups) {
                if ((cfg >> 2 * g.idx & 3) == 0) continue;
                n += g.e - g.s;
            }
            this.slots = new int[n];
            this.dir = new byte[n];
            n = 0;
            for (Group g : Inventory.this.groups) {
                if ((cfg & 3) != 0) {
                    byte d = (byte)(g.idx | cfg << 6);
                    int i = g.s;
                    while (i < g.e) {
                        this.slots[n] = i++;
                        this.dir[n++] = d;
                    }
                }
                cfg >>= 2;
            }
        }

        public Access(int g) {
            Group group = Inventory.this.groups[g];
            this.slots = new int[group.e - group.s];
            this.dir = new byte[this.slots.length];
            byte d = (byte)(g | 0xC0);
            int i = group.s;
            int n = 0;
            while (i < group.e) {
                this.slots[n] = i++;
                this.dir[n] = d;
                ++n;
            }
        }

        public int getSlots() {
            return this.slots.length;
        }

        public ItemStack getStackInSlot(int i) {
            return Inventory.this.items[this.slots[i]];
        }

        public ItemStack insertItem(int i, ItemStack stack, boolean sim) {
            ItemStack item;
            int s;
            int m;
            byte d = this.dir[i];
            if ((d & 0x40) == 0 || (m = Inventory.this.handler.insertAm(d & 7, s = this.slots[i], item = Inventory.this.items[s], stack)) <= 0) {
                return stack;
            }
            if (!sim) {
                if (item == null) {
                    item = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m);
                } else {
                    item.field_77994_a += m;
                }
                Inventory.this.handler.setSlot(d & 0x47, s, item);
            }
            return (m = stack.field_77994_a - m) > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m) : null;
        }

        public ItemStack extractItem(int i, int m, boolean sim) {
            ItemStack item;
            int s;
            byte d = this.dir[i];
            if ((d & 0x80) == 0 || (m = Inventory.this.handler.extractAm(d & 7, s = this.slots[i], item = Inventory.this.items[s], m)) <= 0) {
                return null;
            }
            if (!sim) {
                if (item.field_77994_a == m) {
                    Inventory.this.handler.setSlot(d & 0x87, s, null);
                } else {
                    item.field_77994_a -= m;
                    Inventory.this.handler.setSlot(d & 0x87, s, item);
                }
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)m);
        }
    }

    public class SlotAccess
    implements IItemHandlerModifiable {
        final int ofs;
        final int size;

        public SlotAccess(int ofs, int size) {
            this.ofs = ofs;
            this.size = size;
        }

        public int getSlots() {
            return this.size;
        }

        public ItemStack getStackInSlot(int slot) {
            return Inventory.this.getStackInSlot(slot + this.ofs);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return Inventory.this.insertItem(slot + this.ofs, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return Inventory.this.extractItem(slot + this.ofs, amount, simulate);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            Inventory.this.setStackInSlot(slot + this.ofs, stack);
        }
    }

    public class Group {
        public final int idx;
        public final int s;
        public final int e;
        public final byte dir;

        private Group(int idx, int s, int e, int d) {
            this.idx = idx;
            this.s = s;
            this.e = e;
            this.dir = (byte)d;
        }
    }
}

