/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.TileBlock;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.PropertyBlock;
import cd4017be.lib.util.PropertyByte;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockPipe
extends TileBlock {
    public static final PropertyByte[] CONS = new PropertyByte[6];
    public static final PropertyByte CORE = new PropertyByte("core");
    public static final PropertyBlock COVER = new PropertyBlock("cover");
    public static final IUnlistedProperty[] RENDER_PROPS;
    public float size = 0.25f;

    public BlockPipe(String id, Material m, SoundType sound, int type) {
        super(id, m, sound, type);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        ArrayList<IProperty> main = new ArrayList<IProperty>();
        this.addProperties(main);
        return new ExtendedBlockState((Block)this, main.toArray(new IProperty[main.size()]), RENDER_PROPS);
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe) {
            IPipe pipe = (IPipe)te;
            state = state.withProperty((IUnlistedProperty)CORE, (Object)((byte)pipe.textureForSide((byte)-1)));
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                state = state.withProperty((IUnlistedProperty)CONS[i], (Object)((byte)pipe.textureForSide(i)));
            }
            IPipe.Cover cover = pipe.getCover();
            if (cover != null) {
                state = state.withProperty((IUnlistedProperty)COVER, (Object)cover.block.func_177230_c().getExtendedState(cover.block, world, pos));
            }
            return state;
        }
        return state.withProperty((IUnlistedProperty)CORE, (Object)((byte)this.func_176201_c(oldState)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && ((IPipe)te).getCover() == null) {
            return this.outerBox((IPipe)te);
        }
        return field_185505_j;
    }

    private AxisAlignedBB outerBox(IPipe pipe) {
        double f1 = (1.0 - (double)this.size) / 2.0;
        double f2 = (1.0 + (double)this.size) / 2.0;
        double[] bb = new double[]{f1, f2, f1, f2, f1, f2};
        for (byte s = 0; s < 6; s = (byte)(s + 1)) {
            if (pipe.textureForSide(s) == -1) continue;
            bb[s] = s & 1;
        }
        return new AxisAlignedBB(bb[4], bb[0], bb[2], bb[5], bb[1], bb[3]);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB area, List<AxisAlignedBB> list, Entity entity) {
        double d1;
        double z;
        double d0;
        double y;
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof IPipe) || ((IPipe)te).getCover() != null) {
            AxisAlignedBB box = field_185505_j.func_186670_a(pos);
            if (area.func_72326_a(box)) {
                list.add(box);
            }
            return;
        }
        AxisAlignedBB box0 = this.outerBox((IPipe)te);
        double x = pos.func_177958_n();
        AxisAlignedBB box = new AxisAlignedBB(x + box0.field_72340_a, (y = (double)pos.func_177956_o()) + (d0 = (double)((1.0f - this.size) / 2.0f)), (z = (double)pos.func_177952_p()) + d0, x + box0.field_72336_d, y + (d1 = (double)((1.0f + this.size) / 2.0f)), z + d1);
        if (box.func_72326_a(area)) {
            list.add(box);
        }
        if ((box0.field_72338_b < d0 || box0.field_72337_e > d1) && (box = new AxisAlignedBB(x + d0, y + box0.field_72338_b, z + d0, x + d1, y + box0.field_72337_e, z + d1)).func_72326_a(area)) {
            list.add(box);
        }
        if ((box0.field_72339_c < d0 || box0.field_72334_f > d1) && (box = new AxisAlignedBB(x + d0, y + d0, z + box0.field_72339_c, x + d1, y + d1, z + box0.field_72334_f)).func_72326_a(area)) {
            list.add(box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d v0, Vec3d v1) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        this.func_185477_a(state, world, pos, field_185505_j.func_186670_a(pos), boxes, null);
        RayTraceResult rayTrace = null;
        for (AxisAlignedBB box : boxes) {
            rayTrace = box.func_72327_a(v0, v1);
            if (rayTrace == null) continue;
            return new RayTraceResult(rayTrace.field_72307_f, rayTrace.field_178784_b, pos);
        }
        return null;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof IPipe && ((IPipe)te).getCover() != null;
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.redstone) {
            return true;
        }
        return this.isNormalCube(state, world, pos);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(world.func_180495_p(pos), world, pos);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IPipe.Cover cover;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null) {
            return cover.block.func_185914_p();
        }
        return false;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        IPipe.Cover cover;
        float h = this.field_149782_v;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null) {
            float h1 = cover.block.func_185887_b(world, new BlockPos(0, -1, 0));
            h = h1 < 0.0f ? -1.0f : (h += h1);
        }
        return h;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity ex, Explosion expl) {
        Block block;
        IPipe.Cover cover;
        float h = this.func_149638_a(ex);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null && (block = cover.block.func_177230_c()) != null) {
            h += block.func_149638_a(ex);
        }
        return h;
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isNormalCube(state, world, pos) ? 255 : 0;
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(CORE);
        for (int i = 0; i < 6; ++i) {
            BlockPipe.CONS[i] = new PropertyByte("con" + i);
            list.add(CONS[i]);
        }
        list.add(COVER);
        RENDER_PROPS = list.toArray(new IUnlistedProperty[list.size()]);
    }
}

