/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Compiler;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Script;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ScriptFiles {
    public static Script[] createCompiledPackage(File out) {
        File[] files = out.getParentFile().listFiles();
        ArrayList<File> in = new ArrayList<File>();
        for (File f : files) {
            if (!f.getName().endsWith(".rcp")) continue;
            in.add(f);
        }
        if (in.isEmpty()) {
            System.out.println("no valid files found!");
            return null;
        }
        try {
            long t = System.currentTimeMillis();
            System.out.printf("Compiling %d scripts:\n", in.size());
            Script[] scripts = new Script[in.size()];
            for (int i = 0; i < scripts.length; ++i) {
                File file = (File)in.get(i);
                String name = file.getName();
                name = name.substring(0, name.length() - 4);
                System.out.print(name + " ");
                Compiler c = new Compiler(name, Compiler.parse(name, new FileReader(file)));
                System.out.print("> parsed ");
                Script script = c.compile();
                System.out.println("> compiled");
                script.editDate = file.lastModified();
                scripts[i] = script;
            }
            ScriptFiles.saveCompiledPackage(out, scripts);
            t = System.currentTimeMillis() - t;
            System.out.printf("done in %.3f s", Float.valueOf((float)t / 1000.0f));
            return scripts;
        }
        catch (Exception e) {
            System.out.println("> failed: " + e.getClass().getName() + "\n" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCompiledPackage(File out, Script[] scripts) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(out));){
            System.out.printf("Saving %d scripts:\n", scripts.length);
            dos.writeByte(scripts.length);
            for (Script s : scripts) {
                dos.writeUTF(s.fileName);
                dos.writeLong(s.editDate);
                dos.writeInt(s.version);
            }
            for (Script s : scripts) {
                System.out.printf("> %s: v. %d, const %d, func %d\n", s.fileName, s.version, s.variables.size(), s.methods.size());
                dos.writeShort(s.variables.size());
                for (Map.Entry<String, Object> entry : s.variables.entrySet()) {
                    dos.writeUTF(entry.getKey());
                    Object v = entry.getValue();
                    if (v instanceof Boolean) {
                        dos.writeByte((Boolean)v != false ? 2 : 1);
                        continue;
                    }
                    if (v instanceof Double) {
                        dos.writeByte(3);
                        dos.writeDouble((Double)v);
                        continue;
                    }
                    if (v instanceof String) {
                        dos.writeByte(4);
                        dos.writeUTF((String)v);
                        continue;
                    }
                    dos.writeByte(0);
                }
                dos.writeShort(s.methods.size());
                for (Map.Entry<String, Object> entry : s.methods.entrySet()) {
                    dos.writeUTF(entry.getKey());
                    Function f = (Function)entry.getValue();
                    System.out.printf("- %s: par %d, stack %d, ret %b, size %d bytes\n", entry.getKey(), f.Nparam, f.Nstack, f.hasReturn, f.size());
                    f.writeData(dos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script[] loadPackage(File in, HashMap<String, Version> versions, boolean check) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(in));){
            File dir = in.getParentFile();
            Script[] scripts = new Script[dis.readByte() & 0xFF];
            boolean outdated = false;
            for (int i = 0; i < scripts.length; ++i) {
                String name = dis.readUTF();
                Script s = new Script(name, new HashMap<String, Function>(), new HashMap<String, Object>());
                s.editDate = dis.readLong();
                File f = new File(dir, name + ".rcp");
                outdated |= f.exists() && s.editDate < f.lastModified();
                s.version = dis.readInt();
                Version v = versions.get(name);
                if (v != null && s.version >= v.version) {
                    versions.remove(name);
                }
                scripts[i] = s;
            }
            if (check && (outdated || !versions.isEmpty())) {
                Script[] scriptArray = null;
                return scriptArray;
            }
            for (Script s : scripts) {
                String name;
                int i;
                int n = dis.readShort();
                for (i = 0; i < n; ++i) {
                    Object obj;
                    name = dis.readUTF();
                    switch (dis.readByte()) {
                        case 0: {
                            obj = null;
                            break;
                        }
                        case 1: {
                            obj = false;
                            break;
                        }
                        case 2: {
                            obj = true;
                            break;
                        }
                        case 3: {
                            obj = dis.readDouble();
                            break;
                        }
                        case 4: {
                            obj = dis.readUTF();
                            break;
                        }
                        default: {
                            Script[] scriptArray = null;
                            return scriptArray;
                        }
                    }
                    s.variables.put(name, obj);
                }
                n = dis.readShort();
                for (i = 0; i < n; ++i) {
                    name = dis.readUTF();
                    Function f = new Function(s.fileName + "." + name, dis);
                    s.methods.put(name, f);
                    f.script = s;
                }
            }
            Script[] scriptArray = scripts;
            return scriptArray;
        }
    }

    public static class Version {
        public final int version;
        public final String fallback;
        public final String name;

        public Version(String name, int version, String fallback) {
            this.name = name;
            this.version = version;
            this.fallback = fallback;
        }

        public Version(String name) {
            this(name, 0, null);
        }
    }
}

