/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.util.ScriptCompiler;
import cd4017be.lib.util.Vec2;
import cd4017be.lib.util.VecN;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TESRModelParser
extends ScriptCompiler {
    private static final VecN defaultVertex = new VecN(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    private static final String defaultFormat = "xyzuvrgba";
    private static final int maxStates = 8;
    ArrayList<State> states = new ArrayList();
    ArrayList<Quad> quads = new ArrayList();
    private static final boolean[][] rect = new boolean[][]{{false, false, true, true}, {false, true, true, false}};

    private TESRModelParser(HashMap<String, Object> variables, State init) {
        super(variables);
        this.states = new ArrayList();
        this.states.add(init);
    }

    @Override
    protected String[] methods() {
        return new String[]{"draw", "push", "pop", "rotate", "translate", "scale", "offsetUV", "scaleUV", "color"};
    }

    @Override
    protected void runMethod(int i, Object[] param, int line) throws ScriptCompiler.CompileException {
        switch (i) {
            case 0: {
                Object o = param[0];
                State state = this.states.get(this.states.size() - 1);
                if (o instanceof Quad) {
                    this.quads.add(((Quad)o).transform(state));
                    break;
                }
                if (o instanceof TESRModelParser) {
                    for (Quad quad : ((TESRModelParser)o).quads) {
                        this.quads.add(quad.transform(state));
                    }
                } else {
                    if (!(o instanceof Object[])) break;
                    for (Object o1 : (Object[])o) {
                        this.quads.add(((Quad)o1).transform(state));
                    }
                }
                break;
            }
            case 1: {
                if (this.states.size() >= 8) {
                    throw new ScriptCompiler.CompileException("max state depth reached", "push", line);
                }
                this.states.add(this.states.get(this.states.size() - 1).copy());
                break;
            }
            case 2: {
                if (this.states.size() <= 1) {
                    throw new ScriptCompiler.CompileException("already at origin state", "pop", line);
                }
                this.states.remove(this.states.size() - 1);
                break;
            }
            case 3: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                vec.x[3] = Math.toRadians(vec.x[3]);
                Matrix4d mat = new Matrix4d();
                mat.set(new AxisAngle4d(vec.x));
                state.matrix.mul(mat);
                break;
            }
            case 4: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                Matrix4d mat = new Matrix4d();
                mat.set(new Vector3d(vec.x));
                state.matrix.mul(mat);
                break;
            }
            case 5: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                Matrix4d mat = new Matrix4d();
                mat.setM00(vec.x[0]);
                mat.setM11(vec.x[1]);
                mat.setM22(vec.x[2]);
                state.matrix.mul(mat);
                break;
            }
            case 6: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                state.uvOffset = state.uvOffset.add(vec.x[0] * state.uvScale.x, vec.x[1] * state.uvScale.z);
                break;
            }
            case 7: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                state.uvScale = state.uvScale.scale(vec.x[0], vec.x[1]);
                break;
            }
            case 8: {
                VecN vec = (VecN)param[0];
                State state = this.states.get(this.states.size() - 1);
                for (int j = 0; j < vec.x.length; ++j) {
                    state.color.x[j] = vec.x[j];
                }
                break;
            }
        }
    }

    @Override
    protected String[] functions() {
        return new String[]{"quad", "rect"};
    }

    @Override
    protected Object runFunction(int c, Object[] param, int line) throws ScriptCompiler.CompileException {
        switch (c) {
            case 0: {
                Quad quad = new Quad();
                String format = (String)param[4];
                if (format == null) {
                    format = defaultFormat;
                }
                for (int i = 0; i < 4; ++i) {
                    VecN vec = (VecN)param[i];
                    quad.vertices[i] = defaultVertex.copy();
                    int n = 0;
                    for (int j = 0; j < format.length(); ++j) {
                        int p = defaultFormat.indexOf(format.charAt(j));
                        if (p < 0) continue;
                        quad.vertices[i].x[p] = vec.x[n++];
                    }
                }
                return quad;
            }
            case 1: {
                Quad quad = new Quad();
                VecN pos = (VecN)param[0];
                VecN tex = (VecN)param[1];
                String format = (String)param[2];
                int t = format.indexOf(45);
                int tN = t < 0 ? format.indexOf(43) + 3 : t;
                boolean inv = tN >= 3;
                tN %= 3;
                t = format.indexOf(117);
                int tU = t < 0 ? format.indexOf(85) + 3 : t;
                t = format.indexOf(118);
                int tV = t < 0 ? format.indexOf(86) + 3 : t;
                for (int i = 0; i < 4; ++i) {
                    VecN vert = defaultVertex.copy();
                    vert.x[0] = pos.x[(tN == 0 ? inv : rect[tN - 1][i]) ? 3 : 0];
                    vert.x[1] = pos.x[(tN == 1 ? inv : rect[(tN + 1) % 3][i]) ? 4 : 1];
                    vert.x[2] = pos.x[(tN == 2 ? inv : rect[tN][i]) ? 5 : 2];
                    vert.x[3] = tex.x[tU >= 3 ^ rect[(5 - tU + tN) % 3][i] ? 2 : 0];
                    vert.x[4] = tex.x[tV >= 3 ^ rect[(5 - tV + tN) % 3][i] ? 3 : 1];
                    quad.vertices[inv ? i : 3 - i] = vert;
                }
                return quad;
            }
        }
        return null;
    }

    @Override
    protected Object indexArray(Object array, String index, int recLimit, int line) throws ScriptCompiler.CompileException {
        return null;
    }

    @Override
    public ScriptCompiler extScript(HashMap<String, Object> var, String filename, int reclimit) throws ScriptCompiler.CompileException {
        ScriptCompiler.SubMethod m;
        State state = new State();
        state.matrix = new Matrix4d();
        state.matrix.setIdentity();
        state.uvOffset = Vec2.Def(0.0, 0.0);
        state.uvScale = Vec2.Def(1.0, 1.0);
        state.color = new VecN(1.0, 1.0, 1.0, 1.0);
        TESRModelParser model = new TESRModelParser(var, state);
        ResourceLocation res = new ResourceLocation(filename + ".tesr");
        try {
            m = new ScriptCompiler.SubMethod(SpecialModelLoader.instance.loadTESRModelSourceCode(res), res);
        }
        catch (IOException e) {
            throw ScriptCompiler.CompileException.of(e, filename + ".tesr", 0);
        }
        model.run(m, reclimit);
        model.states.clear();
        return model;
    }

    public static int[] bake(String code, ResourceLocation res) throws ScriptCompiler.CompileException {
        State state = new State();
        state.matrix = new Matrix4d();
        state.matrix.setIdentity();
        state.uvOffset = Vec2.Def(0.0, 0.0);
        state.uvScale = Vec2.Def(1.0, 1.0);
        state.color = new VecN(1.0, 1.0, 1.0, 1.0);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        TESRModelParser model = new TESRModelParser(variables, state);
        model.run(new ScriptCompiler.SubMethod(code, res), 16);
        int[] data = new int[28 * model.quads.size()];
        for (int i = 0; i < model.quads.size(); ++i) {
            Quad quad = model.quads.get(i);
            for (int j = 0; j < 4; ++j) {
                int p = i * 28 + j * 7;
                data[p] = Float.floatToIntBits((float)quad.vertices[j].x[0]);
                data[p + 1] = Float.floatToIntBits((float)quad.vertices[j].x[1]);
                data[p + 2] = Float.floatToIntBits((float)quad.vertices[j].x[2]);
                int r = MathHelper.func_76125_a((int)((int)(quad.vertices[j].x[5] * 255.0)), (int)0, (int)255);
                int g = MathHelper.func_76125_a((int)((int)(quad.vertices[j].x[6] * 255.0)), (int)0, (int)255);
                int b = MathHelper.func_76125_a((int)((int)(quad.vertices[j].x[7] * 255.0)), (int)0, (int)255);
                int a = MathHelper.func_76125_a((int)((int)(quad.vertices[j].x[8] * 255.0)), (int)0, (int)255);
                data[p + 3] = a << 24 | r << 16 | g << 8 | b;
                data[p + 4] = Float.floatToIntBits((float)quad.vertices[j].x[3]);
                data[p + 5] = Float.floatToIntBits((float)quad.vertices[j].x[4]);
                data[p + 6] = 0xF000F0;
            }
        }
        return data;
    }

    public static void renderWithOffsetAndBrightness(VertexBuffer render, String model, float dx, float dy, float dz, int l) {
        int[] data = SpecialModelLoader.instance.tesrModelData.get(model);
        if (data == null) {
            return;
        }
        int[] res = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            res[i] = Float.floatToIntBits(dx + Float.intBitsToFloat(data[i]));
            res[++i] = Float.floatToIntBits(dy + Float.intBitsToFloat(data[i]));
            res[++i] = Float.floatToIntBits(dz + Float.intBitsToFloat(data[i]));
            res[++i] = data[i];
            res[++i] = data[i];
            res[++i] = data[i];
            res[++i] = l;
        }
        render.func_178981_a(res);
    }

    public static void renderWithTOCB(VertexBuffer render, String model, TextureAtlasSprite tex, float dx, float dy, float dz, int c, int l) {
        int[] data = SpecialModelLoader.instance.tesrModelData.get(model);
        if (data == null) {
            return;
        }
        int[] res = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            res[i] = Float.floatToIntBits(dx + Float.intBitsToFloat(data[i]));
            res[++i] = Float.floatToIntBits(dy + Float.intBitsToFloat(data[i]));
            res[++i] = Float.floatToIntBits(dz + Float.intBitsToFloat(data[i]));
            res[++i] = c;
            res[++i] = Float.floatToIntBits(tex.func_94214_a((double)Float.intBitsToFloat(data[i])));
            res[++i] = Float.floatToIntBits(tex.func_94207_b((double)Float.intBitsToFloat(data[i])));
            res[++i] = l;
        }
        render.func_178981_a(res);
    }

    private static class Quad {
        VecN[] vertices = new VecN[4];

        private Quad() {
        }

        Quad transform(State state) {
            Quad quad = new Quad();
            for (int i = 0; i < 4; ++i) {
                Point3d vec = new Point3d(this.vertices[i].x[0], this.vertices[i].x[1], this.vertices[i].x[2]);
                Vec2 uv = state.uvScale.scale(this.vertices[i].x[3], this.vertices[i].x[4]).add(state.uvOffset);
                VecN c = state.color.scale(this.vertices[i].x[5], this.vertices[i].x[6], this.vertices[i].x[7], this.vertices[i].x[8]);
                state.matrix.transform(vec);
                quad.vertices[i] = new VecN(vec.x, vec.y, vec.z, uv.x, uv.z, c.x[0], c.x[1], c.x[2], c.x[3]);
            }
            return quad;
        }
    }

    private static class State {
        Matrix4d matrix;
        Vec2 uvOffset;
        Vec2 uvScale;
        VecN color;

        private State() {
        }

        State copy() {
            State state = new State();
            state.matrix = new Matrix4d(this.matrix);
            state.uvOffset = this.uvOffset.copy();
            state.uvScale = this.uvScale.copy();
            state.color = this.color.copy();
            return state;
        }
    }
}

