/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.render.TESRModelParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class SpecialModelLoader
implements ICustomModelLoader {
    public static final SpecialModelLoader instance = new SpecialModelLoader();
    public static final StateMapper stateMapper = new StateMapper();
    private static String mod = "";
    public HashMap<ResourceLocation, IModel> models = new HashMap();
    public HashSet<String> mods = new HashSet();
    public HashSet<String> tesrRegistry = new HashSet();
    private HashMap<ResourceLocation, String> tesrModelCode = new HashMap();
    public HashMap<String, int[]> tesrModelData = new HashMap();
    private IResourceManager resourceManager;

    public static void setMod(String name) {
        mod = name;
        SpecialModelLoader.instance.mods.add(name);
    }

    public static void registerFluid(Fluid fluid) {
        Block block = fluid.getBlock();
        if (block == null || !mod.equals(block.getRegistryName().func_110624_b())) {
            return;
        }
        ModelFluid model = new ModelFluid(fluid);
        SpecialModelLoader.instance.models.put(new ResourceLocation(mod, "models/block/" + fluid.getName()), (IModel)model);
        ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)stateMapper);
    }

    public static void registerBlockModel(Block block, IModel model) {
        String[] name = block.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/block/" + name[1]), model);
    }

    public static void registerItemModel(Item item, IModel model) {
        String[] name = item.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/item/" + name[1]), model);
    }

    public static void registerTESRModel(String path) {
        SpecialModelLoader.instance.tesrRegistry.add(path);
    }

    private SpecialModelLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String loadTESRModelSourceCode(ResourceLocation res) throws IOException {
        int n;
        String code = this.tesrModelCode.get(res);
        if (code != null) {
            return code;
        }
        InputStreamReader isr = new InputStreamReader(this.resourceManager.func_110536_a(res).func_110527_b());
        String s = "";
        char[] buff = new char[256];
        while ((n = isr.read(buff)) > 0) {
            s = s + String.valueOf(buff, 0, n);
        }
        this.tesrModelCode.put(res, s);
        return s;
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        this.tesrModelData.clear();
        for (String s : this.tesrRegistry) {
            try {
                ResourceLocation res = new ResourceLocation(s + ".tesr");
                String code = this.loadTESRModelSourceCode(res);
                this.tesrModelData.put(s, TESRModelParser.bake(code, res));
            }
            catch (Exception e) {
                FMLLog.log((String)"cd4017be_lib", (Level)Level.ERROR, (Throwable)e, (String)"unable to load TESR model %s :", (Object[])new Object[]{s});
            }
        }
        this.tesrModelCode.clear();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.mods.contains(modelLocation.func_110624_b()) && this.models.containsKey(modelLocation);
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        return this.models.get(modelLocation);
    }

    public static class StateMapper
    implements IStateMapper {
        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
            ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), "normal");
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                map.put(state, loc);
            }
            return map;
        }
    }
}

