/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.templates.BlockPipe;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelPipe
implements IModel {
    public final IBakedModel[] models;
    public final ResourceLocation[] dependencies;
    public final int Ncores;
    public final int Ncons;
    public final String path;

    public ModelPipe(String path, int Ncores, int Ncons) {
        int i;
        this.path = path;
        this.Ncores = Ncores;
        this.Ncons = Ncons;
        this.dependencies = new ResourceLocation[Ncores + Ncons];
        this.models = new IBakedModel[Ncores + 6 * Ncons];
        for (i = 0; i < Ncores; ++i) {
            this.dependencies[i] = new ModelResourceLocation(path, "core" + i);
        }
        for (i = 0; i < Ncons; ++i) {
            this.dependencies[Ncores + i] = new ModelResourceLocation(path, "con" + i);
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Object[])this.dependencies);
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        for (int i = 0; i < this.dependencies.length; ++i) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.dependencies[i], (String)"missing pipe model component:");
            if (i < this.Ncores) {
                this.models[i] = model.bake(state, format, bakedTextureGetter);
                continue;
            }
            int j = (i - this.Ncores) * 6 + this.Ncores;
            this.models[j] = model.bake((IModelState)ModelRotation.X90_Y0, format, bakedTextureGetter);
            this.models[j + 1] = model.bake((IModelState)ModelRotation.X270_Y0, format, bakedTextureGetter);
            this.models[j + 2] = model.bake((IModelState)ModelRotation.X0_Y0, format, bakedTextureGetter);
            this.models[j + 3] = model.bake((IModelState)ModelRotation.X0_Y180, format, bakedTextureGetter);
            this.models[j + 4] = model.bake((IModelState)ModelRotation.X0_Y270, format, bakedTextureGetter);
            this.models[j + 5] = model.bake((IModelState)ModelRotation.X0_Y90, format, bakedTextureGetter);
        }
        return new BakedPipe();
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public class BakedPipe
    implements IBakedModel {
        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return ModelPipe.this.models[0].func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exts = (IExtendedBlockState)state;
                IBlockState block = (IBlockState)exts.getValue((IUnlistedProperty)BlockPipe.COVER);
                if (block != null) {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(block);
                    return model.func_188616_a(block, side, rand);
                }
                Byte type = (Byte)exts.getValue((IUnlistedProperty)BlockPipe.CORE);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                if (type != null && type >= 0 && type < ModelPipe.this.Ncores) {
                    quads.addAll(ModelPipe.this.models[type].func_188616_a(state, side, rand));
                }
                for (int i = 0; i < 6; ++i) {
                    type = (Byte)exts.getValue((IUnlistedProperty)BlockPipe.CONS[i]);
                    if (type == null || type < 0 || type >= ModelPipe.this.Ncons) continue;
                    quads.addAll(ModelPipe.this.models[ModelPipe.this.Ncores + i + type * 6].func_188616_a(state, side, rand));
                }
                return quads;
            }
            return Collections.emptyList();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

