/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;

public class TooltipInfo {
    private static String ShiftHint;
    private static String AltHint;
    private static String FluidDispUnit;
    private static String EnergyDispUnit;
    private static String PowerDispUnit;
    private static String LinkPosFormat;
    public static String[] sides;
    private static final ArrayList<ConfigurationFile> configurations;

    public static String getShiftHint() {
        if (ShiftHint == null && (ShiftHint = I18n.func_74838_a((String)"cd4017be.shiftHint")) == "cd4017be.shiftHint") {
            ShiftHint = "<SHIFT for info>";
        }
        return ShiftHint;
    }

    public static String getAltHint() {
        if (AltHint == null && (AltHint = I18n.func_74838_a((String)"cd4017be.altHint")) == "cd4017be.altHint") {
            AltHint = "<ALT for extra>";
        }
        return AltHint;
    }

    public static String getFluidUnit() {
        if (FluidDispUnit == null && (FluidDispUnit = I18n.func_74838_a((String)"cd4017be.fluidUnit")) == "cd4017be.fluidUnit") {
            FluidDispUnit = "B";
        }
        return FluidDispUnit;
    }

    public static String getEnergyUnit() {
        if (EnergyDispUnit == null && (EnergyDispUnit = I18n.func_74838_a((String)"cd4017be.energyUnit")) == "cd4017be.energyUnit") {
            EnergyDispUnit = "kJ";
        }
        return EnergyDispUnit;
    }

    public static String getPowerUnit() {
        if (PowerDispUnit == null && (PowerDispUnit = I18n.func_74838_a((String)"cd4017be.powerUnit")) == "cd4017be.powerUnit") {
            PowerDispUnit = "kW";
        }
        return PowerDispUnit;
    }

    public static String formatLink(BlockPos pos, EnumFacing side) {
        if (LinkPosFormat == null && (LinkPosFormat = I18n.func_74838_a((String)"cd4017be.linkPos")) == "cd4017be.linkPos") {
            LinkPosFormat = "Link: x=%d y=%d z=%d %s";
        }
        return String.format(LinkPosFormat, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side != null ? sides[side.ordinal()] : "");
    }

    public static void addConfigReference(ConfigurationFile cfg) {
        configurations.add(cfg);
    }

    private static String formatReference(String id, ConfigurationFile cfg) {
        if (id.startsWith("A")) {
            try {
                int p = id.indexOf(":");
                String k = id.substring(3, p);
                int idx = Integer.parseInt(id.substring(p + 1));
                if (id.startsWith("AB.")) {
                    return Boolean.toString(cfg.getBooleanArray(k)[idx]);
                }
                if (id.startsWith("AW.")) {
                    return Byte.toString(cfg.getByteArray(k)[idx]);
                }
                if (id.startsWith("AS.")) {
                    return Short.toString(cfg.getShortArray(k)[idx]);
                }
                if (id.startsWith("AI.")) {
                    return Integer.toString(cfg.getIntArray(k)[idx]);
                }
                if (id.startsWith("AL.")) {
                    return Long.toString(cfg.getLongArray(k)[idx]);
                }
                if (id.startsWith("AF.")) {
                    return Utils.formatNumber(cfg.getFloatArray(k)[idx], 3, 0);
                }
                if (id.startsWith("AD.")) {
                    return Utils.formatNumber(cfg.getDoubleArray(k)[idx], 3, 0);
                }
                if (id.startsWith("AT.")) {
                    return cfg.getStringArray(k)[idx];
                }
            }
            catch (Exception p) {}
        } else {
            String k = id.substring(2);
            if (id.startsWith("B.")) {
                return Boolean.toString(cfg.getBoolean(k, false));
            }
            if (id.startsWith("W.")) {
                return Byte.toString(cfg.getByte(k, (byte)0));
            }
            if (id.startsWith("S.")) {
                return Short.toString(cfg.getShort(k, (short)0));
            }
            if (id.startsWith("I.")) {
                return Integer.toString(cfg.getInt(k, 0));
            }
            if (id.startsWith("L.")) {
                return Long.toString(cfg.getLong(k, 0L));
            }
            if (id.startsWith("F.")) {
                return Utils.formatNumber(cfg.getFloat(k, 0.0f), 3, 0);
            }
            if (id.startsWith("D.")) {
                return Utils.formatNumber(cfg.getDouble(k, 0.0), 3, 0);
            }
            if (id.startsWith("T.")) {
                return cfg.getString(k, "");
            }
        }
        return "";
    }

    public static String getLocFormat(String s) {
        int q;
        s = I18n.func_74838_a((String)s).trim().replace("\\n", "\n");
        int p = 0;
        while ((q = s.indexOf("\\<", p)) >= p && (p = s.indexOf(">", q)) > q) {
            String id = s.substring(q + 2, p);
            int x = id.indexOf(":");
            String repl = x <= 0 ? id : id.substring(0, x);
            for (ConfigurationFile cfg : configurations) {
                if (cfg.getObject(repl) == null) continue;
                repl = TooltipInfo.formatReference(id, cfg);
                break;
            }
            s = s.replace("\\<" + id + ">", repl);
            p = q + repl.length();
        }
        return s;
    }

    public static String format(String s, Object ... args) {
        s = I18n.func_74838_a((String)s).trim().replace("\\n", "\n");
        try {
            return String.format(s, args);
        }
        catch (IllegalFormatException e) {
            return s + "\n" + e.toString();
        }
    }

    static {
        sides = new String[]{"B", "T", "N", "S", "W", "E"};
        configurations = new ArrayList();
    }
}

